/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.ap.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldButton;
import com.adobe.internal.pdftoolkit.services.ap.extension.ButtonApProvider;
import com.adobe.internal.pdftoolkit.services.ap.impl.CheckBoxAPProviderImpl;
import com.adobe.internal.pdftoolkit.services.ap.impl.PushButtonApProviderImpl;
import com.adobe.internal.pdftoolkit.services.ap.impl.RadioButtonApProviderImpl;
import com.adobe.internal.pdftoolkit.services.ap.spi.APResources;

public class ButtonApProviderFactory {
    public static ButtonApProvider getButtonApProvider(PDFFieldButton buttonField, APResources apResources) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFDocument pdfDocument = buttonField.getPDFDocument();
        if (buttonField.isPushButton()) {
            return PushButtonApProviderImpl.getInstance(apResources, pdfDocument);
        }
        if (buttonField.isRadioButton()) {
            return RadioButtonApProviderImpl.getInstance(apResources, pdfDocument);
        }
        if (buttonField.isCheckBox()) {
            return CheckBoxAPProviderImpl.getInstance(apResources, pdfDocument);
        }
        throw new PDFInvalidParameterException("Cant determine the type of the button field (Object number: " + buttonField.getCosObject().getObjNum() + ")");
    }
}

