/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.ap.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.pdf.content.InstructionFactory;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ContentWriter;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFExtGState;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWidget;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAppearanceCharacteristics;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFBorder;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFBorderStyle;
import com.adobe.internal.pdftoolkit.services.ap.impl.AppearanceUtils;

public class BorderAppearanceUtils {
    private static final double[] COLOR_WHITE = new double[]{1.0};
    private static final double[] COLOR_BLACK = new double[]{0.0};
    private static final double[] COLOR_LIGHT_GRAY = new double[]{BorderAppearanceUtils.asFixedToDouble(49344)};
    private static final double[] COLOR_DARK_GRAY = new double[]{BorderAppearanceUtils.asFixedToDouble(32896)};
    private static final double[] COLOR_TRANSPARENT = new double[0];

    static double asFixedToDouble(int value) {
        return ((double)value - 0.5) / 65536.0;
    }

    private static boolean isTransparent(double[] color) {
        return color.length == 0;
    }

    public static void writeAppearance(ContentWriter writer, boolean bFogged, boolean bCircular, boolean bOnlyBorder, PDFAnnotationWidget annot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFAppearanceCharacteristics appearanceCharacteristicsDict = annot.getAppearanceCharacteristics();
        double[] borC = COLOR_TRANSPARENT;
        double[] bkgC = COLOR_TRANSPARENT;
        if (!bOnlyBorder) {
            double[] dArray = bkgC = appearanceCharacteristicsDict == null ? null : appearanceCharacteristicsDict.getBackgroundColor();
            if (bkgC == null) {
                bkgC = COLOR_TRANSPARENT;
            }
        }
        if (bFogged && BorderAppearanceUtils.isTransparent(bkgC)) {
            bkgC = new double[]{1.0, 1.0, 1.0};
        }
        BorderInfo pdwb = BorderAppearanceUtils.getBorderInfo(annot);
        double[] dArray = borC = appearanceCharacteristicsDict == null ? null : appearanceCharacteristicsDict.getBorderColor();
        if (borC == null) {
            borC = COLOR_TRANSPARENT;
        }
        ASRectangle annotBBox = AppearanceUtils.getBBoxRectangle(annot).getRectangle();
        ASRectangle fr = new ASRectangle(0.0, 0.0, annotBBox.width(), annotBBox.height());
        if (bCircular) {
            BorderAppearanceUtils.drawCircularBorder(writer, fr, pdwb.getStyle(), pdwb.getWidth(), borC, bkgC, bFogged);
        } else {
            BorderAppearanceUtils.drawBorder(writer, fr, pdwb.getStyle(), pdwb.getWidth(), borC, bkgC, bFogged, false, 0, annot.getHighlightingMode() == PDFAnnotationWidget.HighlightingMode.Push);
        }
    }

    private static void drawCircularBorder(ContentWriter writer, ASRectangle fr, PDFBorderStyle.Style nStyle, double fxWidth, double[] pdcvBorder, double[] pdcvBkgnd, boolean bDown) throws PDFIOException, PDFInvalidParameterException {
        double[] pdcvDarker;
        if (BorderAppearanceUtils.isTransparent(pdcvBkgnd) || pdcvBkgnd.length == 1) {
            pdcvDarker = new double[]{BorderAppearanceUtils.asFixedToDouble(49344)};
        } else {
            double factor = BorderAppearanceUtils.asFixedToDouble(16448);
            pdcvDarker = new double[]{Math.min(1.0, pdcvBkgnd[0] - factor), Math.min(1.0, pdcvBkgnd[1] - factor), Math.min(1.0, pdcvBkgnd[2] - factor)};
        }
        switch (nStyle) {
            case Underline: 
            case Solid: {
                BorderAppearanceUtils.drawFlatCircularBorder(writer, fr, fxWidth, pdcvBorder, bDown && !BorderAppearanceUtils.isTransparent(pdcvBkgnd) ? pdcvDarker : pdcvBkgnd, false);
                break;
            }
            case Dashed: {
                BorderAppearanceUtils.drawFlatCircularBorder(writer, fr, fxWidth, pdcvBorder, bDown && !BorderAppearanceUtils.isTransparent(pdcvBkgnd) ? pdcvDarker : pdcvBkgnd, true);
                break;
            }
            case Beveled: {
                if (bDown) {
                    BorderAppearanceUtils.draw3DCircularBorder(writer, fr, fxWidth, pdcvBorder, pdcvDarker, COLOR_WHITE, pdcvBkgnd);
                    break;
                }
                BorderAppearanceUtils.draw3DCircularBorder(writer, fr, fxWidth, pdcvBorder, COLOR_WHITE, pdcvDarker, pdcvBkgnd);
                break;
            }
            case Inset: {
                if (bDown) {
                    BorderAppearanceUtils.draw3DCircularBorder(writer, fr, fxWidth, pdcvBorder, COLOR_BLACK, COLOR_WHITE, pdcvDarker);
                    break;
                }
                BorderAppearanceUtils.draw3DCircularBorder(writer, fr, fxWidth, pdcvBorder, COLOR_DARK_GRAY, COLOR_LIGHT_GRAY, pdcvBkgnd);
            }
        }
    }

    private static void drawBorder(ContentWriter writer, ASRectangle fr, PDFBorderStyle.Style nStyle, double fxWidth, double[] pdcvBorder, double[] pdcvBkgnd, boolean bDown, boolean bComb, int nCombs, boolean bPushHighlight) throws PDFIOException, PDFInvalidParameterException, PDFInvalidDocumentException, PDFSecurityException {
        double[] pdcvDarker;
        if (BorderAppearanceUtils.isTransparent(pdcvBkgnd) || pdcvBkgnd.length == 1) {
            pdcvDarker = new double[]{BorderAppearanceUtils.asFixedToDouble(49344)};
        } else {
            double factor = BorderAppearanceUtils.asFixedToDouble(16448);
            pdcvDarker = new double[]{Math.min(1.0, pdcvBkgnd[0] - factor), Math.min(1.0, pdcvBkgnd[1] - factor), Math.min(1.0, pdcvBkgnd[2] - factor)};
        }
        switch (nStyle) {
            case Solid: {
                if (!bPushHighlight || !bDown) {
                    BorderAppearanceUtils.drawFlatBorder(writer, fr, fxWidth, pdcvBorder, bDown && !BorderAppearanceUtils.isTransparent(pdcvBkgnd) ? pdcvDarker : pdcvBkgnd, false, bComb, nCombs);
                    break;
                }
                BorderAppearanceUtils.draw3DBorder(writer, fr, fxWidth, pdcvBorder, pdcvDarker, COLOR_TRANSPARENT, pdcvBkgnd, false, false);
                break;
            }
            case Dashed: {
                if (!bPushHighlight || !bDown) {
                    BorderAppearanceUtils.drawFlatBorder(writer, fr, fxWidth, pdcvBorder, bDown && !BorderAppearanceUtils.isTransparent(pdcvBkgnd) ? pdcvDarker : pdcvBkgnd, true, bComb, nCombs);
                    break;
                }
                BorderAppearanceUtils.draw3DBorder(writer, fr, fxWidth, pdcvBorder, pdcvDarker, COLOR_TRANSPARENT, pdcvBkgnd, true, false);
                break;
            }
            case Underline: {
                if (!bPushHighlight || !bDown) {
                    BorderAppearanceUtils.drawUnderline(writer, fr, fxWidth, pdcvBorder, pdcvBkgnd);
                    break;
                }
                BorderAppearanceUtils.draw3DBorder(writer, fr, fxWidth, pdcvBorder, pdcvDarker, COLOR_TRANSPARENT, pdcvBkgnd, false, true);
                break;
            }
            case Beveled: {
                if (bDown) {
                    BorderAppearanceUtils.draw3DBorder(writer, fr, fxWidth, pdcvBorder, pdcvDarker, COLOR_WHITE, pdcvBkgnd, false, false);
                    break;
                }
                BorderAppearanceUtils.draw3DBorder(writer, fr, fxWidth, pdcvBorder, COLOR_WHITE, pdcvDarker, pdcvBkgnd, false, false);
                break;
            }
            case Inset: {
                if (bDown) {
                    BorderAppearanceUtils.draw3DBorder(writer, fr, fxWidth, pdcvBorder, COLOR_BLACK, COLOR_WHITE, pdcvDarker, false, false);
                    break;
                }
                BorderAppearanceUtils.draw3DBorder(writer, fr, fxWidth, pdcvBorder, COLOR_DARK_GRAY, COLOR_LIGHT_GRAY, pdcvBkgnd, false, false);
            }
        }
    }

    private static BorderInfo getBorderInfo(PDFAnnotationWidget annot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        BorderInfo borderInfo = new BorderInfo(1.0, PDFBorderStyle.Style.Solid);
        PDFBorderStyle coBorderStyle = annot.getBorderStyle();
        if (coBorderStyle == null) {
            PDFBorder border = annot.getBorder();
            if (border != null) {
                if (border.size() >= 4) {
                    borderInfo.setStyle(PDFBorderStyle.Style.Dashed);
                } else {
                    borderInfo.setStyle(PDFBorderStyle.Style.Solid);
                }
                borderInfo.setWidth(border.getWidth());
            }
        } else {
            PDFBorderStyle.Style style = coBorderStyle.getStyle();
            if (style != null) {
                borderInfo.setStyle(style);
            }
            borderInfo.setWidth(coBorderStyle.getWidth());
        }
        return borderInfo;
    }

    private static void drawFlatCircularBorder(ContentWriter writer, ASRectangle fr, double fxBorder, double[] pdcvBorder, double[] pdcvBkgnd, boolean bDashed) throws PDFIOException, PDFInvalidParameterException {
        boolean bBkgnd = !BorderAppearanceUtils.isTransparent(pdcvBkgnd);
        boolean bBorder = !BorderAppearanceUtils.isTransparent(pdcvBorder);
        double fxRadius = Math.min(fr.width(), fr.height()) / 2.0;
        if (bBkgnd) {
            BorderAppearanceUtils.drawCircle(fr.left() + fr.width() / 2.0, fr.bottom() + fr.height() / 2.0, fxRadius, pdcvBkgnd, PathOperation.FILL, writer);
        }
        if (bBorder) {
            writer.write(InstructionFactory.newLineWidth(fxBorder));
            if (bDashed) {
                writer.write(InstructionFactory.newLineDashPattern(new double[]{3.0}, 0));
            }
            BorderAppearanceUtils.drawCircle(fr.left() + fr.width() / 2.0, fr.bottom() + fr.height() / 2.0, fxRadius - fxBorder / 2.0, pdcvBorder, PathOperation.CLOSE_PATH_STROKE, writer);
        }
    }

    private static void draw3DCircularBorder(ContentWriter writer, ASRectangle fr, double fxBorder, double[] pdcvBorder, double[] pdcvHighlight, double[] pdcvShadow, double[] pdcvBkgnd) throws PDFIOException, PDFInvalidParameterException {
        boolean bBkgnd = !BorderAppearanceUtils.isTransparent(pdcvBkgnd);
        boolean bBorder = !BorderAppearanceUtils.isTransparent(pdcvBorder);
        double fxRadius = Math.min(fr.width(), fr.height()) / 2.0;
        if (bBkgnd) {
            BorderAppearanceUtils.drawCircle(fr.left() + fr.width() / 2.0, fr.bottom() + fr.height() / 2.0, fxRadius, pdcvBkgnd, PathOperation.FILL, writer);
        }
        writer.write(InstructionFactory.newLineWidth(fxBorder));
        if (bBorder) {
            BorderAppearanceUtils.drawCircle(fr.left() + fr.width() / 2.0, fr.bottom() + fr.height() / 2.0, fxRadius - fxBorder / 2.0, pdcvBorder, PathOperation.CLOSE_PATH_STROKE, writer);
        }
        if (!BorderAppearanceUtils.isTransparent(pdcvHighlight)) {
            writer.write(InstructionFactory.newColorStroke(pdcvHighlight));
            BorderAppearanceUtils.drawCircularCorner(writer, fr.left() + fr.width() / 2.0, fr.bottom() + fr.height() / 2.0, fxRadius - fxBorder * 1.5, true);
        }
        if (!BorderAppearanceUtils.isTransparent(pdcvShadow)) {
            writer.write(InstructionFactory.newColorStroke(pdcvShadow));
            BorderAppearanceUtils.drawCircularCorner(writer, fr.left() + fr.width() / 2.0, fr.bottom() + fr.height() / 2.0, fxRadius - fxBorder * 1.5, false);
        }
    }

    private static void draw3DBorder(ContentWriter writer, ASRectangle fr, double fxBorder, double[] pdcvBorder, double[] pdcvHighlight, double[] pdcvShadow, double[] pdcvBkgnd, boolean bDashed, boolean bUnderline) throws PDFIOException, PDFInvalidParameterException {
        if (!BorderAppearanceUtils.isTransparent(pdcvBkgnd)) {
            writer.write(InstructionFactory.newColorFill(pdcvBkgnd));
            writer.write(InstructionFactory.newRectangle(fr.left(), fr.bottom(), fr.width(), fr.height()));
            writer.write(InstructionFactory.newFillPath());
        }
        ASRectangle frInside = fr;
        if (fxBorder < Math.min(fr.width(), fr.height())) {
            frInside = new ASRectangle(fr.left() + fxBorder, fr.bottom() + fxBorder, fr.right() - fxBorder, fr.top() - fxBorder);
        }
        if (!BorderAppearanceUtils.isTransparent(pdcvHighlight)) {
            writer.write(InstructionFactory.newColorFill(pdcvHighlight));
            BorderAppearanceUtils.drawCorner(writer, frInside, fxBorder, true);
        }
        if (!BorderAppearanceUtils.isTransparent(pdcvShadow)) {
            writer.write(InstructionFactory.newColorFill(pdcvShadow));
            BorderAppearanceUtils.drawCorner(writer, frInside, fxBorder, false);
        }
        if (!BorderAppearanceUtils.isTransparent(pdcvBorder)) {
            writer.write(InstructionFactory.newColorStroke(pdcvBorder));
            writer.write(InstructionFactory.newLineWidth(fxBorder));
            if (bDashed) {
                writer.write(InstructionFactory.newLineDashPattern(new double[]{3.0}, 0));
            }
            if (!bUnderline) {
                writer.write(InstructionFactory.newRectangle(fr.left() + fxBorder / 2.0, fr.bottom() + fxBorder / 2.0, fr.width() - fxBorder, fr.height() - fxBorder));
            } else {
                writer.write(InstructionFactory.newMoveTo(fr.left(), fr.bottom() + fxBorder / 2.0));
                writer.write(InstructionFactory.newLineTo(fr.width(), fr.bottom() + fxBorder / 2.0));
            }
            writer.write(InstructionFactory.newCloseAndStrokePath());
        }
    }

    private static void drawFlatBorder(ContentWriter writer, ASRectangle fr, double fxBorder, double[] pdcvBorder, double[] pdcvBkgnd, boolean bDashed, boolean bComb, int nCombs) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException, PDFInvalidParameterException {
        boolean bBorder;
        double fxWidth = fr.width();
        double fxHeight = fr.height();
        boolean bBkgnd = !BorderAppearanceUtils.isTransparent(pdcvBkgnd);
        boolean bl = bBorder = !BorderAppearanceUtils.isTransparent(pdcvBorder);
        if (bBkgnd) {
            writer.write(InstructionFactory.newColorFill(pdcvBkgnd));
            writer.write(InstructionFactory.newRectangle(fr.left(), fr.bottom(), fxWidth, fxHeight));
            writer.write(InstructionFactory.newFillPath());
        }
        if (bBorder) {
            writer.write(InstructionFactory.newColorStroke(pdcvBorder));
            writer.write(InstructionFactory.newLineWidth(fxBorder));
            if (bDashed) {
                writer.write(InstructionFactory.newLineDashPattern(new double[]{3.0}, 0));
            }
            writer.write(InstructionFactory.newRectangle(fr.left() + fxBorder / 2.0, fr.bottom() + fxBorder / 2.0, fxWidth - fxBorder, fxHeight - fxBorder));
            writer.write(InstructionFactory.newCloseAndStrokePath());
            if (bComb) {
                double fxCombWidth = fxWidth / (double)nCombs;
                double fxLine = fr.left() + fxCombWidth;
                for (int i = 0; i < nCombs - 1; ++i) {
                    writer.write(InstructionFactory.newMoveTo(fxLine, fxHeight - fxBorder));
                    writer.write(InstructionFactory.newLineTo(fxLine, fr.bottom() + fxBorder / 2.0));
                    fxLine += fxCombWidth;
                }
                writer.write(InstructionFactory.newCloseAndStrokePath());
            }
        }
    }

    private static void drawUnderline(ContentWriter writer, ASRectangle fr, double fxBorder, double[] pdcvBorder, double[] pdcvBkgnd) throws PDFIOException, PDFInvalidParameterException {
        boolean bBorder;
        double fxWidth = fr.width();
        boolean bBkgnd = !BorderAppearanceUtils.isTransparent(pdcvBkgnd);
        boolean bl = bBorder = !BorderAppearanceUtils.isTransparent(pdcvBorder);
        if (bBkgnd) {
            writer.write(InstructionFactory.newColorFill(pdcvBkgnd));
            writer.write(InstructionFactory.newRectangle(fr.left(), fr.bottom(), fxWidth, fr.height()));
            writer.write(InstructionFactory.newFillPath());
        }
        if (bBorder) {
            writer.write(InstructionFactory.newColorStroke(pdcvBorder));
            writer.write(InstructionFactory.newLineWidth(fxBorder));
            writer.write(InstructionFactory.newMoveTo(fr.left(), fr.bottom() + fxBorder / 2.0));
            writer.write(InstructionFactory.newLineTo(fxWidth, fr.bottom() + fxBorder / 2.0));
            writer.write(InstructionFactory.newCloseAndStrokePath());
        }
    }

    static void drawCircle(double fxCenterX, double fxCenterY, double fxRadius, double[] color, PathOperation pathOperation, ContentWriter writer) throws PDFIOException, PDFInvalidParameterException {
        switch (pathOperation) {
            case FILL: {
                Instruction colorInstr = InstructionFactory.newColorFill(color);
                if (colorInstr == null) break;
                writer.write(colorInstr);
                break;
            }
            case STROKE: 
            case CLOSE_PATH_STROKE: {
                Instruction colorInstr = InstructionFactory.newColorStroke(color);
                if (colorInstr == null) break;
                writer.write(colorInstr);
                break;
            }
        }
        double fxRatio = 0.5523 * fxRadius;
        writer.write(InstructionFactory.newGSave());
        writer.write(InstructionFactory.newConcatMatrix(1.0, 0.0, 0.0, 1.0, fxCenterX, fxCenterY));
        writer.write(InstructionFactory.newMoveTo(fxRadius, 0.0));
        writer.write(InstructionFactory.newCurveTo(fxRadius, fxRatio, fxRatio, fxRadius, 0.0, fxRadius));
        writer.write(InstructionFactory.newCurveTo(-fxRatio, fxRadius, -fxRadius, fxRatio, -fxRadius, 0.0));
        writer.write(InstructionFactory.newCurveTo(-fxRadius, -fxRatio, -fxRatio, -fxRadius, 0.0, -fxRadius));
        writer.write(InstructionFactory.newCurveTo(fxRatio, -fxRadius, fxRadius, -fxRatio, fxRadius, 0.0));
        switch (pathOperation) {
            case FILL: {
                writer.write(InstructionFactory.newFillPath());
                break;
            }
            case STROKE: {
                writer.write(InstructionFactory.newStrokePath());
                break;
            }
            case CLOSE_PATH_STROKE: {
                writer.write(InstructionFactory.newCloseAndStrokePath());
                break;
            }
            case CLIP: {
                writer.write(InstructionFactory.newClipPath());
            }
        }
        writer.write(InstructionFactory.newGRestore());
    }

    private static void drawCircularCorner(ContentWriter writer, double fxCenterX, double fxCenterY, double fxRadius, boolean bTopLeft) throws PDFIOException {
        double fxRatio = 0.5523 * fxRadius;
        double fxVal = 0.7071;
        writer.write(InstructionFactory.newGSave());
        writer.write(InstructionFactory.newConcatMatrix(fxVal, fxVal, -fxVal, fxVal, fxCenterX, fxCenterY));
        if (bTopLeft) {
            writer.write(InstructionFactory.newMoveTo(fxRadius, 0.0));
            writer.write(InstructionFactory.newCurveTo(fxRadius, fxRatio, fxRatio, fxRadius, 0.0, fxRadius));
            writer.write(InstructionFactory.newCurveTo(-fxRatio, fxRadius, -fxRadius, fxRatio, -fxRadius, 0.0));
            writer.write(InstructionFactory.newStrokePath());
        } else {
            writer.write(InstructionFactory.newMoveTo(-fxRadius, 0.0));
            writer.write(InstructionFactory.newCurveTo(-fxRadius, -fxRatio, -fxRatio, -fxRadius, 0.0, -fxRadius));
            writer.write(InstructionFactory.newCurveTo(fxRatio, -fxRadius, fxRadius, -fxRatio, fxRadius, 0.0));
            writer.write(InstructionFactory.newStrokePath());
        }
        writer.write(InstructionFactory.newGRestore());
    }

    private static void drawCorner(ContentWriter writer, ASRectangle fr, double fxBorder, boolean bTopLeft) throws PDFIOException {
        if (bTopLeft) {
            writer.write(InstructionFactory.newMoveTo(fr.left(), fr.bottom()));
            writer.write(InstructionFactory.newLineTo(fr.left(), fr.top()));
            writer.write(InstructionFactory.newLineTo(fr.right(), fr.top()));
            writer.write(InstructionFactory.newLineTo(fr.right() - fxBorder, fr.top() - fxBorder));
            writer.write(InstructionFactory.newLineTo(fr.left() + fxBorder, fr.top() - fxBorder));
            writer.write(InstructionFactory.newLineTo(fr.left() + fxBorder, fr.bottom() + fxBorder));
            writer.write(InstructionFactory.newFillPath());
        } else {
            writer.write(InstructionFactory.newMoveTo(fr.right(), fr.top()));
            writer.write(InstructionFactory.newLineTo(fr.right(), fr.bottom()));
            writer.write(InstructionFactory.newLineTo(fr.left(), fr.bottom()));
            writer.write(InstructionFactory.newLineTo(fr.left() + fxBorder, fr.bottom() + fxBorder));
            writer.write(InstructionFactory.newLineTo(fr.right() - fxBorder, fr.bottom() + fxBorder));
            writer.write(InstructionFactory.newLineTo(fr.right() - fxBorder, fr.top() - fxBorder));
            writer.write(InstructionFactory.newFillPath());
        }
    }

    static void drawCheck(ContentWriter writer, ASRectangle frClip, double[] color) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException, PDFInvalidParameterException {
        double fxOffset;
        if ((frClip = new ASRectangle(frClip.left() + 1.0, frClip.bottom() + 1.0, frClip.right() - 1.0, frClip.top() - 1.0)).width() > frClip.height()) {
            fxOffset = (frClip.width() - frClip.height()) / 2.0;
            double newLeft = frClip.left() + fxOffset;
            double newRight = newLeft + frClip.height();
            frClip = new ASRectangle(newLeft, frClip.bottom(), newRight, frClip.top());
        } else {
            fxOffset = (frClip.height() - frClip.width()) / 2.0;
            double newBottom = frClip.bottom() + fxOffset;
            double newTop = newBottom + frClip.width();
            frClip = new ASRectangle(frClip.left(), newBottom, frClip.right(), newTop);
        }
        frClip = frClip.normalized();
        writer.write(InstructionFactory.newLineDashPattern(new double[0], 0));
        Instruction colorInstr = InstructionFactory.newColorStroke(color);
        if (colorInstr != null) {
            writer.write(colorInstr);
        }
        writer.write(InstructionFactory.newLineWidth(1.0));
        writer.write(InstructionFactory.newMoveTo(frClip.left(), frClip.top()));
        writer.write(InstructionFactory.newLineTo(frClip.right(), frClip.bottom()));
        writer.write(InstructionFactory.newMoveTo(frClip.right(), frClip.top()));
        writer.write(InstructionFactory.newLineTo(frClip.left(), frClip.bottom()));
        writer.write(InstructionFactory.newStrokePath());
    }

    static void addOpacity(ContentWriter writer, double fxOpacity, double[] pdFillColor, boolean bWrap, PDFAnnotationWidget annot, double bWidth) throws PDFIOException, PDFInvalidParameterException, PDFInvalidDocumentException, PDFSecurityException {
        if (bWrap) {
            writer.write(InstructionFactory.newGSave());
        }
        PDFExtGState extGStateDict = PDFExtGState.newInstance(annot.getPDFDocument());
        extGStateDict.setOpacityFill(fxOpacity);
        writer.write(extGStateDict);
        ASRectangle m_frBBox = annot.getRect().getRectangle();
        writer.write(InstructionFactory.newColorFill(pdFillColor == null ? COLOR_WHITE : pdFillColor));
        writer.write(InstructionFactory.newRectangle(bWidth, bWidth, m_frBBox.width() - 2.0 * bWidth, m_frBBox.height() - 2.0 * bWidth));
        writer.write(InstructionFactory.newFillPath());
        if (bWrap) {
            writer.write(InstructionFactory.newGRestore());
        }
    }

    private static class BorderInfo {
        private double width;
        private PDFBorderStyle.Style style;

        BorderInfo(double width, PDFBorderStyle.Style style) {
            this.width = width;
            this.style = style;
        }

        double getWidth() {
            return this.width;
        }

        void setWidth(double width) {
            this.width = width;
        }

        PDFBorderStyle.Style getStyle() {
            return this.style;
        }

        void setStyle(PDFBorderStyle.Style style) {
            this.style = style;
        }
    }

    static enum PathOperation {
        FILL,
        STROKE,
        CLOSE_PATH_STROKE,
        CLIP;

    }
}

