/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.Jpeg2000;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Box;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000BoxInfo;
import java.io.IOException;

public class UUIDBox
extends Jpeg2000Box {
    private InputByteStream id;
    private InputByteStream data;

    UUIDBox(Jpeg2000BoxInfo boxInfo) {
        this.boxInfo = boxInfo;
    }

    public InputByteStream getID() throws IOException {
        this.lazilyPopulateFields();
        return this.id != null ? this.id.slice() : null;
    }

    public InputByteStream getData() throws IOException {
        this.lazilyPopulateFields();
        return this.data != null ? this.data.slice() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void lazilyPopulateFields() throws IOException {
        InputByteStream boxContents = this.boxInfo.getBoxContents();
        if (boxContents == null) {
            return;
        }
        try {
            this.id = boxContents.slice(boxContents.getPosition(), 16L);
            this.data = boxContents.slice(16L, boxContents.bytesAvailable() - 16L);
        }
        finally {
            this.boxInfo.clearContents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void close() throws IOException {
        try {
            if (this.id != null) {
                this.id.close();
            }
        }
        finally {
            try {
                if (this.data != null) {
                    this.data.close();
                }
            }
            finally {
                this.boxInfo.clearContents();
            }
        }
    }
}

