/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.Jpeg2000;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.DataEntryURLBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Box;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000BoxInfo;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000BoxType;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000BoxesList;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Utils;
import java.io.IOException;

public class DataReferenceBox
extends Jpeg2000Box {
    private int numberOfDataReferences;
    private Jpeg2000BoxesList<DataEntryURLBox> dataReferenceURLs;

    DataReferenceBox(Jpeg2000BoxInfo boxInfo) {
        this.boxInfo = boxInfo;
    }

    public int getNumberOfDataReferences() throws IOException {
        this.lazilyPopulateFields();
        return this.numberOfDataReferences;
    }

    public Jpeg2000BoxesList<DataEntryURLBox> getDataReferenceURLs() throws IOException {
        this.lazilyPopulateFields();
        return this.dataReferenceURLs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void lazilyPopulateFields() throws IOException {
        InputByteStream boxContents = this.boxInfo.getBoxContents();
        if (boxContents == null) {
            return;
        }
        try {
            this.numberOfDataReferences = Jpeg2000Utils.bytesToInteger(boxContents, 2);
            this.dataReferenceURLs = new Jpeg2000BoxesList();
            while (boxContents.bytesAvailable() > 0L) {
                Jpeg2000BoxInfo innerBoxInfo = new Jpeg2000BoxInfo(boxContents);
                if (innerBoxInfo.getType() != Jpeg2000BoxType.dataEntryURLBox) continue;
                this.dataReferenceURLs.add(new DataEntryURLBox(innerBoxInfo));
            }
        }
        finally {
            this.boxInfo.clearContents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void close() throws IOException {
        try {
            if (this.dataReferenceURLs != null) {
                this.dataReferenceURLs.close();
            }
        }
        finally {
            this.boxInfo.clearContents();
        }
    }
}

