/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.rendering;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFStream;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFFunction;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFFunctionFactory;
import com.adobe.internal.pdftoolkit.pdf.rendering.PDFHalfToneType;
import com.adobe.internal.pdftoolkit.pdf.rendering.PDFHalftoneWithFunction;

public class PDFHalftoneType1
extends PDFHalftoneWithFunction {
    private PDFHalftoneType1(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosObject);
    }

    public static PDFHalftoneType1 newInstance(PDFDocument pdfDocument, PDFFunction key_SpotFunction, double key_Frequency, double key_Angle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (key_SpotFunction == null) {
            throw new PDFInvalidParameterException("SpotFunction is required when creating newInstance of PDFHalftoneType1.");
        }
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFHalftoneType1 pdfObject = new PDFHalftoneType1(cosObject);
        pdfObject.setHalftoneType(PDFHalfToneType.HALFTONE_TYPE1);
        pdfObject.setSpotFunction(key_SpotFunction);
        pdfObject.setFrequency(key_Frequency);
        pdfObject.setAngle(key_Angle);
        return pdfObject;
    }

    public static PDFHalftoneType1 getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFHalftoneType1 pdfObject = (PDFHalftoneType1)PDFCosObject.getCachedInstance(cosObject, PDFHalftoneType1.class);
        if (pdfObject == null) {
            pdfObject = new PDFHalftoneType1(cosObject);
        }
        return pdfObject;
    }

    public double getFrequency() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDoubleValue(ASName.k_Frequency);
    }

    public void setFrequency(double value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryDoubleValue(ASName.k_Frequency, value);
    }

    public double requireFrequency() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDoubleValue(ASName.k_Frequency);
    }

    public boolean hasFrequency() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Frequency);
    }

    public PDFFunction getSpotFunctionAsDict() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFFunctionFactory.getInstance(this.getDictionaryCosObjectValue(ASName.k_SpotFunction));
    }

    public void setSpotFunction(PDFFunction value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("SpotFunction is a required key therefore cannot be removed.");
        }
        this.setDictionaryValue(ASName.k_SpotFunction, value);
    }

    public ASName getSpotFunctionAsName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName name = this.getDictionaryNameValue(ASName.k_SpotFunction);
        if (name == null) {
            throw new PDFInvalidDocumentException("Unable to retrieve the Object");
        }
        return name;
    }

    public void setSpotFunction(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("SpotFunction is a required key therefore cannot be removed.");
        }
        this.setDictionaryNameValue(ASName.k_SpotFunction, value);
    }

    public PDFStream getSpotFunctionAsStream() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getDictionaryValue(ASName.k_SpotFunction);
        return PDFStream.getInstance(cosObject);
    }

    public void setSpotFunction(PDFStream value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("SpotFunction is a required key therefore cannot be removed.");
        }
        this.setDictionaryValue(ASName.k_SpotFunction, value);
    }

    public boolean hasSpotFunction() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_SpotFunction);
    }

    public boolean getAccurateScreens() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryBooleanValue(ASName.k_AccurateScreens);
    }

    public void setAccurateScreens(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_AccurateScreens, value);
    }

    public boolean hasAccurateScreens() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_AccurateScreens);
    }

    public double getAngle() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDoubleValue(ASName.k_Angle);
    }

    public void setAngle(double value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryDoubleValue(ASName.k_Angle, value);
    }

    public double requireAngle() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDoubleValue(ASName.k_Angle);
    }

    public boolean hasAngle() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Angle);
    }
}

