/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.rendering;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.rendering.PDFHalfToneType;
import com.adobe.internal.pdftoolkit.pdf.rendering.PDFHalftone;
import com.adobe.internal.pdftoolkit.pdf.rendering.PDFHalftoneType1;
import com.adobe.internal.pdftoolkit.pdf.rendering.PDFHalftoneType10;
import com.adobe.internal.pdftoolkit.pdf.rendering.PDFHalftoneType16;
import com.adobe.internal.pdftoolkit.pdf.rendering.PDFHalftoneType5;
import com.adobe.internal.pdftoolkit.pdf.rendering.PDFHalftoneType6;

public class PDFHalfToneFactory {
    public static PDFHalftone getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (cosObject == null) {
            return null;
        }
        if (cosObject.getType() == 0) {
            return null;
        }
        if (!(cosObject instanceof CosDictionary)) {
            throw new PDFInvalidDocumentException("CosDictionary expected");
        }
        int subType = ((CosDictionary)cosObject).getInt(ASName.k_HalftoneType);
        if (subType == PDFHalfToneType.HALFTONE_TYPE1.getValue()) {
            return PDFHalftoneType1.getInstance(cosObject);
        }
        if (subType == PDFHalfToneType.HALFTONE_TYPE5.getValue()) {
            return PDFHalftoneType5.getInstance(cosObject);
        }
        if (subType == PDFHalfToneType.HALFTONE_TYPE6.getValue()) {
            return PDFHalftoneType6.getInstance(cosObject);
        }
        if (subType == PDFHalfToneType.HALFTONE_TYPE10.getValue()) {
            return PDFHalftoneType10.getInstance(cosObject);
        }
        if (subType == PDFHalfToneType.HALFTONE_TYPE16.getValue()) {
            return PDFHalftoneType16.getInstance(cosObject);
        }
        throw new PDFInvalidDocumentException("Bad Halftone");
    }
}

