/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.page;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageLabelStyle;

public class PDFPageLabel
extends PDFCosDictionary {
    private PDFPageLabel(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFPageLabel getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        if (!(cosObject instanceof CosDictionary)) {
            return null;
        }
        PDFPageLabel pdfObject = (PDFPageLabel)PDFCosObject.getCachedInstance(cosObject, PDFPageLabel.class);
        if (pdfObject == null) {
            pdfObject = new PDFPageLabel(cosObject);
        }
        return pdfObject;
    }

    public static PDFPageLabel newInstance(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary pagelabel = PDFCosObject.newCosDictionary(pdfDoc);
        PDFPageLabel newLabel = new PDFPageLabel(pagelabel);
        newLabel.setDictionaryNameValue(ASName.k_Type, ASName.k_PageLabel);
        return newLabel;
    }

    public static PDFPageLabel newInstance(PDFDocument pdfDoc, PDFPageLabel srcLabel) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPageLabel newLabel = PDFPageLabel.newInstance(pdfDoc);
        if (srcLabel != null) {
            PDFPageLabelStyle style;
            newLabel.setStartingNumber(srcLabel.getStartingNumber());
            String prefix = srcLabel.getPrefix();
            if (prefix != null) {
                newLabel.setPrefix(prefix);
            }
            if ((style = srcLabel.getPageLabelStyle()) != null) {
                newLabel.setPageLabelStyle(style);
            }
        }
        return newLabel;
    }

    public String getPrefix() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryTextStringValue(ASName.k_P);
    }

    public void setPrefix(String prefix) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_P, prefix);
    }

    public int getStartingNumber() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.dictionaryContains(ASName.k_St)) {
            return 1;
        }
        return this.getDictionaryIntValue(ASName.k_St);
    }

    public void setStartingNumber(int startingNumber) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_St, startingNumber);
    }

    public PDFPageLabelStyle getPageLabelStyle() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFPageLabelStyle.getInstance(this.getDictionaryNameValue(ASName.k_S));
    }

    public void setPageLabelStyle(PDFPageLabelStyle style) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (style == null) {
            this.removeValue(ASName.k_S);
        } else {
            this.setDictionaryNameValue(ASName.k_S, style.getValue());
        }
    }
}

