/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.multimedia;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFStream;
import com.adobe.internal.pdftoolkit.pdf.document.PDFText;

public class PDFViewParams
extends PDFCosDictionary {
    public static final ASName k_UID = ASName.create("UID");

    private PDFViewParams(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFViewParams newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFViewParams pdfObject = new PDFViewParams(cosObject);
        return pdfObject;
    }

    public static PDFViewParams getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFViewParams pdfObject = (PDFViewParams)PDFCosObject.getCachedInstance(cosObject, PDFViewParams.class);
        if (pdfObject == null) {
            pdfObject = new PDFViewParams(cosObject);
        }
        return pdfObject;
    }

    public int getUID() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(k_UID);
    }

    public void setUID(int value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryIntValue(k_UID, value);
    }

    public PDFText getDataAsTextString() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFText.getInstance(this.getDictionaryCosObjectValue(ASName.k_Data));
    }

    public void setDataAsTextString(PDFText value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("Data is a required key therefore cannot be removed.");
        }
        this.setDictionaryTextValue(ASName.k_Data, value);
    }

    public PDFStream getDataAsStream() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFStream.getInstance(this.getDictionaryCosObjectValue(ASName.k_Data));
    }

    public void setDataAsStream(PDFStream value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("Data is a required key therefore cannot be removed.");
        }
        this.setDictionaryValue(ASName.k_Data, value);
    }
}

