/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.multimedia;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosBoolean;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosString;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFValueContainer;

public class PDFRichMediaCommand
extends PDFCosDictionary {
    private PDFRichMediaCommand(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFRichMediaCommand newInstance(PDFDocument pdfDocument, String commandScript) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (commandScript == null) {
            throw new PDFInvalidParameterException("commandScript is required.");
        }
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFRichMediaCommand pdfObject = new PDFRichMediaCommand(cosObject);
        pdfObject.setCommandScript(commandScript);
        return pdfObject;
    }

    public static PDFRichMediaCommand getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFRichMediaCommand pdfObject = (PDFRichMediaCommand)PDFCosObject.getCachedInstance(cosObject, PDFRichMediaCommand.class);
        if (pdfObject == null) {
            pdfObject = new PDFRichMediaCommand(cosObject);
        }
        return pdfObject;
    }

    public void setType(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (!value.equals(ASName.k_RichMediaCommand)) {
            throw new PDFInvalidParameterException("Type value is not valid. " + ASName.k_RichMediaCommand + " is expected.");
        }
        this.setDictionaryNameValue(ASName.k_Type, value);
    }

    public String getCommandScript() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryTextStringValue(ASName.k_C);
    }

    public void setCommandScript(String commandScript) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_C, commandScript);
    }

    public PDFValueContainer<PDFValueContainer.Type, Object> getCommandArgument() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getCosDictionary().get(ASName.k_A);
        PDFValueContainer<PDFValueContainer.Type, Object> container = null;
        if (cosObject instanceof CosString) {
            container = new PDFValueContainer<PDFValueContainer.Type, Object>(PDFValueContainer.Type.String, cosObject.textValue());
        } else if (cosObject instanceof CosBoolean) {
            container = new PDFValueContainer<PDFValueContainer.Type, Boolean>(PDFValueContainer.Type.Boolean, cosObject.booleanValue());
        } else if (cosObject instanceof CosNumeric) {
            container = new PDFValueContainer<PDFValueContainer.Type, Double>(PDFValueContainer.Type.Double, cosObject.doubleValue());
        } else if (cosObject instanceof CosArray) {
            CosArray array = (CosArray)cosObject;
            int count = array.size();
            CosObject element = array.get(0);
            if (element instanceof CosString) {
                String[] names = new String[count];
                for (int i = 0; i < count; ++i) {
                    names[i] = array.getText(i);
                }
                container = new PDFValueContainer<PDFValueContainer.Type, String[]>(PDFValueContainer.Type.StringArray, names);
            } else if (element instanceof CosBoolean) {
                boolean[] values = new boolean[count];
                for (int i = 0; i < count; ++i) {
                    values[i] = array.getBoolean(i);
                }
                container = new PDFValueContainer<PDFValueContainer.Type, boolean[]>(PDFValueContainer.Type.BooleanArray, values);
            } else if (element instanceof CosNumeric) {
                double[] values = new double[count];
                for (int i = 0; i < count; ++i) {
                    values[i] = array.getDouble(i);
                }
                container = new PDFValueContainer<PDFValueContainer.Type, double[]>(PDFValueContainer.Type.DoubleArray, values);
            }
        }
        return container;
    }

    public void setCommandArgument(String value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_A, value);
    }

    public void setCommandArgument(int value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_A, value);
    }

    public void setCommandArgument(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_A, value);
    }

    public void setCommandArgument(double value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryDoubleValue(ASName.k_A, value);
    }

    public void setCommandArgument(String[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = null;
        if (value != null) {
            cosArray = PDFCosObject.newCosArray(this.getPDFDocument());
            int addAtIndex = 0;
            for (int i = 0; i < value.length; ++i) {
                if (value[i] == null) continue;
                cosArray.addText(addAtIndex++, value[i]);
            }
        }
        this.setDictionaryArrayValue(ASName.k_T, cosArray);
    }

    public void setCommandArgument(int[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = null;
        if (value != null) {
            cosArray = PDFCosObject.newCosArray(this.getPDFDocument());
            int addAtIndex = 0;
            for (int i = 0; i < value.length; ++i) {
                cosArray.addInt(addAtIndex++, value[i]);
            }
        }
        this.setDictionaryArrayValue(ASName.k_T, cosArray);
    }

    public void setCommandArgument(double[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = null;
        if (value != null) {
            cosArray = PDFCosObject.newCosArray(this.getPDFDocument());
            int addAtIndex = 0;
            for (int i = 0; i < value.length; ++i) {
                cosArray.addDouble(addAtIndex++, value[i]);
            }
        }
        this.setDictionaryArrayValue(ASName.k_T, cosArray);
    }

    public void setCommandArgument(boolean[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = PDFCosObject.newCosArray(this.getPDFDocument());
        if (value != null) {
            int addAtIndex = 0;
            for (int i = 0; i < value.length; ++i) {
                cosArray.addBoolean(addAtIndex++, value[i]);
            }
        }
        this.setDictionaryArrayValue(ASName.k_T, cosArray);
    }
}

