/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.multimedia;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;

public class PDFFWParamsDArray
extends PDFCosObject {
    private PDFFWParamsDArray(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFFWParamsDArray newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObject = PDFCosObject.newCosArray(pdfDocument);
        PDFFWParamsDArray pdfObject = new PDFFWParamsDArray(cosObject);
        return pdfObject;
    }

    public static PDFFWParamsDArray getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFFWParamsDArray pdfObject = (PDFFWParamsDArray)PDFCosObject.getCachedInstance(cosObject, PDFFWParamsDArray.class);
        if (pdfObject == null) {
            pdfObject = new PDFFWParamsDArray(cosObject);
        }
        return pdfObject;
    }

    public int getElem0() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosArray() == null) {
            return 0;
        }
        CosObject cosObject = this.getCosArray().get(0);
        if (!(cosObject instanceof CosNumeric)) {
            return 0;
        }
        return ((CosNumeric)cosObject).intValue();
    }

    public void setElem0(int value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosNumeric cosObject = this.getCosObject().getDocument().createCosNumeric(value);
        this.getCosArray().extendIfNecessaryAndSet(0, cosObject);
    }

    public boolean hasElem0() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosArray() == null) {
            return false;
        }
        CosObject cosObject = this.getCosArray().get(0);
        return cosObject != null;
    }

    public int getElem1() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosArray() == null) {
            return 0;
        }
        CosObject cosObject = this.getCosArray().get(1);
        if (!(cosObject instanceof CosNumeric)) {
            return 0;
        }
        return ((CosNumeric)cosObject).intValue();
    }

    public void setElem1(int value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosNumeric cosObject = this.getCosObject().getDocument().createCosNumeric(value);
        this.getCosArray().extendIfNecessaryAndSet(1, cosObject);
    }

    public boolean hasElem1() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosArray() == null) {
            return false;
        }
        CosObject cosObject = this.getCosArray().get(1);
        return cosObject != null;
    }
}

