/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.multimedia;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFText;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DMeasurement;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DVPDict;

public class PDF3DMeasurementAD3
extends PDF3DMeasurement {
    public static final ASName k_AD3 = ASName.create("AD3");
    public static final ASName k_AP = ASName.create("AP");
    public static final ASName k_A1 = ASName.create("A1");
    public static final ASName k_D1 = ASName.create("D1");
    public static final ASName k_N1 = ASName.create("N1");
    public static final ASName k_A2 = ASName.create("A2");
    public static final ASName k_D2 = ASName.create("D2");
    public static final ASName k_N2 = ASName.create("N2");
    public static final ASName k_TP = ASName.create("TP");
    public static final ASName k_TX = ASName.create("TX");
    public static final ASName k_TY = ASName.create("TY");
    public static final ASName k_TS = ASName.create("TS");
    public static final ASName k_C = ASName.create("C");
    public static final ASName k_V = ASName.create("V");
    public static final ASName k_P = ASName.create("P");
    public static final ASName k_UT = ASName.create("UT");
    public static final ASName k_DR = ASName.create("DR");
    public static final ASName k_S = ASName.create("S");

    private PDF3DMeasurementAD3(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDF3DMeasurementAD3 newInstance(PDFDocument pdfDocument, double[] ap, double[] a1, double[] d1, double[] a2, double[] d2, double[] tp, double[] tx, double[] ty, double v) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDF3DMeasurementAD3 pdfObject = new PDF3DMeasurementAD3(cosObject);
        try {
            pdfObject.setSubtype(k_AD3);
        }
        catch (PDFInvalidParameterException e) {
            // empty catch block
        }
        pdfObject.setAP(ap);
        pdfObject.setA1(a1);
        pdfObject.setD1(d1);
        pdfObject.setA2(a2);
        pdfObject.setD2(d2);
        pdfObject.setTP(tp);
        pdfObject.setTX(tx);
        pdfObject.setTY(ty);
        pdfObject.setV(v);
        return pdfObject;
    }

    public static PDF3DMeasurementAD3 getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDF3DMeasurementAD3 pdfObject = (PDF3DMeasurementAD3)PDFCosObject.getCachedInstance(cosObject, PDF3DMeasurementAD3.class);
        if (pdfObject == null) {
            pdfObject = new PDF3DMeasurementAD3(cosObject);
        }
        return pdfObject;
    }

    public double[] getAP() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObject = this.getDictionaryArrayValue(k_AP);
        if (cosObject == null) {
            return null;
        }
        return cosObject.getArrayDouble();
    }

    public void setAP(double[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (value == null) {
            throw new PDFInvalidDocumentException("AP is a required key.");
        }
        this.setDictionaryArrayValue(k_AP, value);
    }

    public boolean hasAP() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_AP);
    }

    public double[] getA1() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObject = this.getDictionaryArrayValue(k_A1);
        if (cosObject == null) {
            return null;
        }
        return cosObject.getArrayDouble();
    }

    public void setA1(double[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (value == null) {
            throw new PDFInvalidDocumentException("A1 is a required key.");
        }
        this.setDictionaryArrayValue(k_A1, value);
    }

    public boolean hasA1() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_A1);
    }

    public double[] getD1() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObject = this.getDictionaryArrayValue(k_D1);
        if (cosObject == null) {
            return null;
        }
        return cosObject.getArrayDouble();
    }

    public void setD1(double[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (value == null) {
            throw new PDFInvalidDocumentException("D1 is a required key.");
        }
        this.setDictionaryArrayValue(k_D1, value);
    }

    public boolean hasD1() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_D1);
    }

    public PDFText getN1() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFText.getInstance(this.getDictionaryCosObjectValue(k_N1));
    }

    public void setN1(PDFText value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryTextValue(k_N1, value);
    }

    public boolean hasN1() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_N1);
    }

    public double[] getA2() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObject = this.getDictionaryArrayValue(k_A2);
        if (cosObject == null) {
            return null;
        }
        return cosObject.getArrayDouble();
    }

    public void setA2(double[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (value == null) {
            throw new PDFInvalidDocumentException("A2 is a required key.");
        }
        this.setDictionaryArrayValue(k_A2, value);
    }

    public boolean hasA2() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_A2);
    }

    public double[] getD2() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObject = this.getDictionaryArrayValue(k_D2);
        if (cosObject == null) {
            return null;
        }
        return cosObject.getArrayDouble();
    }

    public void setD2(double[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (value == null) {
            throw new PDFInvalidDocumentException("D2 is a required key.");
        }
        this.setDictionaryArrayValue(k_D2, value);
    }

    public boolean hasD2() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_D2);
    }

    public PDFText getN2() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFText.getInstance(this.getDictionaryCosObjectValue(k_N2));
    }

    public void setN2(PDFText value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryTextValue(k_N2, value);
    }

    public boolean hasN2() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_N2);
    }

    public double[] getTP() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getDictionaryValue(k_TP);
        if (cosObject instanceof CosArray) {
            return ((CosArray)cosObject).getArrayDouble();
        }
        return null;
    }

    public void setTP(double[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (value == null) {
            throw new PDFInvalidDocumentException("TP is a required key.");
        }
        this.setDictionaryArrayValue(k_TP, value);
    }

    public boolean hasTP() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_TP);
    }

    public double[] getTX() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getDictionaryValue(k_TX);
        if (cosObject instanceof CosArray) {
            return ((CosArray)cosObject).getArrayDouble();
        }
        return null;
    }

    public void setTX(double[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (value == null) {
            throw new PDFInvalidDocumentException("TX is a required key.");
        }
        this.setDictionaryArrayValue(k_TX, value);
    }

    public boolean hasTX() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_TX);
    }

    public double[] getTY() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObject = this.getDictionaryArrayValue(k_TY);
        if (cosObject != null) {
            return cosObject.getArrayDouble();
        }
        return null;
    }

    public void setTY(double[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (value == null) {
            throw new PDFInvalidDocumentException("TY is a required key.");
        }
        this.setDictionaryArrayValue(k_TY, value);
    }

    public boolean hasTY() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_TY);
    }

    public double getTS() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDoubleValue(k_TS);
    }

    public void setTS(double value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryDoubleValue(k_TS, value);
    }

    public boolean hasTS() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_TS);
    }

    public double[] getC() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObject = this.getDictionaryArrayValue(ASName.k_C);
        if (cosObject == null) {
            return null;
        }
        return cosObject.getArrayDouble(1, 3);
    }

    public void setC(double[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            this.removeValue(k_C);
        } else {
            CosArray array = this.setDictionaryArrayValue(k_C, 1, value);
            array.setName(0, ASName.k_DeviceRGB);
        }
    }

    public boolean hasC() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_C);
    }

    public double getV() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDoubleValue(k_V);
    }

    public void setV(double value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryDoubleValue(k_V, value);
    }

    public boolean hasV() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_V);
    }

    public boolean getDR() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryBooleanValue(k_DR);
    }

    public void setDR(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(k_DR, value);
    }

    public boolean hasDR() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_DR);
    }

    public int getP() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(k_P);
    }

    public void setP(int value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(k_P, value);
    }

    public boolean hasP() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_P);
    }

    public PDFText getUT() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFText.getInstance(this.getDictionaryCosObjectValue(k_UT));
    }

    public void setUT(PDFText value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryTextValue(k_UT, value);
    }

    public boolean hasUT() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_UT);
    }

    public PDF3DVPDict getS() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDF3DVPDict.getInstance(this.getDictionaryCosObjectValue(k_S));
    }

    public void setS(CosDictionary cosDictionary) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(k_S, cosDictionary);
    }

    public boolean hasS() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_S);
    }
}

