/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interchange.webcapture;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interchange.webcapture.PDFSISObjectArray;
import com.adobe.internal.pdftoolkit.pdf.interchange.webcapture.PDFSpiderContentSet;

public class PDFSpiderContentSetSIS
extends PDFSpiderContentSet {
    private PDFSpiderContentSetSIS(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    private PDFSpiderContentSetSIS(PDFDocument pdfDoc, ASName subType) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        super(pdfDoc, subType);
    }

    public static PDFSpiderContentSetSIS newInstance(PDFDocument pdfDocument, int key_References, PDFSISObjectArray key_O) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (key_O == null) {
            throw new PDFInvalidParameterException("O is required when creating newInstance of PDFSpiderContentSetSIS.");
        }
        PDFSpiderContentSetSIS pdfObject = new PDFSpiderContentSetSIS(pdfDocument, ASName.k_SIS);
        pdfObject.setReferences(new int[]{key_References});
        pdfObject.setO(key_O);
        return pdfObject;
    }

    public static PDFSpiderContentSetSIS getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFSpiderContentSetSIS pdfObject = (PDFSpiderContentSetSIS)PDFCosObject.getCachedInstance(cosObject, PDFSpiderContentSetSIS.class);
        if (pdfObject == null) {
            pdfObject = new PDFSpiderContentSetSIS(cosObject);
        }
        return pdfObject;
    }

    @Override
    public PDFSISObjectArray getO() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFSISObjectArray.getInstance(this.getDictionaryCosObjectValue(ASName.k_O));
    }

    public void setO(PDFSISObjectArray children) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (children == null) {
            throw new PDFInvalidParameterException("O is a required key therefore cannot be removed.");
        }
        this.setDictionaryArrayValue(ASName.k_O, children.getCosArray());
    }

    public void setReferences(int[] values) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (values == null || values.length == 0) {
            throw new PDFInvalidParameterException("References is a required key therefore cannot be removed.");
        }
        if (values.length == 1) {
            this.setDictionaryIntValue(ASName.k_R, values[0]);
        } else {
            CosArray intArray = PDFCosObject.makeCosArray(this.getPDFDocument(), values, 0, values.length);
            this.setDictionaryArrayValue(ASName.k_R, intArray);
        }
    }

    public int[] getReferences() throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        int[] refArray = null;
        CosObject refCosObj = this.getDictionaryValue(ASName.k_R);
        if (refCosObj != null) {
            if (refCosObj.getType() == 1) {
                refArray = new int[]{refCosObj.intValue()};
            } else if (refCosObj.getType() == 5) {
                refArray = ((CosArray)refCosObj).getArrayInt();
            }
        }
        return refArray;
    }

    public boolean hasReferences() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_R);
    }
}

