/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interchange.structure;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidStructureException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFNumberTree;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureContentFactory;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureContentInterface;

public class PDFStructureParentTree
extends PDFNumberTree<PDFStructureContentInterface> {
    private PDFStructureParentTree(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFStructureParentTree getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFStructureParentTree pdfObject = (PDFStructureParentTree)PDFCosObject.getCachedInstance(cosObject, PDFStructureParentTree.class);
        if (pdfObject == null) {
            pdfObject = new PDFStructureParentTree(cosObject);
        }
        return pdfObject;
    }

    public static PDFStructureParentTree newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        return new PDFStructureParentTree(cosObject);
    }

    @Override
    protected PDFStructureContentInterface makeValueType(CosObject cosObject) throws PDFInvalidStructureException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        return PDFStructureContentFactory.getInstance(cosObject);
    }

    @Override
    protected CosObject getCosObjectFromValue(PDFStructureContentInterface value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return value.getCosObject();
    }
}

