/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interchange.prepress;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interchange.prepress.PDFOPI;

public class PDFOPIVersion
extends PDFCosDictionary {
    private PDFOPIVersion(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFOPIVersion getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFOPIVersion pdfObject = (PDFOPIVersion)PDFCosObject.getCachedInstance(cosObject, PDFOPIVersion.class);
        if (pdfObject == null) {
            pdfObject = new PDFOPIVersion(cosObject);
        }
        return pdfObject;
    }

    public static PDFOPIVersion newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFOPIVersion pdfObject = new PDFOPIVersion(cosObject);
        return pdfObject;
    }

    public PDFOPI getOPI(ASName version) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFOPI.getInstance(this.getDictionaryCosObjectValue(version));
    }

    public void setOPI(ASName version, PDFOPI opi) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(version, opi);
    }
}

