/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interchange.documentparts;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFFileSpecificationList;
import com.adobe.internal.pdftoolkit.pdf.interchange.documentparts.PDFDPartNode;
import com.adobe.internal.pdftoolkit.pdf.interchange.documentparts.PDFDPartRoot;
import com.adobe.internal.pdftoolkit.pdf.interchange.documentparts.PDFDocumentPartMetadata;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import java.util.ArrayList;
import java.util.List;

public class PDFDPart
extends PDFDPartNode {
    protected PDFDPart(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFDPart newInstance(PDFDocument pdfDocument, PDFDPartNode parent, List<List<PDFDPart>> dParts, PDFPage startingPage, PDFPage endingPage) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (parent == null) {
            throw new PDFInvalidParameterException("parent is required when creating newInstance of PDFDPart.");
        }
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFDPart pdfObject = new PDFDPart(cosObject);
        pdfObject.setDictionaryNameValue(ASName.k_Type, ASName.k_DPart);
        pdfObject.setParent(parent);
        pdfObject.setDParts(dParts);
        pdfObject.setStartingPage(startingPage);
        pdfObject.setEndingPage(endingPage);
        return pdfObject;
    }

    public static PDFDPart getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFDPart pdfObject = (PDFDPart)PDFCosObject.getCachedInstance(cosObject, PDFDPart.class);
        if (pdfObject == null) {
            pdfObject = new PDFDPart(cosObject);
        }
        return pdfObject;
    }

    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }

    public PDFDPartNode getParent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFDPartRoot root = this.getPDFDocument().requireCatalog().getDPartRoot();
        CosObject parent = this.getDictionaryCosObjectValue(ASName.k_Parent);
        if (parent == root.getCosObject()) {
            return PDFDPartRoot.getInstance(parent);
        }
        return PDFDPart.getInstance(parent);
    }

    public void setParent(PDFDPartNode pdfDPartNode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (pdfDPartNode == null) {
            throw new PDFInvalidParameterException("Parent is required entry of PDFDPart.");
        }
        this.setDictionaryValue(ASName.k_Parent, pdfDPartNode);
    }

    public List<List<PDFDPart>> getDParts() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray entries = this.getDictionaryArrayValue(ASName.k_DParts);
        if (entries != null) {
            int count = entries.size();
            ArrayList<List<PDFDPart>> result = new ArrayList<List<PDFDPart>>();
            for (int i = 0; i < count; ++i) {
                CosArray singleEntry = entries.getCosArray(i);
                ArrayList<PDFDPart> subArray = new ArrayList<PDFDPart>();
                for (int j = 0; j < singleEntry.size(); ++j) {
                    subArray.add(PDFDPart.getInstance(singleEntry.get(j)));
                }
                result.add(subArray);
            }
            return result;
        }
        return null;
    }

    public void setDParts(List<List<PDFDPart>> dParts) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (dParts == null && this.getStartingPage() == null) {
            throw new PDFInvalidParameterException("DParts is required when creating newInstance of DPart.");
        }
        CosArray dPartsArray = PDFCosObject.newCosArray(this.getPDFDocument());
        for (List<PDFDPart> entry : dParts) {
            CosArray subArray = PDFCosObject.newCosArray(this.getPDFDocument());
            for (PDFDPart name : entry) {
                subArray.add(name.getCosObject());
            }
            dPartsArray.add(subArray);
        }
        this.setDictionaryArrayValue(ASName.k_DParts, dPartsArray);
    }

    public PDFPage getStartingPage() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFPage.getInstance(this.getDictionaryCosObjectValue(ASName.k_Start));
    }

    public void setStartingPage(PDFPage startingPage) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (startingPage == null && this.getDParts() == null) {
            throw new PDFInvalidParameterException("Start is required when creating newInstance of DPart.");
        }
        this.setDictionaryValue(ASName.k_Start, startingPage);
    }

    public PDFPage getEndingPage() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFPage.getInstance(this.getDictionaryCosObjectValue(ASName.k_End));
    }

    public void setEndingPage(PDFPage endingPage) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (endingPage == null && this.getStartingPage() != null) {
            throw new PDFInvalidParameterException("End is required when creating newInstance of DPart.");
        }
        this.setDictionaryValue(ASName.k_End, endingPage);
    }

    public PDFDocumentPartMetadata getDPM() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        return PDFDocumentPartMetadata.getInstance(this.getDictionaryCosObjectValue(ASName.k_DPM));
    }

    public void setDPM(PDFDocumentPartMetadata dpm) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_DPM, dpm);
    }

    public PDFFileSpecificationList getAssociatedFiles() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFFileSpecificationList.getInstance(this.getDictionaryCosObjectValue(ASName.k_AF));
    }

    public void setAssociatedFiles(PDFFileSpecificationList fileSpecificationList) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_AF, fileSpecificationList);
    }
}

