/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.requirement;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;

public class PDFRequirementHandler
extends PDFCosDictionary {
    private PDFRequirementHandler(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFRequirementHandler newInstance(PDFDocument pdfDocument, ASName key_RequirementType) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (key_RequirementType == null) {
            throw new PDFInvalidParameterException("RequirementType is required when creating newInstance of PDFRequirementHandler.");
        }
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFRequirementHandler pdfObject = new PDFRequirementHandler(cosObject);
        pdfObject.setDictionaryNameValue(ASName.k_Type, ASName.k_ReqHandler);
        pdfObject.setRequirementType(key_RequirementType);
        return pdfObject;
    }

    public static PDFRequirementHandler getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFRequirementHandler pdfObject = (PDFRequirementHandler)PDFCosObject.getCachedInstance(cosObject, PDFRequirementHandler.class);
        if (pdfObject == null) {
            pdfObject = new PDFRequirementHandler(cosObject);
        }
        return pdfObject;
    }

    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }

    public boolean hasType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Type);
    }

    public ASName getRequirementType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_S);
    }

    public void setRequirementType(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("RequirementType is a required key therefore cannot be removed.");
        }
        if (!value.equals(ASName.k_JS) && !value.equals(ASName.k_NoOp)) {
            throw new PDFInvalidParameterException("Value " + value + " is outside of bound for RequirementType.");
        }
        this.setDictionaryNameValue(ASName.k_S, value);
    }

    public ASName requireRequirementType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName name = this.getDictionaryNameValue(ASName.k_S);
        if (name == null) {
            throw new PDFInvalidDocumentException("Unable to get RequirementType.");
        }
        return name;
    }

    public boolean hasRequirementType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_S);
    }

    public ASString getScript() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryStringValue(ASName.k_Script);
    }

    public void setScript(ASString script) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (this.requireRequirementType() == ASName.k_JS) {
            this.setDictionaryASStringValue(ASName.k_Script, script);
        }
    }
}

