/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.geospatial;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.geospatial.PDFCoordinateSystem;
import java.util.Arrays;

public class PDFGeospatialMeasure
extends PDFCosDictionary {
    private PDFGeospatialMeasure(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFGeospatialMeasure newInstance(PDFDocument pdfDocument, PDFCoordinateSystem coordinateSystem, double[] gPTSArray) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (coordinateSystem == null) {
            throw new PDFInvalidParameterException("projected or geographic coordinate system dictionary is required when creating newInstance of PDFGeospatialMeasure.");
        }
        if (gPTSArray == null) {
            throw new PDFInvalidParameterException("GPTS is required when creating newInstance of PDFGeospatialMeasure.");
        }
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFGeospatialMeasure pdfObject = new PDFGeospatialMeasure(cosObject);
        pdfObject.setGCS(coordinateSystem);
        pdfObject.setGPTS(gPTSArray);
        return pdfObject;
    }

    public static PDFGeospatialMeasure getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFGeospatialMeasure pdfObject = (PDFGeospatialMeasure)PDFCosObject.getCachedInstance(cosObject, PDFGeospatialMeasure.class);
        if (pdfObject == null) {
            pdfObject = new PDFGeospatialMeasure(cosObject);
        }
        return pdfObject;
    }

    public CosArray getBounds() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray array = this.getDictionaryArrayValue(ASName.k_Bounds);
        if (array == null) {
            return PDFGeospatialMeasure.makeCosArray(this.getPDFDocument(), Arrays.asList(0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 0.0));
        }
        return array;
    }

    public void setBounds(CosArray bounds) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryArrayValue(ASName.k_Bounds, bounds);
    }

    public PDFCoordinateSystem getGCS() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFCoordinateSystem.getInstance(this.getDictionaryValue(ASName.k_GCS));
    }

    public void setGCS(PDFCoordinateSystem coordinateSystem) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (coordinateSystem == null) {
            throw new PDFInvalidParameterException("projected or geographic coordinate system dictionary is required when creating newInstance of PDFGeospatialMeasure.");
        }
        this.setDictionaryValue(ASName.k_GCS, coordinateSystem);
    }

    public PDFCoordinateSystem getDCS() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFCoordinateSystem.getInstance(this.getDictionaryValue(ASName.k_DCS));
    }

    public void setDCS(PDFCoordinateSystem coordinateSystem) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_DCS, coordinateSystem);
    }

    public ASName[] getProcSetList() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray pdu = this.getDictionaryArrayValue(ASName.k_PDU);
        if (pdu != null) {
            return pdu.getArrayName();
        }
        return null;
    }

    public void setProcSetList(ASName[] names) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryArrayValue(ASName.k_PDU, 0, names);
    }

    public double[] getGPTS() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray gpts = this.getDictionaryArrayValue(ASName.k_GPTS);
        if (gpts != null) {
            return gpts.getArrayDouble();
        }
        return null;
    }

    public void setGPTS(double[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("GPTS is required when creating newInstance of PDFGeospatialMeasure.");
        }
        this.setDictionaryArrayValue(ASName.k_GPTS, 0, value);
    }

    public double[] getLPTS() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray lpts = this.getDictionaryArrayValue(ASName.k_LPTS);
        if (lpts != null) {
            return lpts.getArrayDouble();
        }
        return null;
    }

    public void setLPTS(double[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryArrayValue(ASName.k_LPTS, 0, value);
    }
}

