/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.forms;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWidget;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFPaperMetaData;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldNode;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldText;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import java.util.HashMap;
import java.util.Map;

public class PDFFieldBarcode
extends PDFFieldText {
    public static final ASName k_DataPrep = ASName.create("DataPrep");
    private static final String DEFAULT_BARCODEFIELD_NAME = "Barcode";

    private PDFFieldBarcode(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFFieldBarcode getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFFieldBarcode pdfObject = (PDFFieldBarcode)PDFCosObject.getCachedInstance(cosObject, PDFFieldBarcode.class);
        if (pdfObject == null) {
            pdfObject = new PDFFieldBarcode(cosObject);
        }
        return pdfObject;
    }

    public static PDFFieldNode newInstance(PDFPage page, PDFRectangle annotRect, PDFFieldNode parent, PDFPaperMetaData pmd) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(page.getPDFDocument());
        PDFFieldBarcode field = new PDFFieldBarcode(cosObject);
        field.setDataPrep(DataPrep.DATA_SENT_TO_ENCODER_DIRECTLY);
        field.init(parent, null, page, annotRect, true, pmd);
        return field;
    }

    private void init(PDFFieldNode parent, String fieldName, PDFPage page, PDFRectangle annotRect, boolean combineFieldAnnot, PDFPaperMetaData pmd) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.init(parent, fieldName, DEFAULT_BARCODEFIELD_NAME, null, false);
        PDFAnnotationWidget widget = this.initWidgetAnnot(page, annotRect, combineFieldAnnot);
        this.setDictionaryNameValue(ASName.k_FT, ASName.k_Tx);
        widget.setPMD(pmd);
    }

    public DataPrep getDataPrep() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return DataPrep.get(this.getDictionaryIntValue(k_DataPrep));
    }

    public void setDataPrep(DataPrep value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(k_DataPrep, value.getCode());
    }

    public boolean hasDataPrep() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_DataPrep);
    }

    public static enum DataPrep {
        DATA_SENT_TO_ENCODER_DIRECTLY(0),
        DATA_COMPRESSED_FIRST(1);

        private int code;
        private static final Map<Integer, DataPrep> lookup;

        private DataPrep(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static DataPrep get(int code) {
            return lookup.get(code);
        }

        static {
            lookup = new HashMap<Integer, DataPrep>();
            lookup.put(0, DATA_SENT_TO_ENCODER_DIRECTLY);
            lookup.put(1, DATA_COMPRESSED_FIRST);
        }
    }
}

