/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.annotation;

import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFRuntimeException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import java.lang.reflect.Method;
import java.util.HashMap;

public class PDFMultimediaUtil {
    public static final String MULTIMEDIA_PACKAGENAME = "com.adobe.internal.pdftoolkit.pdf.multimedia";
    private static HashMap<String, Method> constructorWithCosobjectMap = new HashMap();
    private static HashMap<String, Method> constructorWithPDFDocMap = new HashMap();

    public static PDFCosDictionary createPDFMultimediaObject(String className, PDFDocument pdfdoc) {
        try {
            Method m = constructorWithPDFDocMap.get(className);
            if (m == null) {
                Class<?> clazz = Class.forName("com.adobe.internal.pdftoolkit.pdf.multimedia." + className);
                m = clazz.getDeclaredMethod("newInstance", PDFDocument.class);
                constructorWithPDFDocMap.put(className, m);
            }
            return (PDFCosDictionary)m.invoke(null, pdfdoc);
        }
        catch (Exception e) {
            throw new PDFRuntimeException("Could not load class com.adobe.internal.pdftoolkit.pdf.multimedia." + className + " at runtime.", e);
        }
    }

    public static PDFCosDictionary createPDFMultimediaObject(String className, CosObject cosobject) {
        try {
            Method m = constructorWithCosobjectMap.get(className);
            if (m == null) {
                Class<?> clazz = Class.forName("com.adobe.internal.pdftoolkit.pdf.multimedia." + className);
                m = clazz.getDeclaredMethod("getInstance", CosObject.class);
                constructorWithCosobjectMap.put(className, m);
            }
            return (PDFCosDictionary)m.invoke(null, cosobject);
        }
        catch (Exception e) {
            throw new PDFRuntimeException("Could not load class com.adobe.internal.pdftoolkit.pdf.multimedia." + className + " at runtime.", e);
        }
    }

    public static void checkParameterType(String className, Object object) throws PDFInvalidParameterException {
        if (!object.getClass().getName().equals(className)) {
            throw new PDFInvalidParameterException("Expected parameter " + object + " to be of type " + className);
        }
    }
}

