/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.annotation;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRotation;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectFactory;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFIconFit;
import java.util.Arrays;

public class PDFAppearanceCharacteristics
extends PDFCosDictionary {
    private static final ASName k_R = ASName.create("R");
    private static final ASName k_BC = ASName.create("BC");
    private static final ASName k_BG = ASName.create("BG");
    private static final ASName k_CA = ASName.create("CA");
    private static final ASName k_RC = ASName.create("RC");
    private static final ASName k_AC = ASName.create("AC");
    private static final ASName k_I = ASName.create("I");
    private static final ASName k_RI = ASName.create("RI");
    private static final ASName k_IX = ASName.create("IX");
    private static final ASName k_IF = ASName.create("IF");
    private static final ASName k_TP = ASName.create("TP");

    private PDFAppearanceCharacteristics(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFAppearanceCharacteristics getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFAppearanceCharacteristics pdfObject = (PDFAppearanceCharacteristics)PDFCosObject.getCachedInstance(cosObject, PDFAppearanceCharacteristics.class);
        if (pdfObject == null) {
            pdfObject = new PDFAppearanceCharacteristics(cosObject);
        }
        return pdfObject;
    }

    public static PDFAppearanceCharacteristics newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        return new PDFAppearanceCharacteristics(cosObject);
    }

    public boolean hasRotation() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_R);
    }

    public PDFRotation getRotation() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.hasRotation()) {
            return PDFRotation.ROTATE_0;
        }
        try {
            return PDFRotation.getInstance(this.getDictionaryIntValue(k_R));
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException("Unable to retrieve rotation value from dictionary.", e);
        }
    }

    public void setRotation(PDFRotation angle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(k_R, angle.getValue());
    }

    public boolean hasBorderColor() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_BC);
    }

    public double[] getBorderColor() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.hasBorderColor()) {
            return null;
        }
        return this.getDictionaryArrayValue(k_BC).getArrayDouble();
    }

    public void setBorderColor(double[] color) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (color != null) {
            CosArray cosArray = PDFCosObject.newCosArray(this.getPDFDocument());
            for (int i = 0; i < color.length; ++i) {
                cosArray.addDouble(color[i]);
            }
            this.setDictionaryArrayValue(k_BC, cosArray);
        } else {
            this.removeValue(k_BC);
        }
    }

    public boolean hasBackgroundColor() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_BG);
    }

    public double[] getBackgroundColor() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.hasBackgroundColor()) {
            return null;
        }
        return this.getDictionaryArrayValue(k_BG).getArrayDouble();
    }

    public void setBackgroundColor(double[] color) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (color != null) {
            CosArray cosArray = PDFCosObject.newCosArray(this.getPDFDocument());
            for (int i = 0; i < color.length; ++i) {
                cosArray.addDouble(color[i]);
            }
            this.setDictionaryArrayValue(k_BG, cosArray);
        } else {
            this.removeValue(k_BG);
        }
    }

    public boolean hasNormalCaption() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_CA);
    }

    public String getNormalCaption() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.hasNormalCaption()) {
            return null;
        }
        return this.getDictionaryTextStringValue(k_CA);
    }

    public void setNormalCaption(String caption) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(k_CA, caption);
    }

    public boolean hasRolloverCaption() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_RC);
    }

    public String getRolloverCaption() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.hasRolloverCaption()) {
            return null;
        }
        return this.getDictionaryTextStringValue(k_RC);
    }

    public void setRolloverCaption(String caption) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(k_RC, caption);
    }

    public boolean hasAlternateCaption() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_AC);
    }

    public String getAlternateCaption() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.hasAlternateCaption()) {
            return null;
        }
        return this.getDictionaryTextStringValue(k_AC);
    }

    public void setAlternateCaption(String caption) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(k_AC, caption);
    }

    public boolean hasNormalIcon() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_I);
    }

    public PDFXObjectForm getNormalIcon() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.hasNormalIcon()) {
            return null;
        }
        return PDFXObjectForm.getInstance(this.getCosDictionary().getCosStream(k_I));
    }

    public void setNormalIcon(PDFXObject xObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (xObject != null) {
            this.getCosDictionary().put(k_I, xObject.getCosObject());
        } else {
            this.removeValue(k_I);
        }
    }

    public boolean hasRolloverIcon() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_RI);
    }

    public PDFXObject getRolloverIcon() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.hasRolloverIcon()) {
            return null;
        }
        return PDFXObjectFactory.getInstance(this.getCosDictionary().getCosStream(k_RI));
    }

    public void setRolloverIcon(PDFXObject xObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (xObject != null) {
            this.getCosDictionary().put(k_RI, xObject.getCosObject());
        } else {
            this.removeValue(k_RI);
        }
    }

    public boolean hasAlternateIcon() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_IX);
    }

    public PDFXObject getAlternateIcon() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.hasAlternateIcon()) {
            return null;
        }
        return PDFXObjectFactory.getInstance(this.getCosDictionary().getCosStream(k_IX));
    }

    public void setAlternateIcon(PDFXObject xObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (xObject != null) {
            this.getCosDictionary().put(k_IX, xObject.getCosObject());
        } else {
            this.removeValue(k_IX);
        }
    }

    public boolean hasIconFit() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_IF);
    }

    public PDFIconFit getIconFit() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFIconFit.getInstance(this.getDictionaryCosObjectValue(ASName.k_IF));
    }

    public void setIconFit(PDFIconFit fit) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(k_IF, fit);
    }

    public boolean hasCaptionPosition() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_TP);
    }

    public CaptionPosition getCaptionPosition() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.hasCaptionPosition()) {
            return CaptionPosition.kNoIcon_CaptionOnly;
        }
        int captionPosition = this.getDictionaryIntValue(k_TP);
        try {
            return CaptionPosition.getInstance(captionPosition);
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException("Invalid Caption Position in document.", e);
        }
    }

    public void setCaptionPosition(int position) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            CaptionPosition.getInstance(position);
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException("Invalid Caption Position in document.", e);
        }
    }

    public boolean compare(Object obj) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PDFAppearanceCharacteristics)) {
            return false;
        }
        PDFAppearanceCharacteristics other = (PDFAppearanceCharacteristics)obj;
        if (this.getRotation() != other.getRotation()) {
            return false;
        }
        if (!Arrays.equals(this.getBorderColor(), other.getBorderColor())) {
            return false;
        }
        if (!Arrays.equals(this.getBackgroundColor(), other.getBackgroundColor())) {
            return false;
        }
        if (this.getNormalCaption() == null ? other.getNormalCaption() != null : !this.getNormalCaption().equals(other.getNormalCaption())) {
            return false;
        }
        if (this.getRolloverCaption() == null ? other.getRolloverCaption() != null : !this.getRolloverCaption().equals(other.getRolloverCaption())) {
            return false;
        }
        if (this.getAlternateCaption() == null ? other.getAlternateCaption() != null : !this.getAlternateCaption().equals(other.getAlternateCaption())) {
            return false;
        }
        return this.getCaptionPosition() == other.getCaptionPosition();
    }

    public static enum CaptionPosition {
        kNoIcon_CaptionOnly(0, "No icon; caption only"),
        kNoCaption_IconOnly(1, "No caption; icon only"),
        kCaptionBelowIcon(2, "Caption below the icon"),
        kCaptionAboveIcon(3, "Caption above the icon"),
        kCaptionRightOfIcon(4, "Caption to the right of icon"),
        kCaptionLeftOfIcon(5, "Caption to the left of icon"),
        kCaptionOverlaidOnIcon(6, "Caption overlaid directly on the icon");

        private final int position;
        private final String description;

        private CaptionPosition(int value, String description) {
            this.position = value;
            this.description = description;
        }

        private static CaptionPosition getInstance(int value) throws PDFInvalidParameterException {
            switch (value) {
                case 0: {
                    return kNoIcon_CaptionOnly;
                }
                case 1: {
                    return kNoCaption_IconOnly;
                }
                case 2: {
                    return kCaptionBelowIcon;
                }
                case 3: {
                    return kCaptionAboveIcon;
                }
                case 4: {
                    return kCaptionRightOfIcon;
                }
                case 5: {
                    return kCaptionLeftOfIcon;
                }
                case 6: {
                    return kCaptionOverlaidOnIcon;
                }
            }
            throw new PDFInvalidParameterException("unrecognized caption position value");
        }

        public int getValue() {
            return this.position;
        }

        public String toString() {
            return this.description;
        }
    }

    public static final class NormalCaptionForCheckAndRadio {
        private final String value;
        public static final NormalCaptionForCheckAndRadio StyleCheck = new NormalCaptionForCheckAndRadio("4");
        public static final NormalCaptionForCheckAndRadio StyleCross = new NormalCaptionForCheckAndRadio("8");
        public static final NormalCaptionForCheckAndRadio StyleDiamond = new NormalCaptionForCheckAndRadio("u");
        public static final NormalCaptionForCheckAndRadio StyleCircle = new NormalCaptionForCheckAndRadio("l");
        public static final NormalCaptionForCheckAndRadio StyleStar = new NormalCaptionForCheckAndRadio("H");
        public static final NormalCaptionForCheckAndRadio StyleSquare = new NormalCaptionForCheckAndRadio("n");

        private NormalCaptionForCheckAndRadio(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static NormalCaptionForCheckAndRadio getInstance(String value) throws PDFInvalidDocumentException {
            if (value.equals(StyleCheck.getValue())) {
                return StyleCheck;
            }
            if (value.equals(StyleCross.getValue())) {
                return StyleCross;
            }
            if (value.equals(StyleDiamond.getValue())) {
                return StyleDiamond;
            }
            if (value.equals(StyleCircle.getValue())) {
                return StyleCircle;
            }
            if (value.equals(StyleStar.getValue())) {
                return StyleStar;
            }
            if (value.equals(StyleSquare.getValue())) {
                return StyleSquare;
            }
            throw new PDFInvalidDocumentException("Unknow /CA value for check box or radio button.");
        }
    }
}

