/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.annotation;

import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationFactory;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationMarkup;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWithIcon;

public class PDFAnnotationText
extends PDFAnnotationMarkup
implements PDFAnnotationWithIcon {
    private PDFAnnotationText(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosObject);
    }

    public static PDFAnnotationText getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFAnnotationText pdfObject = (PDFAnnotationText)PDFCosObject.getCachedInstance(cosObject, PDFAnnotationText.class);
        if (pdfObject == null) {
            pdfObject = new PDFAnnotationText(cosObject);
        }
        return pdfObject;
    }

    public static PDFAnnotationText newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new PDFAnnotationText(pdfDocument);
    }

    private PDFAnnotationText(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(pdfDoc);
        this.setSubtype(ASName.k_Text);
    }

    public static PDFAnnotationText newInstance(PDFDocument pdfDocument, PDFRectangle location, String text) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        PDFAnnotationText pdfObject = PDFAnnotationText.newInstance(pdfDocument);
        pdfObject.setRect(location);
        pdfObject.setContents(text);
        return pdfObject;
    }

    public boolean getOpen() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryBooleanValue(ASName.k_Open);
    }

    public void setOpen(boolean open) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_Open, open);
    }

    @Override
    public boolean hasIconName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Name);
    }

    @Override
    public String getIconName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject obj = this.getDictionaryValue(ASName.k_Name);
        if (obj instanceof CosName) {
            return this.getDictionaryNameValue(ASName.k_Name).asString(true);
        }
        ASString asStr = this.getDictionaryStringValue(ASName.k_Name);
        return asStr != null ? asStr.asString() : null;
    }

    @Override
    public void setIconName(String name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_Name, name);
    }

    public String getState() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryTextStringValue(ASName.k_State);
    }

    public void setState(String state) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_State, state);
    }

    public String getStateModel() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryTextStringValue(ASName.k_StateModel);
    }

    public void setStateModel(String state) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_StateModel, state);
    }

    @Override
    public PDFAnnotation getInReplyTo() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFAnnotationFactory.getInstance(this.getDictionaryDictionaryValue(ASName.k_IRT));
    }

    @Override
    public void setInReplyTo(PDFAnnotation annot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_IRT, annot);
    }

    @Override
    public void transform(ASMatrix matrix, double rotationAngle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.transformRect(matrix);
        this.transformAppearances(matrix, rotationAngle);
    }
}

