/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.annotation;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASCoordinate;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosNumeric;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationLine;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationMarkup;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationPopup;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationUtils;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWithIntent;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFMeasure;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFVertices;
import java.util.ArrayList;

public class PDFAnnotationPolyline
extends PDFAnnotationMarkup
implements PDFAnnotationWithIntent {
    private PDFAnnotationPolyline(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosObject);
    }

    public static PDFAnnotationPolyline newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new PDFAnnotationPolyline(pdfDocument);
    }

    private PDFAnnotationPolyline(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(pdfDoc);
        this.setSubtype(ASName.k_PolyLine);
    }

    public static PDFAnnotationPolyline getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFAnnotationPolyline pdfObject = (PDFAnnotationPolyline)PDFCosObject.getCachedInstance(cosObject, PDFAnnotationPolyline.class);
        if (pdfObject == null) {
            pdfObject = new PDFAnnotationPolyline(cosObject);
        }
        return pdfObject;
    }

    public boolean hasLineEnds() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_LE);
    }

    public PDFAnnotationLine.LineEnding[] getLineEnds() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = this.getDictionaryArrayValue(ASName.k_LE);
        if (cosArray == null) {
            return new PDFAnnotationLine.LineEnding[]{PDFAnnotationLine.LineEnding.None, PDFAnnotationLine.LineEnding.None};
        }
        PDFAnnotationLine.LineEnding[] lineEndings = new PDFAnnotationLine.LineEnding[]{PDFAnnotationLine.LineEnding.getInstance(cosArray.getName(0).asString(true)), PDFAnnotationLine.LineEnding.getInstance(cosArray.getName(1).asString(true))};
        return lineEndings;
    }

    public void setLineEnds(PDFAnnotationLine.LineEnding[] lineEndings) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (lineEndings == null) {
            this.removeValue(ASName.k_LE);
        } else {
            if (lineEndings[0] == null || lineEndings[1] == null) {
                throw new PDFInvalidParameterException("Invalid value Supplied for line ending");
            }
            CosArray cosArray = PDFCosObject.newCosArray(this.getPDFDocument());
            cosArray.addName(lineEndings[0].getValue());
            cosArray.addName(lineEndings[1].getValue());
            this.setDictionaryArrayValue(ASName.k_LE, cosArray);
        }
    }

    public PDFVertices getVertices() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFVertices.getInstance(this.getDictionaryCosObjectValue(ASName.k_Vertices));
    }

    public void setVertices(PDFVertices vertices) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (vertices == null) {
            throw new PDFInvalidDocumentException("vertices can't bw null");
        }
        this.setDictionaryArrayValue(ASName.k_Vertices, vertices.getCosArray());
    }

    public PDFVertices procureVertices() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFVertices vertices = this.getVertices();
        if (vertices == null) {
            vertices = PDFVertices.newInstance(this.getPDFDocument());
        }
        return vertices;
    }

    private void transformVertices(ASMatrix matrix) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFVertices vertices = this.getVertices();
        if (vertices != null) {
            PDFDocument pdfDocument = this.getPDFDocument();
            ArrayList<Double> newVerticesArrayList = new ArrayList<Double>();
            for (int i = 0; i < vertices.size(); i += 2) {
                double x = ((PDFCosNumeric)vertices.get(i)).doubleValue();
                double y = ((PDFCosNumeric)vertices.get(i + 1)).doubleValue();
                ASCoordinate vertex = new ASCoordinate(x, y);
                ASCoordinate newVertex = vertex.transform(matrix);
                Double newX = newVertex.x();
                Double newY = newVertex.y();
                newVerticesArrayList.add(i, newX);
                newVerticesArrayList.add(i + 1, newY);
            }
            PDFVertices newVertices = PDFVertices.getInstance(PDFCosObject.makeCosArray(pdfDocument, newVerticesArrayList));
            this.setVertices(newVertices);
        }
    }

    @Override
    public void transform(ASMatrix matrix, double rotationAngle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.transformVertices(matrix);
        this.transformRect(matrix);
        this.transformAppearances(matrix, rotationAngle);
    }

    public boolean hasMeasure() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_MEASURE);
    }

    public PDFMeasure getMeasure() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFMeasure.getInstance(this.getDictionaryDictionaryValue(ASName.k_MEASURE));
    }

    public void setMeasure(PDFMeasure measure) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_MEASURE, measure);
    }

    public double[] getInteriorColor() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFAnnotationUtils.getInteriorColor(this);
    }

    public void setInteriorColor(double[] color) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFAnnotationUtils.setInteriorColor(color, this);
    }

    @Override
    public void applyRotation(PDFRectangle cropBox, int rotationAngle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (rotationAngle == 0) {
            rotationAngle = this.getRotation();
        }
        double height = cropBox.height();
        double width = cropBox.width();
        double[] transformedRect = null;
        double[] transformedPopupRect = null;
        double[] transformedVertices = null;
        PDFAnnotationPopup popup = this.getPopup();
        transformedRect = PDFAnnotationUtils.transfromRectangle(this.getRect().getValues(), width, height, rotationAngle);
        if (popup != null) {
            transformedPopupRect = PDFAnnotationUtils.transfromRectangle(this.getPopup().getRect().getValues(), width, height, rotationAngle);
        }
        this.setRect(PDFRectangle.newInstance(this.getPDFDocument(), transformedRect[0], transformedRect[1], transformedRect[2], transformedRect[3]));
        PDFVertices vertices = this.getVertices();
        if (vertices != null) {
            transformedVertices = PDFAnnotationUtils.transfromRectangle(vertices.getCosArray().getArrayDouble(), width, height, rotationAngle);
            this.setVertices(PDFVertices.newInstance(this.getPDFDocument(), PDFAnnotationUtils.getList(transformedVertices)));
        }
        if (popup != null) {
            this.getPopup().setRect(PDFRectangle.newInstance(this.getPDFDocument(), transformedPopupRect[0], transformedPopupRect[1], transformedPopupRect[2], transformedPopupRect[3]));
        }
    }
}

