/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.annotation;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASDate;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFFileSpecificationList;
import com.adobe.internal.pdftoolkit.pdf.document.PDFText;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.impl.AnnotationID;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionFactory;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAdditionalActions;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAdditionalActionsAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationIterator;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationList;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationMarkup;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationPopup;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationUtils;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWidget;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAppearance;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFBorder;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFBorderStyle;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.utils.PDFUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class PDFAnnotation
extends PDFCosDictionary {
    public static final int kInvisible = 1;
    public static final int kHidden = 2;
    public static final int kPrint = 4;
    public static final int kNoZoom = 8;
    public static final int kNoRotate = 16;
    public static final int kNoView = 32;
    public static final int kReadOnly = 64;
    public static final int kLocked = 128;
    public static final int kToggleNoView = 256;

    protected PDFAnnotation(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosObject);
    }

    protected PDFAnnotation(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(PDFCosObject.newCosDictionary(pdfDoc));
        this.setDictionaryNameValue(ASName.k_Type, ASName.k_Annot);
    }

    public ASName getSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName subType = this.getDictionaryNameValue(ASName.k_Subtype);
        if (subType == null) {
            throw new PDFInvalidDocumentException("Missing required field Subtype");
        }
        return subType;
    }

    public void setSubtype(ASName subType) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_Subtype, subType);
    }

    public boolean hasRect() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Rect);
    }

    public PDFRectangle getRect() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFRectangle.getInstance(this.getDictionaryCosObjectValue(ASName.k_Rect));
    }

    public void setRect(double llx, double lly, double urx, double ury) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ArrayList<Double> rectArray = new ArrayList<Double>(4);
        rectArray.add(0, llx);
        rectArray.add(1, lly);
        rectArray.add(2, urx);
        rectArray.add(3, ury);
        this.setDictionaryArrayValue(ASName.k_Rect, rectArray);
    }

    public void setRect(PDFRectangle rect) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryArrayValue(ASName.k_Rect, rect.getCosArray());
    }

    public boolean hasContents() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Contents);
    }

    public String getContents() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryTextStringValue(ASName.k_Contents);
    }

    public void setContents(String text) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_Contents, text);
    }

    public boolean hasPage() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_P);
    }

    public PDFPage getPage() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        boolean isPEntryTypeCorrect = true;
        if (this.dictionaryContains(ASName.k_P)) {
            CosObject obj = this.getDictionaryCosObjectValue(ASName.k_P);
            if (obj instanceof CosDictionary) {
                return PDFPage.getInstance(this.getDictionaryCosObjectValue(ASName.k_P));
            }
            isPEntryTypeCorrect = false;
        }
        PDFCosObject annotPage = null;
        Iterator<PDFPage> pagesIter = this.getPDFDocument().requirePages().iterator();
        block0: while (pagesIter.hasNext()) {
            PDFPage curPage = pagesIter.next();
            PDFAnnotationList pageAnnots = curPage.getAnnotationList();
            if (pageAnnots == null) continue;
            PDFAnnotationIterator annotsIter = pageAnnots.iterator();
            while (annotsIter.hasNext()) {
                PDFAnnotation curAnnot = annotsIter.next();
                if (this != curAnnot) continue;
                annotPage = curPage;
                break block0;
            }
        }
        if (!isPEntryTypeCorrect) {
            this.getCosDictionary().setRepairedValue(ASName.k_P, annotPage.getCosObject());
        }
        return annotPage;
    }

    public void setPage(PDFPage parent) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_P, parent);
    }

    public void setName(String name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFText nameText = PDFText.createString(this.getPDFDocument(), name);
        this.setDictionaryTextValue(ASName.k_NM, nameText);
    }

    public String getName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryTextStringValue(ASName.k_NM);
    }

    public boolean hasName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_NM);
    }

    public boolean hasModificationDate() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_M);
    }

    public ASDate getModificationDate() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDateValue(ASName.k_M);
    }

    public String getModificationDateAsString() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDateValue(ASName.k_M).toString();
    }

    public void setModificationDate(String date) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFText dateText = PDFText.createString(this.getPDFDocument(), date);
        this.setDictionaryTextValue(ASName.k_M, dateText);
    }

    public boolean hasFlags() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_F);
    }

    public int getFlags() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.dictionaryContains(ASName.k_F)) {
            return this.getDictionaryIntValue(ASName.k_F);
        }
        return 0;
    }

    public void setFlags(int flags) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_F, flags);
    }

    public boolean hasBorderStyle() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_BS);
    }

    public PDFBorderStyle getBorderStyle() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFBorderStyle.getInstance(this.getDictionaryCosObjectValue(ASName.k_BS));
    }

    public PDFBorderStyle procureBorderStyle() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFBorderStyle borderStyle = this.getBorderStyle();
        if (borderStyle == null) {
            borderStyle = PDFBorderStyle.newInstance(this.getPDFDocument());
        }
        return borderStyle;
    }

    public PDFBorder procureBorder() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFBorder border = this.getBorder();
        if (border == null) {
            border = PDFBorder.newInstance(this.getPDFDocument());
        }
        return border;
    }

    public void setBorderStyle(PDFBorderStyle borderStyle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_BS, borderStyle);
    }

    public PDFAppearance getAppearance() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFAppearance.getInstance(this.getDictionaryCosObjectValue(ASName.k_AP));
    }

    public ASName getAppearanceState() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_AS);
    }

    public void setAppearanceState(boolean state) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (state) {
            this.setDictionaryNameValue(ASName.k_AS, ASName.create("Yes"));
        } else {
            this.setDictionaryNameValue(ASName.k_AS, ASName.create("Off"));
        }
    }

    public void setAppearanceState(boolean state, String value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (state) {
            this.setDictionaryNameValue(ASName.k_AS, ASName.create(value));
        } else {
            this.setDictionaryNameValue(ASName.k_AS, ASName.create("Off"));
        }
    }

    public PDFXObjectForm getNormalStateAppearance() throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        PDFAppearance appearance = this.getAppearance();
        if (appearance == null) {
            return null;
        }
        return appearance.getNormalAppearance(this.getAppearanceState());
    }

    public void setAppearance(PDFAppearance appearance) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_AP, appearance);
    }

    public void removeAppearance() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getCosDictionary().remove(ASName.k_AP);
    }

    public boolean hasBorder() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Border);
    }

    public PDFBorder getBorder() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFBorder.getInstance(this.getDictionaryArrayValue(ASName.k_Border));
    }

    public void setBorder(PDFBorder border) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryArrayValue(ASName.k_Border, border.getCosArray());
    }

    public void setBorder(ArrayList<? extends Object> border) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryArrayValue(ASName.k_Border, border);
    }

    public double[] getColor() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosColor = this.getDictionaryArrayValue(ASName.k_C);
        if (cosColor == null) {
            return null;
        }
        return cosColor.getArrayDouble();
    }

    public void setColor(double[] color) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosColor = PDFCosObject.newCosArray(this.getPDFDocument());
        for (int i = 0; i < color.length; ++i) {
            cosColor.addDouble(color[i]);
        }
        this.setDictionaryArrayValue(ASName.k_C, cosColor);
    }

    public boolean hasAction() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_A);
    }

    public PDFAction getAction() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFActionFactory.getInstance(this.getDictionaryDictionaryValue(ASName.k_A));
    }

    public void setAction(PDFAction action) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_A, action);
    }

    public PDFAdditionalActions getAdditionalActions() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFAdditionalActionsAnnotation.getInstance(this.getDictionaryCosObjectValue(ASName.k_AA));
    }

    public void setAdditionalActions(PDFAdditionalActions additionalActions) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_AA, additionalActions);
    }

    public String getRichTextForContent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!(this instanceof PDFAnnotationMarkup)) {
            return null;
        }
        return PDFUtil.makeRichTextFromString(this.getDictionaryTextStringValue(ASName.k_Contents));
    }

    public boolean hasOptionalContent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_OC);
    }

    private void rotateXObject(PDFXObjectForm xObject, double rotationAngle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        double[] xobjMatrix = xObject.getMatrix();
        ASMatrix xobjASMatrix = xobjMatrix == null ? ASMatrix.createIdentityMatrix() : new ASMatrix(xobjMatrix);
        xobjASMatrix = xobjASMatrix.rotate(rotationAngle);
        xObject.setMatrix(xobjASMatrix.getValues());
    }

    void transformAppearances(ASMatrix matrix, double rotationAngle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFAppearance annotAppearance;
        if (rotationAngle != 0.0 && (annotAppearance = this.getAppearance()) != null) {
            List<ASName> downStates;
            List<ASName> rolloverStates;
            List<ASName> normalStates = annotAppearance.getNormalAppearanceStates();
            if (normalStates != null) {
                if (normalStates.isEmpty()) {
                    this.rotateXObject(annotAppearance.getNormalAppearance(), rotationAngle);
                } else {
                    for (ASName nstate : normalStates) {
                        this.rotateXObject(annotAppearance.getNormalAppearance(nstate), rotationAngle);
                    }
                }
            }
            if ((rolloverStates = annotAppearance.getRolloverAppearanceStates()) != null) {
                if (rolloverStates.isEmpty()) {
                    this.rotateXObject(annotAppearance.getRolloverAppearance(), rotationAngle);
                } else {
                    for (ASName rstate : rolloverStates) {
                        this.rotateXObject(annotAppearance.getRolloverAppearance(rstate), rotationAngle);
                    }
                }
            }
            if ((downStates = annotAppearance.getDownAppearanceStates()) != null) {
                if (downStates.isEmpty()) {
                    this.rotateXObject(annotAppearance.getDownAppearance(), rotationAngle);
                } else {
                    for (ASName dstate : downStates) {
                        this.rotateXObject(annotAppearance.getDownAppearance(dstate), rotationAngle);
                    }
                }
            }
        }
    }

    void transformRect(ASMatrix matrix) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFDocument doc = this.getPDFDocument();
        PDFRectangle annotRectangle = this.getRect();
        PDFRectangle sourceRect = annotRectangle.normalized(doc);
        PDFRectangle destRect = PDFRectangle.newInstance(doc, sourceRect.getRectangle().transform(matrix));
        PDFRectangle normalDestRect = destRect.normalized(doc);
        PDFRectangle destinationRect = PDFRectangle.newInstance(doc, normalDestRect.getRectangle());
        this.setRect(destinationRect);
    }

    public abstract void transform(ASMatrix var1, double var2) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException;

    public ASMatrix getTransformationMatrix(PDFDocument doc, PDFXObjectForm annotAppearance) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        double[] formMatrixValues;
        ASRectangle formBBox;
        PDFRectangle annotPDFRect = this.getRect();
        ASRectangle annotRect = annotPDFRect != null ? annotPDFRect.getRectangle() : new ASRectangle(0.0, 0.0, 0.0, 0.0);
        PDFRectangle formBBoxPDFRect = annotAppearance.getBBox();
        ASRectangle aSRectangle = formBBox = formBBoxPDFRect != null ? formBBoxPDFRect.getRectangle() : new ASRectangle(0.0, 0.0, 0.0, 0.0);
        if (this.getRotation() != 0) {
            formBBoxPDFRect = annotPDFRect;
            formBBox = annotRect;
        }
        ASMatrix formMatrix = (formMatrixValues = annotAppearance.getMatrix()) == null ? ASMatrix.createIdentityMatrix() : new ASMatrix(formMatrixValues);
        formBBox = formBBox.transform(formMatrix);
        double scaleX = 0.0;
        double scaleY = 0.0;
        double annotWidth = annotRect.width();
        double annotHeight = annotRect.height();
        double formWidth = formBBox.width();
        double formHeight = formBBox.height();
        if (formWidth != 0.0) {
            scaleX = annotWidth / formWidth;
        }
        if (formHeight != 0.0) {
            scaleY = annotHeight / formHeight;
        }
        double formOffsetX = -(Math.min(formBBox.left(), formBBox.right()) + formWidth / 2.0);
        double formOffsetY = -(Math.min(formBBox.top(), formBBox.bottom()) + formHeight / 2.0);
        double annotOffsetX = Math.min(annotRect.left(), annotRect.right()) + annotWidth / 2.0;
        double annotOffsetY = Math.min(annotRect.top(), annotRect.bottom()) + annotHeight / 2.0;
        ASMatrix tm = ASMatrix.createIdentityMatrix();
        tm = tm.translate(formOffsetX, formOffsetY);
        tm = tm.scale(scaleX, scaleY);
        tm = tm.translate(annotOffsetX, annotOffsetY);
        return tm;
    }

    public boolean isHidden() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return (this.getFlags() & 2) != 0;
    }

    public boolean isInvisible() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return (this.getFlags() & 1) != 0;
    }

    public boolean isPrintable() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return (this.getFlags() & 4) != 0;
    }

    public boolean isViewable() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return (this.getFlags() & 0x20) != 0;
    }

    public boolean isReadOnly() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return (this.getFlags() & 0x40) != 0;
    }

    private void setBit(boolean value, int kBit) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (value) {
            int flg = this.getFlags();
            this.setFlags(flg |= kBit);
        } else {
            int flags = this.getFlags();
            int mask = 0xFFFFFFFF ^ kBit;
            this.setFlags(flags &= mask);
        }
    }

    public void setHidden(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setBit(value, 2);
    }

    public void setInvisible(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setBit(value, 1);
    }

    public void setPrintable(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setBit(value, 4);
    }

    public void setViewable(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setBit(!value, 32);
    }

    public void setReadOnly(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setBit(value, 64);
    }

    public void setNoZoom(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setBit(value, 8);
    }

    public void setNoRotate(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setBit(value, 16);
    }

    public String getID() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        AnnotationID id = new AnnotationID(this);
        return id.asString();
    }

    @Override
    public String toString() {
        try {
            return this.getID();
        }
        catch (PDFException e) {
            throw new RuntimeException("Could not get or create annotation's ID", e);
        }
    }

    public int getSeqNum() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPage page = this.getPage();
        PDFAnnotationList annotList = page.getAnnotationList();
        ArrayList<PDFAnnotation> nonPopusps = new ArrayList<PDFAnnotation>();
        for (int i = 0; i < annotList.size(); ++i) {
            if (annotList.get(i) instanceof PDFAnnotationPopup || annotList.get(i) instanceof PDFAnnotationWidget) continue;
            nonPopusps.add(annotList.get(i));
        }
        return nonPopusps.indexOf(this) + 1;
    }

    public PDFFileSpecificationList getAssociatedFiles() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFFileSpecificationList.getInstance(this.getDictionaryCosObjectValue(ASName.k_AF));
    }

    public void setAssociatedFiles(PDFFileSpecificationList fileSpecificationList) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_AF, fileSpecificationList);
    }

    public Integer getOpacityValue() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Integer ca = this.getDictionaryIntValue(ASName.k_ca);
        if (ca != null) {
            return ca;
        }
        return 1;
    }

    public void setOpacityValue(Integer ca) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_ca, ca.intValue());
    }

    public void setBlendMode(ASName name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_BM, name);
    }

    public void setBlendMode(ASName[] names) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryArrayValue(ASName.k_BM, 0, names);
    }

    public ASName[] getBlendMode() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray array = this.getDictionaryArrayValue(ASName.k_BM);
        ASName[] names = new ASName[1];
        if (array != null) {
            return array.getArrayName();
        }
        names[0] = this.getDictionaryNameValue(ASName.k_BM);
        if (names[0] != null) {
            return names;
        }
        names[0] = ASName.k_Normal;
        return names;
    }

    public boolean hasRotation() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Rotate);
    }

    public int getRotation() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Number value = this.getDictionaryNumericValue(ASName.k_Rotate);
        return value != null ? value.intValue() : 0;
    }

    public void setRotation(int rotation) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_Rotate, rotation);
    }

    public void applyRotation(PDFRectangle cropBox, int rotationAngle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (rotationAngle == 0) {
            rotationAngle = this.getRotation();
        }
        double height = cropBox.height();
        double width = cropBox.width();
        double[] transformedRect = null;
        transformedRect = PDFAnnotationUtils.transfromRectangle(this.getRect().getValues(), width, height, rotationAngle);
        this.setRect(PDFRectangle.newInstance(this.getPDFDocument(), transformedRect[0], transformedRect[1], transformedRect[2], transformedRect[3]));
    }
}

