/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.action;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interchange.documentparts.PDFDPart;

public class PDFActionGoToDPart
extends PDFAction {
    protected PDFActionGoToDPart(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    protected PDFActionGoToDPart(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(pdfDocument);
    }

    private PDFActionGoToDPart(PDFDocument pdfDocument, PDFDPart pdfdPart) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(pdfDocument);
        this.setSubtype(ASName.k_GoToDp);
        this.setDpat(pdfdPart);
    }

    public static PDFActionGoToDPart getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFActionGoToDPart pdfObject = (PDFActionGoToDPart)PDFCosObject.getCachedInstance(cosObject, PDFActionGoToDPart.class);
        if (pdfObject == null) {
            pdfObject = new PDFActionGoToDPart(cosObject);
        }
        return pdfObject;
    }

    public static PDFActionGoToDPart newSkeletonInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosActionGoTo = PDFCosObject.newCosDictionary(pdfDocument);
        cosActionGoTo.put(ASName.k_Type, ASName.k_Action);
        cosActionGoTo.put(ASName.k_S, ASName.k_GoToDp);
        return new PDFActionGoToDPart(cosActionGoTo);
    }

    public static PDFActionGoToDPart newInstance(PDFDocument pdfDocument, PDFDPart pdfdPart) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new PDFActionGoToDPart(pdfDocument, pdfdPart);
    }

    public void setDpat(PDFDPart pdfdPart) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Dp, pdfdPart);
    }

    public PDFDPart getDpart() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFDPart.getInstance(this.getDictionaryValue(ASName.k_Dp));
    }
}

