/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.inlineimage;

import com.adobe.internal.io.stream.IO;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.StreamManager;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidContentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnsupportedFeatureException;
import com.adobe.internal.pdftoolkit.core.filter.ASCII85InputStream;
import com.adobe.internal.pdftoolkit.core.filter.ASCII85OutputStream;
import com.adobe.internal.pdftoolkit.core.filter.ASCIIHexInputStream;
import com.adobe.internal.pdftoolkit.core.filter.ASCIIHexOutputStream;
import com.adobe.internal.pdftoolkit.core.filter.CCITTFaxInputStream;
import com.adobe.internal.pdftoolkit.core.filter.CustomFilterRegistry;
import com.adobe.internal.pdftoolkit.core.filter.DCTInputStream;
import com.adobe.internal.pdftoolkit.core.filter.FilterParams;
import com.adobe.internal.pdftoolkit.core.filter.FilterStream;
import com.adobe.internal.pdftoolkit.core.filter.LZWInputStream;
import com.adobe.internal.pdftoolkit.core.filter.LZWOutputStream;
import com.adobe.internal.pdftoolkit.core.filter.RunLengthInputStream;
import com.adobe.internal.pdftoolkit.core.filter.RunLengthOutputStream;
import com.adobe.internal.pdftoolkit.core.filter.TIFFInputStream;
import com.adobe.internal.pdftoolkit.core.filter.TIFFOutputStream;
import com.adobe.internal.pdftoolkit.core.filter.spi.CustomFilterException;
import com.adobe.internal.pdftoolkit.core.types.ASArray;
import com.adobe.internal.pdftoolkit.core.types.ASBoolean;
import com.adobe.internal.pdftoolkit.core.types.ASDictionary;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASNull;
import com.adobe.internal.pdftoolkit.core.types.ASNumber;
import com.adobe.internal.pdftoolkit.core.types.ASObject;
import com.adobe.internal.pdftoolkit.pdf.content.Content;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ModifiableContent;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpace;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceCMYK;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceGray;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceRGB;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceIndexed;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFRenderingIntent;
import com.adobe.internal.pdftoolkit.pdf.inlineimage.InlineImageColorSpace;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class InlineImage {
    Content content;
    private int height;
    private int width;
    private Integer bpc;
    private InlineImageColorSpace colorSpace;
    private PDFRenderingIntent intent;
    private boolean imageMask = false;
    private boolean interpolate = false;
    private double[] decode;
    private InputStream unencodedImageData;
    private InputByteStream encodedImageData;
    private ASObject decodeParams;
    private ASObject filters;

    private InlineImage(Content content, ASDictionary imageDict, InputByteStream encodedImageData) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.content = content;
        try {
            this.height = imageDict.getNumber(imageDict.containsKey(ASName.k_H) ? ASName.k_H : ASName.k_Height).intValue();
            this.width = imageDict.getNumber(imageDict.containsKey(ASName.k_W) ? ASName.k_W : ASName.k_Width).intValue();
            if (imageDict.containsKey(ASName.k_BPC)) {
                this.bpc = imageDict.getNumber(ASName.k_BPC).intValue();
            } else if (imageDict.containsKey(ASName.k_BitsPerComponent)) {
                this.bpc = imageDict.getNumber(ASName.k_BitsPerComponent).intValue();
            }
            if (imageDict.containsKey(ASName.k_Intent)) {
                this.intent = PDFRenderingIntent.getIntentForValue(imageDict.getName(ASName.k_Intent));
            }
            if (imageDict.containsKey(ASName.k_IM)) {
                this.imageMask = imageDict.getBoolean(ASName.k_IM).isTrue();
            } else if (imageDict.containsKey(ASName.k_ImageMask)) {
                this.imageMask = imageDict.getBoolean(ASName.k_ImageMask).isTrue();
            }
            if (imageDict.containsKey(ASName.k_I)) {
                this.interpolate = imageDict.getBoolean(ASName.k_I).isTrue();
            } else if (imageDict.containsKey(ASName.k_Interpolate)) {
                this.interpolate = imageDict.getBoolean(ASName.k_Interpolate).isTrue();
            }
        }
        catch (PDFUnableToCompleteOperationException e) {
            throw new PDFInvalidContentException("Invalid Image Dict", e);
        }
        if (imageDict.containsKey(ASName.k_CS)) {
            this.colorSpace = InlineImageColorSpace.createFromNameOrArray(imageDict.get(ASName.k_CS));
        } else if (imageDict.containsKey(ASName.k_ColorSpace)) {
            this.colorSpace = InlineImageColorSpace.createFromNameOrArray(imageDict.get(ASName.k_ColorSpace));
        }
        if (imageDict.containsKey(ASName.k_F)) {
            this.filters = imageDict.get(ASName.k_F);
        } else if (imageDict.containsKey(ASName.k_Filter)) {
            this.filters = imageDict.get(ASName.k_Filter);
        }
        if (imageDict.containsKey(ASName.k_DP)) {
            this.decodeParams = imageDict.get(ASName.k_DP);
        } else if (imageDict.containsKey(ASName.k_DecodeParms)) {
            this.decodeParams = imageDict.get(ASName.k_DecodeParms);
        }
        this.unencodedImageData = null;
        this.encodedImageData = encodedImageData;
    }

    private PDFColorSpace getPDFColorSpace(Content content) throws PDFIOException, PDFInvalidParameterException {
        try {
            InlineImageColorSpace cs = this.getColorSpace();
            if (cs == null) {
                return null;
            }
            if (cs.isDeviceColorSpace()) {
                ASName deviceCS = cs.getDeviceColorSpaceName();
                return this.getDeviceColorSpace(content.getPDFDocument(), deviceCS);
            }
            if (cs.isIndexedColorSpace()) {
                ASArray csArray = cs.getIndexedColorSpace();
                if ((csArray.get(0) == ASName.k_Indexed || csArray.get(0) == ASName.k_I) && csArray.size() == 4) {
                    PDFColorSpaceIndexed csIndexed = PDFColorSpaceIndexed.newInstance(content.getPDFDocument());
                    csIndexed.setBaseColorSpace(this.getDeviceColorSpace(content.getPDFDocument(), csArray.getName(1)));
                    csIndexed.setHighValue(csArray.getNumber(2).intValue());
                    csIndexed.setLookupData(csArray.getString(3).getBytes());
                    return csIndexed;
                }
            } else {
                if (cs.isNewResourceColorSpace()) {
                    return cs.getNewResourceColorSpace();
                }
                PDFResources resources = content.getResources();
                if (resources != null) {
                    ASName name = cs.getExistingResourceColorSpaceName();
                    return resources.getColorSpace(name);
                }
            }
        }
        catch (PDFUnableToCompleteOperationException e) {
            throw new PDFInvalidParameterException(e);
        }
        catch (PDFCosParseException e) {
            throw new PDFInvalidParameterException(e);
        }
        catch (PDFSecurityException e) {
            throw new PDFInvalidParameterException(e);
        }
        catch (PDFInvalidDocumentException e) {
            throw new PDFInvalidParameterException(e);
        }
        return null;
    }

    private PDFColorSpace getDeviceColorSpace(PDFDocument pdfDoc, ASName deviceCS) throws PDFInvalidDocumentException {
        if (deviceCS == ASName.k_DeviceRGB || deviceCS == ASName.k_RGB) {
            return PDFColorSpaceDeviceRGB.newInstance(this.content.getPDFDocument());
        }
        if (deviceCS == ASName.k_DeviceGray || deviceCS == ASName.k_G) {
            return PDFColorSpaceDeviceGray.newInstance(this.content.getPDFDocument());
        }
        if (deviceCS == ASName.k_DeviceCMYK || deviceCS == ASName.k_CMYK) {
            return PDFColorSpaceDeviceCMYK.newInstance(this.content.getPDFDocument());
        }
        return null;
    }

    private InlineImage(InputByteStream unencodedImageData, int height, int width, Integer bpc, PDFColorSpace colorSpace, PDFRenderingIntent intent, boolean imageMask, boolean interpolate, double[] imageDecodeArray, ASArray filters, ASArray filtersDecodeParams) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.height = height;
        this.width = width;
        this.bpc = bpc;
        this.colorSpace = new InlineImageColorSpace(colorSpace);
        this.intent = intent;
        this.imageMask = imageMask;
        this.interpolate = interpolate;
        this.decode = imageDecodeArray;
        this.filters = filters;
        this.decodeParams = filtersDecodeParams;
        try {
            this.unencodedImageData = unencodedImageData.toInputStream();
        }
        catch (IOException e) {
            throw new PDFIOException("Could not get the input stream for the unencoded image data", e);
        }
        this.encodedImageData = null;
    }

    public static InlineImage newInstance(Content content, ASDictionary imageDict, InputByteStream encodedImageData) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new InlineImage(content, imageDict, encodedImageData);
    }

    public static InlineImage newInstance(ASArray filters, ASArray filtersDecodeParams, InputByteStream unencodedImageData, int height, int width, Integer bpc, PDFColorSpace colorSpace, PDFRenderingIntent intent, boolean imageMask, boolean interpolate, double[] imageDecodeArray) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        return new InlineImage(unencodedImageData, height, width, bpc, colorSpace, intent, imageMask, interpolate, imageDecodeArray, filters, filtersDecodeParams);
    }

    public Content getContent() {
        return this.content;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public Integer getBitsPerComponent() {
        return this.bpc;
    }

    public InlineImageColorSpace getColorSpace() {
        return this.colorSpace;
    }

    public PDFRenderingIntent getIntent() {
        return this.intent;
    }

    public boolean isImageMask() {
        return this.imageMask;
    }

    public void setInterpolation(boolean interpolate) {
        this.interpolate = interpolate;
    }

    public boolean useInterpolation() {
        return this.interpolate;
    }

    public double[] getImageDecodeArray() {
        return this.decode;
    }

    public Object getStreamFiltersDecodeParams() {
        return this.decodeParams;
    }

    public Object getStreamFilters() {
        return this.filters;
    }

    public void setStreamFilters(ASName[] filterNames, ASDictionary[] decodeParamsArray) throws PDFIOException, PDFInvalidContentException {
        if (filterNames != null && filterNames.length > 0 && filterNames[0] != null) {
            if (filterNames.length == 1) {
                if (decodeParamsArray != null && decodeParamsArray.length > 0 && decodeParamsArray[0] != null) {
                    this.setStreamFilters(filterNames[0], decodeParamsArray[0]);
                } else {
                    this.setStreamFilters(filterNames[0], null);
                }
            } else {
                boolean decodeParamsHasNonNullValue = false;
                ASArray filters = new ASArray();
                ASArray decodeParams = new ASArray();
                for (int i = 0; i < filterNames.length; ++i) {
                    if (filterNames[i] == null) continue;
                    filters.add(filterNames[i]);
                    if (decodeParamsArray != null && i < decodeParamsArray.length && decodeParamsArray[i] != null) {
                        decodeParams.add(decodeParamsArray[i]);
                        decodeParamsHasNonNullValue = true;
                        continue;
                    }
                    decodeParams.add(null);
                }
                if (!decodeParamsHasNonNullValue) {
                    decodeParams = null;
                }
                this.setStreamFilters(filters, decodeParams);
            }
        } else {
            this.setStreamFilters((ASName)null, (ASDictionary)null);
        }
    }

    public void setStreamFilters(ASName filter, ASDictionary decodeParams) throws PDFIOException, PDFInvalidContentException {
        if (this.unencodedImageData == null) {
            this.unencodedImageData = this.getDecodedImageData();
        }
        this.encodedImageData = null;
        this.filters = filter;
        this.decodeParams = decodeParams;
    }

    public void setStreamFilters(ASArray filters, ASArray decodeParams) throws PDFIOException, PDFInvalidContentException {
        if (this.unencodedImageData == null) {
            this.unencodedImageData = this.getDecodedImageData();
        }
        this.encodedImageData = null;
        this.filters = filters;
        this.decodeParams = decodeParams;
    }

    public InputStream getImageData() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.unencodedImageData == null) {
            this.unencodedImageData = this.getDecodedImageData();
        }
        return this.unencodedImageData;
    }

    public InputByteStream getEncodedImageData(Content content) throws PDFIOException, PDFInvalidContentException {
        if (this.encodedImageData == null) {
            try {
                this.encodedImageData = this.createEncodedImageData(content);
            }
            catch (PDFInvalidParameterException e) {
                throw new PDFInvalidContentException(e);
            }
        }
        return this.encodedImageData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputByteStream createEncodedImageData(Content content) throws PDFIOException, PDFInvalidParameterException {
        InputByteStream inputByteStream;
        block30: {
            PaddedByteArrayOutputStream baos;
            if (content == null) {
                return null;
            }
            this.content = content;
            StreamManager stmMgr = content.getPDFDocument().getStreamManager();
            int maxSize = this.height * this.width * this.bpc / 8;
            OutputStream os = baos = new PaddedByteArrayOutputStream(maxSize);
            try {
                boolean emitLZWExtraPadding = false;
                if (this.filters != null) {
                    Object[] filterNames = null;
                    Object[] decodeParamDicts = null;
                    if (this.filters instanceof ASName) {
                        filterNames = new ASName[]{(ASName)this.filters};
                        if (this.decodeParams != null) {
                            decodeParamDicts = new ASObject[]{this.decodeParams};
                        }
                    } else if (this.filters instanceof ASArray) {
                        filterNames = new ASName[((ASArray)this.filters).size()];
                        filterNames = (ASName[])((ASArray)this.filters).toArray(filterNames);
                        if (this.decodeParams != null) {
                            decodeParamDicts = new ASObject[((ASArray)this.decodeParams).size()];
                            decodeParamDicts = (ASObject[])((ASArray)this.decodeParams).toArray(decodeParamDicts);
                        }
                    }
                    if (filterNames != null && filterNames.length != 0) {
                        PDFColorSpace colorspace = this.getPDFColorSpace(content);
                        for (int i = 0; i < filterNames.length; ++i) {
                            Object filter = filterNames[i];
                            Object paramsDict = null;
                            if (decodeParamDicts != null && decodeParamDicts.length > 0 && i < decodeParamDicts.length) {
                                paramsDict = decodeParamDicts[i];
                            }
                            FilterParams filterParams = null;
                            if (paramsDict != null && !(paramsDict instanceof ASNull)) {
                                filterParams = FilterStream.buildFilterParams(paramsDict);
                                filterParams.put("ColorSpace", colorspace != null ? colorspace.getCosObject() : null);
                            }
                            if (filterParams == null) {
                                filterParams = new FilterParams();
                            }
                            if (filter == ASName.k_ASCIIHexDecode || filter == ASName.k_AHx) {
                                os = new ASCIIHexOutputStream(os, filterParams);
                                continue;
                            }
                            if (filter == ASName.k_ASCII85Decode || filter == ASName.k_A85) {
                                os = new ASCII85OutputStream(os, filterParams);
                                continue;
                            }
                            if (filter == ASName.k_LZWDecode || filter == ASName.k_LZW) {
                                os = new LZWOutputStream(os, filterParams);
                                if (filterNames[0] != ASName.k_LZWDecode && filterNames[0] != ASName.k_LZW) continue;
                                emitLZWExtraPadding = true;
                                continue;
                            }
                            if (filter == ASName.k_FlateDecode || filter == ASName.k_Fl) {
                                os = new DeflaterOutputStream(os, new Deflater(9));
                                if (filterParams == null || !filterParams.containsKey("Predictor") || (Integer)filterParams.get("Predictor") == 1) continue;
                                os = new TIFFOutputStream(os, filterParams);
                                continue;
                            }
                            if (filter == ASName.k_RunLengthDecode || filter == ASName.k_RL) {
                                os = new RunLengthOutputStream(os);
                                continue;
                            }
                            if (filter == ASName.k_CCITTFaxDecode || filter == ASName.k_CCF) {
                                throw new PDFUnsupportedFeatureException("CCITTFax encoding is not currently supported");
                            }
                            if (filter == ASName.k_DCTDecode || filter == ASName.k_DCT) {
                                if (!InlineImage.DCTFilterSupported(content.getPDFDocument()) || filterNames.length != 1) {
                                    throw new PDFUnsupportedFeatureException("DCT encoding is not currently supported");
                                }
                                CustomFilterRegistry filterReg = content.getPDFDocument().getCosDocument().getOptions().getCustomFilterRegistry();
                                if (!filterReg.isEncodeFilterRegistered(ASName.k_DCTDecode)) continue;
                                try {
                                    if (!this.unencodedImageData.markSupported()) {
                                        throw new CustomFilterException("Unable to encode using DCT filter");
                                    }
                                    os = filterReg.encode(ASName.k_DCTDecode, os, filterParams);
                                    this.unencodedImageData.reset();
                                    this.decodeParams = FilterStream.updateCustomFilterParams((ASName)filter, filterParams.toASDictionary(), filterReg);
                                    continue;
                                }
                                catch (CustomFilterException e) {
                                    throw new PDFIOException("Unable to use filter registry to encode stream that uses " + filter, e);
                                }
                            }
                            if (filter == null) continue;
                            throw new PDFUnsupportedFeatureException("Unrecognized filter \"" + filter + "\" not supported");
                        }
                    }
                }
                IO.copy(this.unencodedImageData, os);
                os.flush();
                if (emitLZWExtraPadding) {
                    baos.setPaddingByte((byte)32);
                    baos.setPaddingSize(2);
                }
                ((OutputStream)os).close();
                os = null;
                inputByteStream = stmMgr.getInputByteStream(baos.toByteArray());
                if (os == null) break block30;
            }
            catch (Throwable throwable) {
                try {
                    if (os != null) {
                        ((OutputStream)os).close();
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new PDFIOException("A problem was encountered trying to encode inline image data.", e);
                }
            }
            ((OutputStream)os).close();
        }
        return inputByteStream;
    }

    public ASDictionary createImageDict(ModifiableContent content) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        ASDictionary dict = new ASDictionary();
        dict.put(ASName.k_H, new ASNumber(this.height));
        dict.put(ASName.k_W, new ASNumber(this.width));
        if (this.bpc != null) {
            dict.put(ASName.k_BPC, new ASNumber(this.bpc));
        } else if (!this.imageMask) {
            throw new PDFInvalidParameterException("BitsPerComponent must be specified for inline images that are not image masks");
        }
        if (this.imageMask) {
            dict.put(ASName.k_IM, new ASBoolean(this.imageMask));
            if (this.bpc != 1) {
                throw new PDFInvalidParameterException("BitsPerComponent must be set to 1 for image masks");
            }
            if (this.colorSpace != null) {
                throw new PDFInvalidParameterException("A color space should not be specified for image masks");
            }
        }
        if (this.colorSpace != null && this.colorSpace.isNewResourceColorSpace()) {
            PDFColorSpace newCS = this.colorSpace.getNewResourceColorSpace();
            if (newCS instanceof PDFColorSpaceDeviceRGB || newCS instanceof PDFColorSpaceDeviceCMYK || newCS instanceof PDFColorSpaceDeviceGray) {
                dict.put(ASName.k_CS, newCS.getName());
            } else {
                dict.put(ASName.k_CS, content.addResource(newCS));
            }
        } else if (this.colorSpace != null && this.colorSpace.isDeviceColorSpace()) {
            dict.put(ASName.k_CS, this.colorSpace.getDeviceColorSpaceName());
        } else if (this.colorSpace != null && this.colorSpace.isExistingResourceColorSpaceName()) {
            dict.put(ASName.k_CS, this.colorSpace.getExistingResourceColorSpaceName());
        } else if (this.colorSpace != null && this.colorSpace.isIndexedColorSpace()) {
            dict.put(ASName.k_CS, this.colorSpace.getIndexedColorSpace());
        } else if (!this.imageMask) {
            throw new PDFInvalidParameterException("A color space must be specified for inline images that are not image masks");
        }
        if (this.intent != null) {
            dict.put(ASName.k_Intent, this.intent.getValue());
        }
        if (this.interpolate) {
            dict.put(ASName.k_I, new ASBoolean(this.interpolate));
        }
        if (this.filters != null) {
            dict.put(ASName.k_F, this.filters);
        }
        if (this.decodeParams != null) {
            dict.put(ASName.k_DP, this.decodeParams);
        }
        return dict;
    }

    private InputStream getDecodedImageData() throws PDFIOException, PDFInvalidContentException {
        ASArray filterNames = new ASArray();
        if (this.filters instanceof ASName) {
            filterNames.add(this.filters);
        } else if (this.filters instanceof ASArray) {
            filterNames = (ASArray)this.filters;
        }
        FilterParams filterParams = null;
        try {
            filterParams = FilterStream.buildFilterParams(this.decodeParams);
        }
        catch (PDFInvalidParameterException e1) {
            throw new PDFInvalidContentException("Invalid Decode Params Dict", e1);
        }
        if (filterParams == null) {
            filterParams = new FilterParams();
        }
        InputStream is = null;
        try {
            is = this.encodedImageData.toInputStream();
        }
        catch (IOException e) {
            throw new PDFIOException("Cannot get the input stream for an inline image's encoded image data", e);
        }
        if (filterNames != null && filterNames.size() != 0) {
            for (int i = 0; i < filterNames.size(); ++i) {
                ASName filter;
                try {
                    filter = filterNames.getName(i);
                }
                catch (PDFUnableToCompleteOperationException e) {
                    throw new PDFInvalidContentException("Invaid filters array", e);
                }
                if (filter == ASName.k_AHx || filter == ASName.k_ASCIIHexDecode) {
                    is = new ASCIIHexInputStream(is, filterParams);
                    continue;
                }
                if (filter == ASName.k_A85 || filter == ASName.k_ASCII85Decode) {
                    is = new ASCII85InputStream(is, filterParams);
                    continue;
                }
                if (filter == ASName.k_Fl || filter == ASName.k_FlateDecode) {
                    InflaterInputStream result = new InflaterInputStream(is);
                    if (filterParams != null && filterParams.containsKey("Predictor") && (Integer)filterParams.get("Predictor") != 1) {
                        is = new TIFFInputStream(result, filterParams);
                        continue;
                    }
                    is = result;
                    continue;
                }
                if (filter == ASName.k_LZW || filter == ASName.k_LZWDecode) {
                    is = new LZWInputStream(is, filterParams);
                    continue;
                }
                if (filter == ASName.k_RL || filter == ASName.k_RunLengthDecode) {
                    is = new RunLengthInputStream(is, filterParams);
                    continue;
                }
                if (filter == ASName.k_CCF || filter == ASName.k_CCITTFaxDecode) {
                    is = new CCITTFaxInputStream(is, filterParams);
                    continue;
                }
                if (filter != ASName.k_DCT && filter != ASName.k_DCTDecode) continue;
                is = new DCTInputStream(is, filterParams);
            }
        }
        return is;
    }

    private static boolean DCTFilterSupported(PDFDocument doc) {
        CustomFilterRegistry registry = doc.getCosDocument().getOptions().getCustomFilterRegistry();
        if (registry != null) {
            return registry.isEncodeFilterRegistered(ASName.k_DCTDecode);
        }
        return false;
    }

    public void close() throws PDFIOException {
        try {
            if (this.unencodedImageData != null) {
                this.unencodedImageData.close();
            }
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
        finally {
            try {
                if (this.encodedImageData != null) {
                    this.encodedImageData.close();
                }
            }
            catch (IOException e) {
                throw new PDFIOException(e);
            }
        }
    }

    static class PaddedByteArrayOutputStream
    extends ByteArrayOutputStream {
        private int paddingSize;
        private byte paddingByte = (byte)32;

        PaddedByteArrayOutputStream() {
        }

        PaddedByteArrayOutputStream(int size) {
            super(size);
        }

        @Override
        public void close() throws IOException {
            for (int i = 0; i < this.paddingSize; ++i) {
                this.write(32);
            }
            super.close();
        }

        void setPaddingSize(int paddingSize) {
            this.paddingSize = paddingSize;
        }

        int getPaddingSize() {
            return this.paddingSize;
        }

        void setPaddingByte(byte paddingByte) {
            this.paddingByte = paddingByte;
        }

        byte getPaddingByte() {
            return this.paddingByte;
        }
    }
}

