/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.xobject;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpace;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceGray;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceRGB;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceFactory;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceIndexed;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import java.util.ArrayList;

public class PDFThumbnailImage
extends PDFXObject {
    protected PDFThumbnailImage(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosObject);
    }

    public static PDFThumbnailImage getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFThumbnailImage pdfObject = (PDFThumbnailImage)PDFCosObject.getCachedInstance(cosObject, PDFThumbnailImage.class);
        if (pdfObject == null) {
            pdfObject = new PDFThumbnailImage(cosObject);
        }
        return pdfObject;
    }

    public static PDFThumbnailImage newInstance(PDFDocument pdfDocument) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        CosStream cosObject = PDFCosObject.newCosStream(pdfDocument);
        PDFThumbnailImage pdfObject = new PDFThumbnailImage(cosObject);
        pdfObject.setDictionaryNameValue(ASName.k_Type, ASName.k_XObject);
        pdfObject.setDictionaryNameValue(ASName.k_Subtype, ASName.k_Image);
        return pdfObject;
    }

    public int getWidth() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(ASName.k_Width);
    }

    public void setWidth(int width) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_Width, width);
    }

    public int getHeight() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(ASName.k_Height);
    }

    public void setHeight(int height) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_Height, height);
    }

    public void setColorSpace(PDFColorSpace colorSpace) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (colorSpace instanceof PDFColorSpaceDeviceGray || colorSpace instanceof PDFColorSpaceDeviceRGB || colorSpace instanceof PDFColorSpaceIndexed) {
            this.setDictionaryValue(ASName.k_ColorSpace, colorSpace);
        }
    }

    public PDFColorSpace getColorSpace() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject colorSpaceObj = this.getDictionaryCosObjectValue(ASName.k_ColorSpace);
        return PDFColorSpaceFactory.getInstance(colorSpaceObj);
    }

    public void setBitsPerComponent(int bitsPerComponent) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_BitsPerComponent, bitsPerComponent);
    }

    public int getBitsPerComponent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(ASName.k_BitsPerComponent);
    }

    public void setDecode(double[] decodeArray) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        ArrayList<Double> decodeList = null;
        if (decodeArray != null) {
            decodeList = new ArrayList<Double>(decodeArray.length);
            for (int indx = 0; indx < decodeArray.length; ++indx) {
                decodeList.add(indx, new Double(decodeArray[indx]));
            }
        }
        this.setDictionaryArrayValue(ASName.k_Decode, decodeList);
    }

    public double[] getDecode() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName decodeKey = ASName.k_Decode;
        if (!this.dictionaryContains(decodeKey)) {
            return null;
        }
        CosArray decodeList = this.getDictionaryArrayValue(decodeKey);
        double[] result = decodeList.getArrayDouble();
        return result;
    }

    public void setSubType(ASName subType) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (subType.equals(ASName.k_Image)) {
            this.setDictionaryNameValue(ASName.k_Subtype, subType);
        }
        throw new PDFInvalidParameterException("If a Subtype entry is specified, its value shall be Image.");
    }
}

