/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.shading;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFFunction;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFFunctionsArray;
import com.adobe.internal.pdftoolkit.pdf.graphics.shading.PDFShadingNoMeshes;
import com.adobe.internal.pdftoolkit.pdf.graphics.shading.PDFShadingType;

public class PDFShadingFunction
extends PDFShadingNoMeshes {
    private PDFShadingFunction(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    private PDFShadingFunction(PDFDocument pdfDocument, PDFFunction key_FunctionArray) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        super(PDFCosObject.newCosDictionary(pdfDocument));
        this.setFunctionArray(key_FunctionArray);
        this.setShadingType(PDFShadingType.SHADING_TYPE_FUNCTION.getValue());
    }

    public static PDFShadingFunction newInstance(PDFDocument pdfDocument, PDFFunction key_FunctionArray) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (key_FunctionArray == null) {
            throw new PDFInvalidParameterException("FunctionOrFunctionsArray is required when creating newInstance of PDFShadingFunction.");
        }
        return new PDFShadingFunction(pdfDocument, key_FunctionArray);
    }

    public static PDFShadingFunction getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFShadingFunction pdfObject = (PDFShadingFunction)PDFCosObject.getCachedInstance(cosObject, PDFShadingFunction.class);
        if (pdfObject == null) {
            pdfObject = new PDFShadingFunction(cosObject);
        }
        return pdfObject;
    }

    public CosArray getDomain() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryArrayValue(ASName.k_Domain);
    }

    public void setDomain(CosArray value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_Domain, value);
    }

    public boolean hasDomain() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Domain);
    }

    public void setFunctionArray(PDFFunction value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setFunctionArray(value, true);
    }

    public void setFunctionArray(PDFFunctionsArray children) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setFunctionArray(children, true);
    }

    public ASMatrix getMatrix() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASMatrix matrix = null;
        CosArray cosArray = this.getDictionaryArrayValue(ASName.k_Matrix);
        matrix = cosArray != null ? new ASMatrix(cosArray.getArrayDouble()) : ASMatrix.createIdentityMatrix();
        return matrix;
    }

    public void setMatrix(ASMatrix matrix) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = null;
        if (matrix != null) {
            cosArray = PDFCosObject.newCosArray(this.getPDFDocument());
            double[] values = matrix.getValues();
            for (int i = 0; i < 6; ++i) {
                cosArray.addDouble(i, values[i]);
            }
        }
        this.setDictionaryArrayValue(ASName.k_Matrix, cosArray);
    }

    public boolean hasMatrix() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Matrix);
    }
}

