/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.shading;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFFunction;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFFunctionsArray;
import com.adobe.internal.pdftoolkit.pdf.graphics.shading.PDFShadingMeshes;
import com.adobe.internal.pdftoolkit.pdf.graphics.shading.PDFShadingType;

public class PDFShadingCoons
extends PDFShadingMeshes {
    private PDFShadingCoons(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosObject);
    }

    private PDFShadingCoons(PDFDocument pdfDocument, int key_BitsPerComponent, CosArray key_Decode, int key_BitsPerCoordinate, int key_BitsPerFlag) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        super(PDFCosObject.newCosStream(pdfDocument));
        this.setBitsPerComponent(key_BitsPerComponent);
        this.setDecode(key_Decode);
        this.setShadingType(PDFShadingType.SHADING_TYPE_COONS.getValue());
        this.setBitsPerCoordinate(key_BitsPerCoordinate);
        this.setBitsPerFlag(key_BitsPerFlag);
    }

    public static PDFShadingCoons newInstance(PDFDocument pdfDocument, int key_BitsPerComponent, CosArray key_Decode, int key_BitsPerCoordinate, int key_BitsPerFlag) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (key_Decode == null) {
            throw new PDFInvalidDocumentException("Decode is required when creating newInstance of PDFShadingCoons.");
        }
        return new PDFShadingCoons(pdfDocument, key_BitsPerComponent, key_Decode, key_BitsPerCoordinate, key_BitsPerFlag);
    }

    public static PDFShadingCoons getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFShadingCoons pdfObject = (PDFShadingCoons)PDFCosObject.getCachedInstance(cosObject, PDFShadingCoons.class);
        if (pdfObject == null) {
            pdfObject = new PDFShadingCoons(cosObject);
        }
        return pdfObject;
    }

    public void setFunctionArray(PDFFunction value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setFunctionArray(value, false);
    }

    public void setFunctionArray(PDFFunctionsArray children) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setFunctionArray(children, false);
    }

    public int getBitsPerFlag() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(ASName.k_BitsPerFlag);
    }

    public void setBitsPerFlag(int value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_BitsPerFlag, value);
    }

    public int requireBitsPerFlag() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getDictionaryCosObjectValue(ASName.k_BitsPerFlag);
        if (cosObject == null) {
            throw new PDFInvalidDocumentException("Unable to get BitsPerFlag.");
        }
        return ((CosNumeric)cosObject).intValue();
    }

    public boolean hasBitsPerFlag() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_BitsPerFlag);
    }
}

