/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosArrayList;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCGroup;

public class PDFOCGroupArray
extends PDFCosArrayList<PDFOCGroup> {
    private PDFOCGroupArray(CosObject cosArray) throws PDFInvalidDocumentException {
        super(cosArray);
    }

    public static PDFOCGroupArray getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFOCGroupArray pdfObject = (PDFOCGroupArray)PDFCosObject.getCachedInstance(cosObject, PDFOCGroupArray.class);
        if (pdfObject == null) {
            pdfObject = new PDFOCGroupArray(cosObject);
        }
        return pdfObject;
    }

    public static PDFOCGroupArray newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObject = PDFCosObject.newCosArray(pdfDocument);
        return new PDFOCGroupArray(cosObject);
    }

    public static PDFOCGroupArray newInstance(PDFDocument pdfDocument, PDFOCGroup ocg) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOCGroupArray pdfObject = PDFOCGroupArray.newInstance(pdfDocument);
        pdfObject.add(ocg);
        return pdfObject;
    }

    @Override
    protected PDFOCGroup itemInstantiator(CosObject cosObject) throws PDFCosParseException, PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        return PDFOCGroup.getInstance(cosObject);
    }

    public boolean contains(PDFOCGroup ocg) {
        return super.contains(ocg);
    }

    public PDFOCGroup getOCGByName(String name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOCGroup result = null;
        for (PDFOCGroup ocg : this) {
            String ocgName;
            if (ocg == null || !(ocgName = ocg.getName()).equals(name)) continue;
            result = ocg;
            break;
        }
        return result;
    }
}

