/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCIntentList;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCOrderListContent;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCProperties;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCUsage;

public class PDFOCGroup
extends PDFOCObject
implements PDFOCOrderListContent {
    protected PDFOCGroup(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFOCGroup getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFOCGroup pdfObject = (PDFOCGroup)PDFCosObject.getCachedInstance(cosObject, PDFOCGroup.class);
        if (pdfObject == null) {
            pdfObject = new PDFOCGroup(cosObject);
        }
        return pdfObject;
    }

    public static PDFOCGroup newInstance(PDFDocument pdfDoc, String name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOCGroup ocg = new PDFOCGroup(PDFCosObject.newCosDictionary(pdfDoc));
        ocg.setName(name);
        ocg.setDictionaryNameValue(ASName.k_Type, ASName.k_OCG);
        PDFOCProperties props = pdfDoc.requireCatalog().getOCProperties();
        if (props == null) {
            props = PDFOCProperties.newInstance(pdfDoc);
            pdfDoc.requireCatalog().setOCProperties(props);
        }
        props.addOCG(ocg);
        return ocg;
    }

    public void setName(String name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_Name, name);
    }

    public String getName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryTextStringValue(ASName.k_Name);
    }

    @Override
    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }

    public void setIntentView() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOCIntentList intentList;
        try {
            intentList = PDFOCIntentList.newInstance(this.getPDFDocument(), ASName.k_View);
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException(e);
        }
        this.setIntent(intentList);
    }

    public void setIntentDesign() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOCIntentList intentList;
        try {
            intentList = PDFOCIntentList.newInstance(this.getPDFDocument(), ASName.k_Design);
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException(e);
        }
        this.setIntent(intentList);
    }

    public void addIntent(ASName intent) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject obj = this.getDictionaryCosObjectValue(ASName.k_Intent);
        if (obj instanceof CosName) {
            PDFOCIntentList newList;
            try {
                newList = PDFOCIntentList.newInstance(this.getPDFDocument(), ((CosName)obj).nameValue());
            }
            catch (PDFInvalidParameterException e) {
                throw new PDFInvalidDocumentException(e);
            }
            this.setIntent(newList);
            obj = newList.getCosObject();
        }
        if (obj instanceof CosArray) {
            CosArray arrayObj = (CosArray)obj;
            arrayObj.addName(intent);
        }
    }

    private void setIntent(PDFOCIntentList intentList) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Intent, intentList);
    }

    public PDFOCIntentList getIntent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject obj = this.getDictionaryCosObjectValue(ASName.k_Intent);
        return PDFOCIntentList.getInstance(obj);
    }

    public void setUsage(PDFOCUsage usage) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Usage, usage);
    }

    public PDFOCUsage getUsage() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary usage = this.getDictionaryDictionaryValue(ASName.k_Usage);
        return PDFOCUsage.getInstance(usage);
    }

    @Override
    public String toString() {
        try {
            return "[object OCG=\"" + this.getName() + "\"]";
        }
        catch (PDFInvalidDocumentException e) {
            throw new IllegalArgumentException("PDF document is invalid", e);
        }
        catch (PDFIOException e) {
            throw new RuntimeException(e);
        }
        catch (PDFSecurityException e) {
            throw new RuntimeException(e);
        }
    }
}

