/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.font;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.AdobeGlyphList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class PDFEncodingDifferences
extends PDFCosObject {
    private final Map<Integer, ASName> diffs = this.initDiffs();

    private PDFEncodingDifferences(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFEncodingDifferences getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFEncodingDifferences pdfObject = (PDFEncodingDifferences)PDFCosObject.getCachedInstance(cosObject, PDFEncodingDifferences.class);
        if (pdfObject == null) {
            pdfObject = new PDFEncodingDifferences(cosObject);
        }
        return pdfObject;
    }

    public static PDFEncodingDifferences newInstance(PDFDocument pdfDocument, Map<Integer, String> mapDifferences) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObject = PDFCosObject.newCosArray(pdfDocument);
        PDFEncodingDifferences pdfObject = new PDFEncodingDifferences(cosObject);
        for (Map.Entry<Integer, String> entry : mapDifferences.entrySet()) {
            Integer charCode = entry.getKey();
            ASName gNameASName = ASName.create(entry.getValue());
            pdfObject.getCosArray().addInt(charCode);
            pdfObject.getCosArray().addName(gNameASName);
            pdfObject.diffs.put(charCode, gNameASName);
        }
        return pdfObject;
    }

    public void updateDifferences() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getCosArray().clear();
        for (Map.Entry<Integer, ASName> entry : this.diffs.entrySet()) {
            this.getCosArray().addInt(entry.getKey());
            this.getCosArray().addName(entry.getValue());
        }
    }

    public void addDifference(Integer charCode, ASName gNameASName) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        this.getCosArray().addInt(charCode);
        this.getCosArray().addName(gNameASName);
        this.diffs.put(charCode, gNameASName);
    }

    public Set<Map.Entry<Integer, ASName>> entrySet() {
        return this.diffs.entrySet();
    }

    public Set keySet() {
        return this.diffs.keySet();
    }

    public boolean contains(int charCode) {
        return this.diffs.containsKey(charCode);
    }

    public boolean contains(ASName glyphName) {
        return this.diffs.containsValue(glyphName);
    }

    public ASName toGlyphName(int charCode) {
        return this.diffs.get(charCode);
    }

    public char[] toUnicode(int charCode) {
        ASName charName = this.toGlyphName(charCode);
        if (charName == null) {
            char[] chars = new char[]{'\ufffd'};
            return chars;
        }
        AdobeGlyphList glyphList = AdobeGlyphList.get();
        char[] unicode = glyphList.toUnicode(charName);
        if (unicode[0] == '\ufffd') {
            try {
                String charNameStr = charName.asString();
                if (charNameStr.matches("[0-9]+")) {
                    Integer decVal = Integer.decode(charNameStr);
                    char[] directUnicode = new char[]{(char)decVal.intValue()};
                    return directUnicode;
                }
                if (charNameStr.length() > 0 && charNameStr.charAt(0) == 'n') {
                    String hexDigits = charNameStr.substring(1);
                    int len = hexDigits.length();
                    int size = (len + 1) / 2;
                    char[] directUnicode = new char[size];
                    int j = 0;
                    for (int i = 0; i < size; ++i) {
                        String hexStr = null;
                        hexStr = i == size - 1 ? hexDigits.substring(2 * i) : hexDigits.substring(2 * i, 2 * i + 2);
                        Integer hexVal = Integer.decode("0x" + hexStr);
                        directUnicode[j++] = (char)hexVal.intValue();
                    }
                    return directUnicode;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return unicode;
    }

    public int fromGlyphName(ASName glyphName) {
        if (this.contains(glyphName)) {
            Set<Map.Entry<Integer, ASName>> entrySet = this.diffs.entrySet();
            for (Map.Entry<Integer, ASName> entry : entrySet) {
                ASName value = entry.getValue();
                if (value != glyphName) continue;
                Integer charCode = entry.getKey();
                return charCode;
            }
        }
        return 0;
    }

    private Map<Integer, ASName> initDiffs() {
        CosArray array = this.getCosArray();
        int size = array.size();
        if (size == 0) {
            return new LinkedHashMap<Integer, ASName>();
        }
        LinkedHashMap<Integer, ASName> map = new LinkedHashMap<Integer, ASName>(size - 1);
        Iterator<CosObject> iter = array.iterator();
        int charCode = 0;
        while (iter.hasNext()) {
            CosObject item = iter.next();
            if (item instanceof CosNumeric) {
                charCode = ((CosNumeric)item).intValue();
                continue;
            }
            if (!(item instanceof CosName)) continue;
            map.put(charCode++, ((CosName)item).nameValue());
        }
        return map;
    }
}

