/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.font;

import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontImpl;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.PDFFontDescription;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.OpenTypeFont;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.GlyphIDHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeSet;

public class PDFCIDFontWidths
extends PDFCosObject {
    private Font afeFont = null;
    private TreeSet widths;
    private int cachedCID;
    private boolean isCIDCached = false;
    private WidthEntry cachedEntry;
    private CosObject widthObj;

    public void buildWidths(Iterator<GlyphIDHolder> gidIter, PDFFontDescription desc, double dw) throws InvalidFontException, UnsupportedFontException, FontLoadingException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ArrayList<Entry> cidList = new ArrayList<Entry>();
        while (gidIter.hasNext()) {
            int gid = gidIter.next().getGlyphID();
            int cid = desc.getGlyphCid(gid);
            if (this.containsWidth(cid) || (double)Math.round(desc.getAdvance(gid)) == dw) continue;
            cidList.add(new Entry(gid, cid));
        }
        if (cidList.isEmpty()) {
            return;
        }
        Object[] cidArray = new Entry[cidList.size()];
        cidArray = cidList.toArray(cidArray);
        Arrays.sort(cidArray);
        int i = 0;
        double[] widths = new double[cidArray.length];
        int startGID = ((Entry)cidArray[0]).gid;
        int startCID = ((Entry)cidArray[0]).cid;
        while (i < cidArray.length) {
            int lastCID = startCID;
            int nextGID = 0;
            int nextCID = 0;
            widths[0] = desc.getAdvance(startGID);
            int j = i + 1;
            if (j < cidArray.length) {
                nextGID = ((Entry)cidArray[j]).gid;
                nextCID = ((Entry)cidArray[j]).cid;
                double nextWidth = desc.getAdvance(nextGID);
                while (nextCID == startCID + (j - i)) {
                    widths[j - i] = nextWidth;
                    lastCID = nextCID;
                    if (++j >= cidArray.length) break;
                    nextGID = ((Entry)cidArray[j]).gid;
                    nextCID = ((Entry)cidArray[j]).cid;
                    nextWidth = desc.getAdvance(nextGID);
                }
            }
            this.addWidths(widths, startCID, lastCID);
            i = j;
            startCID = nextCID;
            startGID = nextGID;
        }
    }

    private PDFCIDFontWidths(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
        this.widthObj = cosObject;
    }

    private PDFCIDFontWidths(CosObject cosObject, Font afeFont) throws PDFInvalidDocumentException {
        super(cosObject);
        this.afeFont = afeFont;
        this.widthObj = cosObject;
    }

    public static PDFCIDFontWidths getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFCIDFontWidths pdfObject = (PDFCIDFontWidths)PDFCosObject.getCachedInstance(cosObject, PDFCIDFontWidths.class);
        if (pdfObject == null) {
            pdfObject = new PDFCIDFontWidths(cosObject);
        }
        pdfObject.buildWidthsTable();
        return pdfObject;
    }

    public static PDFCIDFontWidths newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObject = PDFCosObject.newCosArray(pdfDocument);
        PDFCIDFontWidths pdfObject = new PDFCIDFontWidths(cosObject);
        pdfObject.widths = new TreeSet();
        pdfObject.widthObj = null;
        return pdfObject;
    }

    public static PDFCIDFontWidths newInstance(PDFDocument pdfDocument, Font afeFont) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObject = PDFCosObject.newCosArray(pdfDocument);
        PDFCIDFontWidths pdfObject = new PDFCIDFontWidths(cosObject, afeFont);
        pdfObject.widths = new TreeSet();
        pdfObject.widthObj = null;
        pdfObject.buildWidthsTableFromFont();
        return pdfObject;
    }

    public static PDFCIDFontWidths newInstance(PDFDocument pdfDocument, double[] widths, int startCID) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFCIDFontWidths pdfObject = PDFCIDFontWidths.newInstance(pdfDocument);
        pdfObject.addWidths(widths, startCID, startCID + widths.length - 1);
        return pdfObject;
    }

    public void addWidths(double[] widths, int startCID, int endCID) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosWidths = PDFCosObject.newCosArray(this.getPDFDocument());
        for (int i = startCID; i <= endCID; ++i) {
            cosWidths.addDouble(widths[i - startCID]);
        }
        this.getCosArray().addInt(startCID);
        this.getCosArray().add(cosWidths);
        this.updateWidthsTable(startCID, cosWidths);
    }

    public void addWidths(ArrayList<Double> widths, int startCID, int endCID) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!widths.isEmpty()) {
            double[] dwidths = new double[widths.size()];
            for (int i = 0; i < widths.size(); ++i) {
                dwidths[i] = widths.get(i);
            }
            this.addWidths(dwidths, startCID, endCID);
            widths.clear();
        }
    }

    public boolean containsWidth(int cid) {
        return this.getEntry(cid) != null;
    }

    public double getWidth(int cid) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        WidthEntry entry = this.getEntry(cid);
        if (entry != null) {
            return entry.getWidth(cid);
        }
        return 0.0;
    }

    private WidthEntry getEntry(int cid) {
        if (this.isCIDCached && cid == this.cachedCID) {
            return this.cachedEntry;
        }
        for (WidthEntry entry : this.widths) {
            if (!entry.contains(cid)) continue;
            this.isCIDCached = true;
            this.cachedCID = cid;
            this.cachedEntry = entry;
            return entry;
        }
        return null;
    }

    private void buildWidthsTable() {
        if (this.widths == null) {
            this.widths = new TreeSet();
            Iterator<CosObject> iter = this.getCosArray().iterator();
            while (iter.hasNext()) {
                CosObject cosobj = iter.next();
                if (!(cosobj instanceof CosNumeric)) continue;
                int startCID = ((CosNumeric)cosobj).intValue();
                CosObject item = iter.next();
                if (item instanceof CosArray) {
                    this.widths.add(new WidthEntry(startCID, (CosArray)item));
                    continue;
                }
                int endCID = ((CosNumeric)item).intValue();
                double width = ((CosNumeric)iter.next()).doubleValue();
                this.widths.add(new WidthEntry(startCID, endCID, width));
            }
        }
    }

    private void buildWidthsTableFromFont() {
        try {
            if (this.afeFont != null && ((FontImpl)this.afeFont).getFontData() instanceof OpenTypeFont) {
                OpenTypeFont otFont = (OpenTypeFont)((FontImpl)this.afeFont).getFontData();
                this.widths = new TreeSet();
                PDFFontDescription pdfDesc = this.afeFont.getPDFFontDescription();
                GlyphIterator gidIter = new GlyphIterator(pdfDesc.getNumGlyphs());
                ArrayList<Double> widths = new ArrayList<Double>();
                int startCID = 0;
                int endCID = 0;
                while (gidIter.hasNext()) {
                    int gid = ((GlyphIDHolder)gidIter.next()).getGlyphID();
                    int cid = otFont.getGlyphCid(gid);
                    double width = otFont.getHorizontalAdvance(gid);
                    if (cid != endCID + 1) {
                        this.addWidths(widths, startCID, endCID);
                    }
                    if (width > 0.0) {
                        if (widths.isEmpty()) {
                            startCID = cid;
                        }
                        widths.add(new Double(width));
                    } else {
                        this.addWidths(widths, startCID, endCID);
                    }
                    endCID = cid;
                }
                this.addWidths(widths, startCID, endCID);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateWidthsTable(int startCID, CosArray newWidths) {
        if (this.widths == null) {
            this.widths = new TreeSet();
        }
        this.widths.add(new WidthEntry(startCID, newWidths));
    }

    public CosObject toCosArray() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.widthObj != null) {
            return this.widthObj;
        }
        if (this.widths == null) {
            return null;
        }
        CosArray cosCIDFontWidths = PDFCosObject.newCosArray(this.getPDFDocument());
        for (WidthEntry widthEntry : this.widths) {
            CosArray cosWidths = widthEntry.getWidths();
            if (cosWidths != null) {
                cosCIDFontWidths.addInt(widthEntry.getStartCID());
                cosCIDFontWidths.add(cosWidths);
                continue;
            }
            cosCIDFontWidths.addInt(widthEntry.getStartCID());
            cosCIDFontWidths.addInt(widthEntry.getEndCID());
            cosCIDFontWidths.addDouble(widthEntry.getWidth(widthEntry.getStartCID()));
        }
        return cosCIDFontWidths;
    }

    private static class GlyphIterator
    implements Iterator {
        int numGlyphs;
        int currGlyph;

        GlyphIterator(int numGlyphs) {
            this.numGlyphs = numGlyphs;
            this.currGlyph = 0;
        }

        @Override
        public boolean hasNext() {
            return this.currGlyph < this.numGlyphs;
        }

        public Object next() {
            return new GlyphDesc(this.currGlyph++);
        }

        @Override
        public void remove() {
        }
    }

    private static class GlyphDesc
    implements GlyphIDHolder {
        int gid;

        GlyphDesc(int gid) {
            this.gid = gid;
        }

        @Override
        public int getGlyphID() {
            return this.gid;
        }
    }

    static class WidthEntry
    implements Comparable {
        private final int startCID;
        private final int endCID;
        private final CosArray widths;
        private final double width;

        WidthEntry(int startCID, CosArray widths) {
            this.startCID = startCID;
            this.endCID = startCID + widths.size() - 1;
            this.widths = widths;
            this.width = 0.0;
        }

        WidthEntry(int startCID, int endCID, double width) {
            this.startCID = startCID;
            this.endCID = endCID;
            this.widths = null;
            this.width = width;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            if (this.widths != null) {
                result.append(this.startCID).append(" [ ");
                Iterator<CosObject> iter = this.widths.iterator();
                while (iter.hasNext()) {
                    result = result.append(((CosNumeric)iter.next()).intValue()).append(" ");
                }
                result.append("]");
            } else {
                result.append(this.startCID).append(" ").append(this.endCID).append(" ");
                result.append(this.width);
            }
            return result.toString();
        }

        int getStartCID() {
            return this.startCID;
        }

        int getEndCID() {
            return this.endCID;
        }

        CosArray getWidths() {
            return this.widths;
        }

        boolean contains(int cid) {
            return cid >= this.startCID && cid <= this.endCID;
        }

        double getWidth(int cid) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            if (this.widths != null) {
                return this.widths.getDouble(cid - this.startCID);
            }
            return this.width;
        }

        public int compareTo(Object o) {
            int startDiff = this.startCID - ((WidthEntry)o).startCID;
            if (startDiff != 0) {
                return startDiff;
            }
            return this.endCID - ((WidthEntry)o).endCID;
        }
    }

    private static class Entry
    implements Comparable {
        int gid;
        int cid;

        public int compareTo(Object o) {
            return this.cid - ((Entry)o).cid;
        }

        Entry(int gid, int cid) {
            this.gid = gid;
            this.cid = cid;
        }
    }
}

