/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.font;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;

class DisplacementEntry {
    private final int startCID;
    private final int endCID;
    private final Object metrics;

    DisplacementEntry(int startCID, CosArray metrics) {
        this.startCID = startCID;
        this.endCID = startCID + metrics.size() / 3;
        this.metrics = metrics;
    }

    DisplacementEntry(int startCID, int endCID, double w11y, double v1x, double v1y) {
        this.startCID = startCID;
        this.endCID = endCID;
        this.metrics = new double[3];
        ((double[])this.metrics)[0] = w11y;
        ((double[])this.metrics)[1] = v1x;
        ((double[])this.metrics)[2] = v1y;
    }

    int getStartCID() {
        return this.startCID;
    }

    int getEndCID() {
        return this.endCID;
    }

    boolean contains(int cid) {
        return cid >= this.startCID && cid <= this.endCID;
    }

    double[] getMetrics(int cid) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        double[] vector = new double[3];
        if (this.metrics instanceof CosArray) {
            int base = (cid - this.startCID) * 3;
            vector[0] = ((CosArray)this.metrics).getDouble(base);
            vector[1] = ((CosArray)this.metrics).getDouble(base + 1);
            vector[2] = ((CosArray)this.metrics).getDouble(base + 2);
        } else {
            vector = (double[])this.metrics;
        }
        return vector;
    }

    double getVerticalDisplacement(int cid) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int index = (cid - this.startCID) * 3;
        if (this.metrics instanceof CosArray) {
            return ((CosArray)this.metrics).getDouble(index);
        }
        return ((double[])this.metrics)[0];
    }

    double[] getPositionVector(int cid) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        double[] vector = new double[2];
        if (this.metrics instanceof CosArray) {
            int base = (cid - this.startCID) * 3;
            vector[0] = ((CosArray)this.metrics).getDouble(base + 1);
            vector[1] = ((CosArray)this.metrics).getDouble(base + 2);
        } else {
            vector[0] = ((double[])this.metrics)[1];
            vector[1] = ((double[])this.metrics)[2];
        }
        return vector;
    }
}

