/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces;

import com.adobe.internal.io.ByteWriterFactory;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidContentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosStream;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class PDFICCProfile
extends PDFCosStream {
    private ColorSpace cSpace = null;

    private PDFICCProfile(CosObject cosStream) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        super(cosStream);
    }

    public static PDFICCProfile newInstance(PDFDocument doc, ICC_Profile ics) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        try {
            OutputByteStream output = null;
            output = doc.getStreamManager().getOutputByteStreamClearDocument(ByteWriterFactory.Fixed.FIXED, ics.getData().length);
            output.write(ics.getData());
            CosStream strm = doc.getCosDocument().createCosStream(output.closeAndConvert());
            strm.put(ASName.k_N, ics.getNumComponents());
            return new PDFICCProfile(strm);
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    public static PDFICCProfile getInstance(CosObject cosObject) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFICCProfile pdfObject = (PDFICCProfile)PDFCosObject.getCachedInstance(cosObject, PDFICCProfile.class);
        if (pdfObject == null) {
            pdfObject = new PDFICCProfile(cosObject);
        }
        return pdfObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColorSpace createColorSpace() throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        ByteArrayOutputStream profileOutStream = null;
        ByteArrayInputStream profileInputStream = null;
        ICC_ColorSpace cSpace = null;
        try {
            profileOutStream = new ByteArrayOutputStream(this.getLength() > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.getLength());
            this.getStreamData(profileOutStream);
            profileInputStream = new ByteArrayInputStream(profileOutStream.toByteArray());
            ICC_Profile iccProfile = ICC_Profile.getInstance(profileInputStream);
            cSpace = new ICC_ColorSpace(iccProfile);
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
        catch (IllegalArgumentException e) {
            throw new PDFInvalidContentException(e);
        }
        finally {
            try {
                try {
                    if (profileInputStream != null) {
                        profileInputStream.close();
                    }
                }
                finally {
                    if (profileOutStream != null) {
                        profileOutStream.close();
                    }
                }
            }
            catch (IOException e) {
                throw new PDFIOException(e);
            }
        }
        return cSpace;
    }

    public ColorSpace getColorSpace() throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        if (this.cSpace == null) {
            this.cSpace = this.createColorSpace();
        }
        return this.cSpace;
    }

    public int getNumberOfComponents() throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        return this.getDictionaryIntValue(ASName.k_N);
    }

    public void setNumberOfComponents(int noOfComponents) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_N, noOfComponents);
    }
}

