/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces;

import com.adobe.internal.pdftoolkit.color.ColorManager;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFRuntimeException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpace;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceCIEBased;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceFactory;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFICCProfile;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.util.Arrays;

public class PDFColorSpaceICCBased
extends PDFColorSpaceCIEBased {
    private PDFColorSpaceICCBased(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFColorSpaceICCBased getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFColorSpaceICCBased pdfObject = (PDFColorSpaceICCBased)PDFCosObject.getCachedInstance(cosObject, PDFColorSpaceICCBased.class);
        if (pdfObject == null) {
            pdfObject = new PDFColorSpaceICCBased(cosObject);
        }
        return pdfObject;
    }

    public static PDFColorSpaceICCBased newInstance(PDFDocument pdfDocument, ICC_Profile ics) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        PDFICCProfile iccProfile = PDFICCProfile.newInstance(pdfDocument, ics);
        return PDFColorSpaceICCBased.newInstance(pdfDocument, iccProfile);
    }

    public static PDFColorSpaceICCBased newInstance(PDFDocument pdfDocument, PDFICCProfile strm) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        CosArray cosObject = PDFCosObject.newCosArray(pdfDocument);
        PDFColorSpaceICCBased colorspace = new PDFColorSpaceICCBased(cosObject);
        cosObject.addName(ASName.k_ICCBased);
        cosObject.add(strm.getCosObject());
        return colorspace;
    }

    public PDFICCProfile getPDFICCProfile() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject obj = this.getCosArray().get(1);
        if (obj != null && obj instanceof CosStream) {
            return PDFICCProfile.getInstance(obj);
        }
        return null;
    }

    public void setPDFICCProfile(PDFICCProfile iccProfile) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getCosArray().set(1, iccProfile.getCosObject());
    }

    @Override
    public ColorModel createColorModel(int bpc, int transferType) {
        ColorSpace cspace = this.createColorSpace();
        int numColorComponents = cspace.getNumComponents();
        boolean hasAlpha = false;
        int numComponents = numColorComponents + (hasAlpha ? 1 : 0);
        int[] nbBits = new int[numComponents];
        for (int i = 0; i < numComponents; ++i) {
            nbBits[i] = bpc;
        }
        ComponentColorModel componentColorModel = new ComponentColorModel(this.createColorSpace(), nbBits, hasAlpha, false, 1, transferType);
        return componentColorModel;
    }

    @Override
    public ColorSpace createColorSpace() {
        try {
            return this.getPDFICCProfile().getColorSpace();
        }
        catch (PDFIOException e) {
            throw new PDFRuntimeException(e);
        }
        catch (PDFSecurityException e) {
            throw new PDFRuntimeException(e);
        }
        catch (PDFInvalidDocumentException e) {
            throw new PDFRuntimeException(e);
        }
    }

    @Override
    public ASName getName() {
        return ASName.k_ICCBased;
    }

    @Override
    public int getNumberOfComponents() {
        try {
            return this.getPDFICCProfile().getNumberOfComponents();
        }
        catch (PDFIOException e) {
            throw new PDFRuntimeException(e);
        }
        catch (PDFSecurityException e) {
            throw new PDFRuntimeException(e);
        }
        catch (PDFInvalidDocumentException e) {
            throw new PDFRuntimeException(e);
        }
    }

    public PDFColorSpace getAlternateColorSpace() throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        CosObject alternate = this.getDictionary().getDictionaryCosObjectValue(ASName.k_Alternate);
        return PDFColorSpaceFactory.getInstance(alternate);
    }

    @Override
    public double[] getRange() {
        try {
            CosArray range = this.getDictionary().getDictionaryArrayValue(ASName.k_Range);
            if (range == null) {
                double[] ranges = new double[2 * this.getNumberOfComponents()];
                for (int i = 0; i < this.getNumberOfComponents(); ++i) {
                    ranges[2 * i] = 0.0;
                    ranges[2 * i + 1] = 1.0;
                }
                return ranges;
            }
            return range.getArrayDouble();
        }
        catch (PDFInvalidDocumentException e) {
            throw new PDFRuntimeException(e);
        }
        catch (PDFIOException e) {
            throw new PDFRuntimeException(e);
        }
        catch (PDFSecurityException e) {
            throw new PDFRuntimeException(e);
        }
    }

    @Override
    public double[] toRGB(double[] inputColorValues) {
        inputColorValues = super.toRGB(inputColorValues);
        try {
            return ColorManager.convertICCToDeviceRGB(inputColorValues, this.createColorSpace());
        }
        catch (Exception e) {
            try {
                PDFColorSpace altCS = this.getAlternateColorSpace();
                if (altCS != null) {
                    return altCS.toRGB(inputColorValues);
                }
                throw new PDFRuntimeException("Problem with ICC profile of the color space with obj ID = " + this.getCosObject().getObjNum() + " .Also alternate color space entry is null.", e);
            }
            catch (PDFInvalidDocumentException e1) {
                throw new PDFRuntimeException(e1);
            }
            catch (PDFIOException e1) {
                throw new PDFRuntimeException(e1);
            }
            catch (PDFSecurityException e1) {
                throw new PDFRuntimeException(e1);
            }
        }
    }

    @Override
    public double[] getDefaultColor() throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        double[] defaultColor = new double[this.getNumberOfComponents()];
        Arrays.fill(defaultColor, 0.0);
        return defaultColor;
    }
}

