/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces;

import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpace;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;

public class PDFColorSpaceDeviceRGB
extends PDFColorSpace {
    static final double[] componentsRange = new double[]{0.0, 1.0, 0.0, 1.0, 0.0, 1.0};
    static final double[] defaultColor = new double[]{0.0, 0.0, 0.0};

    private PDFColorSpaceDeviceRGB(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFColorSpaceDeviceRGB newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException {
        CosName cosObject = PDFCosObject.newCosName(pdfDocument, ASName.k_DeviceRGB);
        return new PDFColorSpaceDeviceRGB(cosObject);
    }

    public static PDFColorSpaceDeviceRGB getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFColorSpaceDeviceRGB pdfObject = (PDFColorSpaceDeviceRGB)PDFCosObject.getCachedInstance(cosObject, PDFColorSpaceDeviceRGB.class);
        if (pdfObject == null) {
            pdfObject = new PDFColorSpaceDeviceRGB(cosObject);
        }
        return pdfObject;
    }

    @Override
    public ASName getName() {
        return ASName.k_DeviceRGB;
    }

    @Override
    public int getNumberOfComponents() {
        return 3;
    }

    @Override
    public ColorSpace createColorSpace() {
        return ColorSpace.getInstance(1000);
    }

    @Override
    public ColorModel createColorModel(int bpc, int transferType) {
        int[] nbBits = new int[]{bpc, bpc, bpc};
        ComponentColorModel componentColorModel = new ComponentColorModel(this.createColorSpace(), nbBits, false, false, 1, transferType);
        return componentColorModel;
    }

    @Override
    public double[] getRange() {
        return componentsRange;
    }

    @Override
    public double[] toRGB(double[] inputColorValues) {
        return super.toRGB(inputColorValues);
    }

    @Override
    public double[] getDefaultColor() {
        return defaultColor;
    }
}

