/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.document;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosBoolean;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosNull;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosObjectRefAdapter;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.cos.CosString;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFASNameInterface;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosNull;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObjectContainer;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class PDFCosObject
extends PDFObject
implements PDFCosObjectContainer {
    private static final boolean USE_WHITELIST = false;
    private CosObject cosObject;

    protected PDFCosObject(CosObject cosObject) throws PDFInvalidDocumentException {
        super((PDFDocument)cosObject.getDocument().getPdfDocument());
        this.cosObject = cosObject;
        this.registerWithCache(cosObject);
    }

    public CosObject getCosObject() {
        return this.cosObject;
    }

    @Override
    public PDFCosObject getPDFCosObject() {
        return this;
    }

    @Deprecated
    protected void replaceCosObject(CosObject cosObject) {
        this.removeFromCache(this.cosObject);
        this.cosObject = cosObject;
        this.registerWithCache(this.cosObject);
    }

    public int hashCode() {
        return this.cosObject.hashCode() + this.getClass().hashCode() * 31;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PDFCosObject)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.cosObject.equals(((PDFCosObject)obj).cosObject);
    }

    public CosArray getCosArray() {
        return (CosArray)this.cosObject;
    }

    public CosStream getCosStream() {
        return (CosStream)this.cosObject;
    }

    protected static CosArray makeCosArray(PDFDocument pdfDocument, List<?> value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray valueArray = PDFCosObject.newCosArray(pdfDocument);
        for (Object curValue : value) {
            if (curValue instanceof String) {
                valueArray.add(PDFCosObject.newCosString(pdfDocument, (String)curValue));
                continue;
            }
            if (curValue instanceof ASName) {
                valueArray.add(PDFCosObject.newCosName(pdfDocument, (ASName)curValue));
                continue;
            }
            if (curValue instanceof Integer) {
                valueArray.add(PDFCosObject.newCosNumeric(pdfDocument, (Integer)curValue));
                continue;
            }
            if (curValue instanceof Number) {
                valueArray.add(PDFCosObject.newCosNumeric(pdfDocument, (Number)curValue));
                continue;
            }
            if (curValue instanceof CosObject) {
                valueArray.add((CosObject)curValue);
                continue;
            }
            if (curValue instanceof ArrayList) {
                CosArray array = PDFCosObject.makeCosArray(pdfDocument, (ArrayList)curValue);
                valueArray.add(array);
                continue;
            }
            if (curValue instanceof PDFCosObject) {
                valueArray.add(((PDFCosObject)curValue).getCosObject());
                continue;
            }
            throw new RuntimeException("Invalid element type");
        }
        return valueArray;
    }

    protected static CosArray makeCosArray(PDFDocument pdfDocument, int[] value, int startPos, int endPos) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray valueArray = PDFCosObject.newCosArray(pdfDocument);
        for (int index = startPos; index <= endPos; ++index) {
            valueArray.add(PDFCosObject.newCosNumeric(pdfDocument, value[index]));
        }
        return valueArray;
    }

    protected static CosArray makeCosArray(PDFDocument pdfDocument, int offset, double[] value, int startPos, int endPos) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int index;
        CosArray valueArray = PDFCosObject.newCosArray(pdfDocument);
        for (index = 0; index < offset; ++index) {
            valueArray.add(PDFCosObject.newCosNull(pdfDocument));
        }
        index = startPos;
        while (index <= endPos) {
            valueArray.add(PDFCosObject.newCosNumeric(pdfDocument, value[index]));
            ++index;
            ++offset;
        }
        return valueArray;
    }

    public String toString() {
        return this.cosObject.toString();
    }

    protected static <T extends PDFCosObject> T getCachedInstance(CosObject cosObject, Class<? extends PDFCosObject> theClass) {
        PDFDocument pdfDoc = (PDFDocument)cosObject.getDocument().getPdfDocument();
        CosObjectRefAdapter cosObjectRefAdapter = CosObjectRefAdapter.newInstance(cosObject);
        Object userData = pdfDoc.getPDFObjectCache().get(cosObjectRefAdapter);
        if (userData == null) {
            return null;
        }
        if (userData instanceof PDFCosObjectMap) {
            return (T)((PDFCosObject)((PDFCosObjectMap)userData).get(theClass));
        }
        if (userData.getClass() != theClass) {
            return null;
        }
        return (T)((PDFCosObject)userData);
    }

    private void registerWithCache(CosObject cosObject) {
        CosObjectRefAdapter cosObjectRefAdapter;
        PDFDocument pdfDoc = (PDFDocument)cosObject.getDocument().getPdfDocument();
        Map<CosObjectRefAdapter, Object> objectCache = pdfDoc.getPDFObjectCache();
        Object userData = objectCache.get(cosObjectRefAdapter = CosObjectRefAdapter.newInstance(cosObject));
        if (userData == null) {
            objectCache.put(cosObjectRefAdapter, this);
        } else if (userData instanceof PDFCosObjectMap) {
            PDFCosObjectMap dict = (PDFCosObjectMap)userData;
            dict.put(this.getClass(), this);
        } else {
            PDFCosObjectMap dict = new PDFCosObjectMap();
            dict.put(userData.getClass(), (PDFCosObject)userData);
            objectCache.put(cosObjectRefAdapter, dict);
            dict.put(this.getClass(), this);
        }
    }

    protected void removeFromCache(CosObject cosObject) {
        CosObjectRefAdapter cosObjectRefAdapter;
        PDFDocument pdfDoc = (PDFDocument)cosObject.getDocument().getPdfDocument();
        Map<CosObjectRefAdapter, Object> objectCache = pdfDoc.getPDFObjectCache();
        Object userData = objectCache.get(cosObjectRefAdapter = CosObjectRefAdapter.newInstance(cosObject));
        if (userData != null) {
            if (userData instanceof PDFCosObjectMap) {
                PDFCosObjectMap dict = (PDFCosObjectMap)userData;
                if (dict.get(this.getClass()) == this) {
                    dict.remove(this.getClass());
                }
            } else if (userData == this) {
                objectCache.remove(cosObjectRefAdapter);
            }
        }
    }

    private static boolean checkWhiteList(Class<?> theClass) {
        return true;
    }

    protected static CosObject checkNullCosObject(CosObject cosObject) {
        if (cosObject == null) {
            return null;
        }
        if (cosObject.getType() == 0) {
            return null;
        }
        return cosObject;
    }

    protected static PDFCosNull newPDFCosNull(PDFDocument pdfDocument) throws PDFInvalidDocumentException {
        return PDFCosNull.newInstance(pdfDocument);
    }

    protected static CosNull newCosNull(PDFDocument pdfDocument) {
        return pdfDocument.getCosDocument().createCosNull();
    }

    protected static CosName newCosName(PDFDocument pdfDocument, ASName value) {
        return pdfDocument.getCosDocument().createCosName(value);
    }

    protected static CosName newCosName(PDFDocument pdfDocument, PDFASNameInterface value) {
        return pdfDocument.getCosDocument().createCosName(value.getName());
    }

    protected static CosBoolean newCosBoolean(PDFDocument pdfDocument, boolean value) {
        return pdfDocument.getCosDocument().createCosBoolean(value);
    }

    protected static CosNumeric newCosNumeric(PDFDocument pdfDocument, int value) {
        return pdfDocument.getCosDocument().createCosNumeric(value);
    }

    protected static CosNumeric newCosNumeric(PDFDocument pdfDocument, Number value) {
        return pdfDocument.getCosDocument().createCosNumeric(value);
    }

    protected static CosNumeric newCosNumeric(PDFDocument pdfDocument, byte[] value) throws PDFInvalidParameterException {
        try {
            return pdfDocument.getCosDocument().createCosNumeric(value);
        }
        catch (PDFCosParseException e) {
            throw new PDFInvalidParameterException("The supplied valued couldn't be parsed.", e);
        }
    }

    protected static CosString newCosString(PDFDocument pdfDocument, String value) {
        return pdfDocument.getCosDocument().createCosString(value);
    }

    protected static CosString newCosString(PDFDocument pdfDocument, ASString value) {
        return pdfDocument.getCosDocument().createCosString(value);
    }

    protected static CosString newCosString(PDFDocument pdfDocument, byte[] value) {
        return pdfDocument.getCosDocument().createCosString(value);
    }

    protected static CosArray newCosArray(PDFDocument pdfDocument, ArrayList<?> list) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return pdfDocument.getCosDocument().createCosArray(list);
    }

    protected static CosArray newCosArrayNull(PDFDocument pdfDocument, int size) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = PDFCosObject.newCosArray(pdfDocument);
        CosNull cosNull = PDFCosObject.newCosNull(pdfDocument);
        for (int i = 0; i < size; ++i) {
            cosArray.add(cosNull);
        }
        return cosArray;
    }

    protected static CosArray newCosArray(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return pdfDocument.getCosDocument().createCosArray();
    }

    protected static CosDictionary newCosDirectDictionary(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return pdfDocument.getCosDocument().createDirectCosDictionary();
    }

    protected static CosDictionary newCosDirectDictionary(PDFDocument pdfDocument, Map<?, ?> map) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return pdfDocument.getCosDocument().createDirectCosDictionary(map);
    }

    protected static CosDictionary newCosDictionary(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return pdfDocument.getCosDocument().createCosDictionary();
    }

    protected static CosDictionary newCosDictionary(PDFDocument pdfDocument, Map map) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return pdfDocument.getCosDocument().createCosDictionaryFromNonCosData(map);
    }

    protected static CosStream newCosStream(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return pdfDocument.getCosDocument().createCosStream();
    }

    protected static CosStream newCosStream(PDFDocument pdfDocument, InputByteStream stream) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosStream cosStream = PDFCosObject.newCosStream(pdfDocument);
        cosStream.newDataDecoded(stream);
        return cosStream;
    }

    protected static CosArray makeCosArray(PDFDocument pdfDocument, int offset, ASName[] value, int startPos, int endPos) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int index;
        CosArray valueArray = PDFCosObject.newCosArray(pdfDocument);
        for (index = 0; index < offset; ++index) {
            valueArray.add(PDFCosObject.newCosNull(pdfDocument));
        }
        index = startPos;
        while (index <= endPos) {
            valueArray.add(PDFCosObject.newCosName(pdfDocument, value[index]));
            ++index;
            ++offset;
        }
        return valueArray;
    }

    private static final class PDFCosObjectMap
    extends HashMap<Class<? extends Object>, PDFCosObject> {
        private static final long serialVersionUID = 1L;

        private PDFCosObjectMap() {
        }
    }
}

