/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.document;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFDocumentSecurityStore;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFLegalAttestation;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCatalogThreads;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCatalogURI;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosUtils;
import com.adobe.internal.pdftoolkit.pdf.document.PDFExtensions;
import com.adobe.internal.pdftoolkit.pdf.document.PDFFileSpecificationList;
import com.adobe.internal.pdftoolkit.pdf.document.PDFNameDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFOpenAction;
import com.adobe.internal.pdftoolkit.pdf.document.PDFPermissions;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCProperties;
import com.adobe.internal.pdftoolkit.pdf.interactive.PDFViewerPreferences;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAdditionalActionsDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFBookmarkRoot;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFPortableCollection;
import com.adobe.internal.pdftoolkit.pdf.interactive.readerrequirements.PDFReaderRequirementsArray;
import com.adobe.internal.pdftoolkit.pdf.interactive.requirement.PDFRequirementsArray;
import com.adobe.internal.pdftoolkit.pdf.interchange.documentparts.PDFDPartRoot;
import com.adobe.internal.pdftoolkit.pdf.interchange.metadata.PDFMetadata;
import com.adobe.internal.pdftoolkit.pdf.interchange.prepress.PDFOutputIntentsList;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFMarkInfo;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureRoot;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageLabels;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageLayout;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageMode;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPagePiece;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageTree;

public class PDFCatalog
extends PDFCosDictionary {
    public static final ASName k_DSS = ASName.create("DSS");
    public static final ASName k_Collection = ASName.create("Collection");
    public static final ASName k_Extensions = ASName.create("Extensions");
    public static final ASName k_OutputIntentList = ASName.create("OutputIntents");

    private PDFCatalog(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    static PDFCatalog requireInstance(CosObject cosObject) throws PDFInvalidParameterException, PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            throw new PDFInvalidParameterException("Required instance unable to be constructed.");
        }
        PDFCatalog pdfObject = (PDFCatalog)PDFCosObject.getCachedInstance(cosObject, PDFCatalog.class);
        if (pdfObject == null) {
            pdfObject = new PDFCatalog(cosObject);
        }
        return pdfObject;
    }

    public PDFInteractiveForm getInteractiveForm() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFInteractiveForm.getInstance(this.getDictionaryCosObjectValue(ASName.k_AcroForm));
    }

    public PDFInteractiveForm procureInteractiveForm() throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        PDFInteractiveForm iForm = this.getInteractiveForm();
        if (iForm == null) {
            iForm = PDFInteractiveForm.newInstance(this.getPDFDocument(), null);
            this.setInteractiveForm(iForm);
        }
        return iForm;
    }

    public void setInteractiveForm(PDFInteractiveForm pdfInteractiveForm) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_AcroForm, pdfInteractiveForm);
    }

    public PDFPageTree getPages() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFPageTree.getInstance(this.getDictionaryCosObjectValue(ASName.k_Pages));
    }

    public PDFPageTree requirePages() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            PDFPageTree pageTree = PDFPageTree.requireInstance(this.getDictionaryCosObjectValue(ASName.k_Pages));
            if (pageTree.isEmpty()) {
                throw new PDFInvalidParameterException("Required instance");
            }
            return pageTree;
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException("Could not get page tree, all pages might be deleted.", e);
        }
    }

    boolean hasMetadata() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Metadata);
    }

    @Override
    public PDFMetadata getMetadata() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFMetadata.getInstance(this.getDictionaryCosObjectValue(ASName.k_Metadata));
    }

    @Override
    public void setMetadata(PDFMetadata pdfMetadata) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Metadata, pdfMetadata);
    }

    public PDFPortableCollection getCollection() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFPortableCollection.getInstance(this.getDictionaryDictionaryValue(k_Collection));
    }

    public void setCollection(PDFPortableCollection collection) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(k_Collection, collection);
    }

    public PDFNameDictionary getNameDictionary() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFNameDictionary.getInstance(this.getDictionaryCosObjectValue(ASName.k_Names));
    }

    public void setNameDictionary(PDFNameDictionary pdfNameDictionary) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Names, pdfNameDictionary);
    }

    public PDFNameDictionary procureNameDictionary() throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        PDFNameDictionary obj = this.getNameDictionary();
        if (obj == null) {
            obj = PDFNameDictionary.newInstance(this.getPDFDocument());
            this.setNameDictionary(obj);
        }
        return obj;
    }

    public PDFPageLabels getPageLabels() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFPageLabels.getInstance(this.getDictionaryCosObjectValue(ASName.k_PageLabels));
    }

    public void setPageLabels(PDFPageLabels pdfPageLabels) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_PageLabels, pdfPageLabels);
    }

    public PDFPageLabels procurePageLabels() throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        PDFPageLabels obj = this.getPageLabels();
        if (obj == null) {
            obj = PDFPageLabels.newInstance(this.getPDFDocument());
            this.setPageLabels(obj);
        }
        return obj;
    }

    public PDFBookmarkRoot getBookmarkRoot() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFBookmarkRoot.getInstance(this.getDictionaryCosObjectValue(ASName.k_Outlines));
    }

    public void setBookmarkRoot(PDFBookmarkRoot bookmarkRoot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Outlines, bookmarkRoot);
    }

    public PDFPermissions getPermissions() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFPermissions.getInstance(this.getDictionaryCosObjectValue(ASName.k_Perms));
    }

    public void setPermissions(PDFPermissions permissions) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Perms, permissions);
    }

    public PDFLegalAttestation getLegalAttestation() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFLegalAttestation.getInstance(this.getDictionaryCosObjectValue(ASName.k_Legal));
    }

    public void setLegalAttestation(PDFLegalAttestation attestation) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Legal, attestation);
    }

    public void removeLegalAttestation() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setLegalAttestation(null);
    }

    public PDFAdditionalActionsDocument getAdditionalActions() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFAdditionalActionsDocument.getInstance(this.getDictionaryCosObjectValue(ASName.k_AA));
    }

    public PDFAdditionalActionsDocument procureAdditionalActions() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFAdditionalActionsDocument.getInstance(PDFCosUtils.getInheritableValue(ASName.k_AA, ASName.k_Parent, this)) != null) {
            return PDFAdditionalActionsDocument.getInstance(PDFCosUtils.getInheritableValue(ASName.k_AA, ASName.k_Parent, this));
        }
        PDFAdditionalActionsDocument field = PDFAdditionalActionsDocument.newInstance(this.getPDFDocument());
        this.setAdditionalActions(field);
        return field;
    }

    public void setAdditionalActions(PDFAdditionalActionsDocument additionalActions) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_AA, additionalActions);
    }

    public PDFViewerPreferences getViewerPreferences() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFViewerPreferences.getInstance(this.getDictionaryCosObjectValue(ASName.k_ViewerPreferences));
    }

    public void setViewerPreferences(PDFViewerPreferences pdfViewerPreferences) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_ViewerPreferences, pdfViewerPreferences);
    }

    public PDFViewerPreferences procureViewerPreferences() throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        PDFViewerPreferences vp = this.getViewerPreferences();
        if (vp == null) {
            vp = PDFViewerPreferences.newInstance(this.getPDFDocument());
            this.setViewerPreferences(vp);
        }
        return vp;
    }

    public void setPageLayout(PDFPageLayout pageLayout) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (pageLayout == null) {
            this.removeValue(ASName.k_PageLayout);
        } else {
            this.setDictionaryNameValue(ASName.k_PageLayout, pageLayout.getName());
        }
    }

    public PDFPageLayout getPageLayout() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.dictionaryContains(ASName.k_PageLayout)) {
            return PDFPageLayout.SinglePage;
        }
        return PDFPageLayout.getInstance(this.getDictionaryNameValue(ASName.k_PageLayout));
    }

    public void setPageMode(PDFPageMode pageMode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (pageMode == null) {
            this.removeValue(ASName.k_PageMode);
        } else {
            this.setDictionaryNameValue(ASName.k_PageMode, pageMode.getName());
        }
    }

    public PDFPageMode getPageMode() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.dictionaryContains(ASName.k_PageMode)) {
            return PDFPageMode.PagesOnly;
        }
        return PDFPageMode.getInstance(this.getDictionaryNameValue(ASName.k_PageMode));
    }

    public void setOpenAction(PDFOpenAction openAction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_OpenAction, openAction);
    }

    public PDFOpenAction getOpenAction() throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        return PDFOpenAction.getInstance(this.getCosDictionary().get(ASName.k_OpenAction));
    }

    public void setLang(String lang) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_Lang, lang);
    }

    public String getLang() throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        return this.getDictionaryTextStringValue(ASName.k_Lang);
    }

    public void setOutputIntents(PDFOutputIntentsList outputIntents) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (outputIntents == null) {
            this.removeValue(k_OutputIntentList);
        } else {
            this.setDictionaryArrayValue(k_OutputIntentList, outputIntents.getCosArray());
        }
    }

    public PDFOutputIntentsList getOutputIntents() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = this.getDictionaryArrayValue(k_OutputIntentList);
        if (cosArray == null) {
            return null;
        }
        return PDFOutputIntentsList.getInstance(cosArray);
    }

    public PDFPagePiece getPieceInfo() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFPagePiece.getInstance(this.getDictionaryCosObjectValue(ASName.k_PieceInfo));
    }

    public PDFPagePiece procurePieceInfo() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPagePiece pieceInfo = this.getPieceInfo();
        if (pieceInfo == null) {
            pieceInfo = PDFPagePiece.newInstance(this.getPDFDocument());
            this.setPieceInfo(pieceInfo);
        }
        return pieceInfo;
    }

    public void setPieceInfo(PDFPagePiece pieceInfo) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_PieceInfo, pieceInfo);
    }

    public boolean getNeedsRendering() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosDictionary().containsKey(ASName.k_NeedsRendering)) {
            return this.getDictionaryBooleanValue(ASName.k_NeedsRendering);
        }
        return false;
    }

    public void setNeedsRendering(boolean value) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_NeedsRendering, value);
    }

    public boolean hasNeedsRendering() {
        return this.getCosDictionary().containsKey(ASName.k_NeedsRendering);
    }

    PDFExtensions getExtensions() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFExtensions.getInstance(this.getDictionaryCosObjectValue(k_Extensions));
    }

    void setExtensions(PDFExtensions extensions) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        this.setDictionaryValue(k_Extensions, extensions);
    }

    boolean hasExtensions() {
        return this.getCosDictionary().containsKey(k_Extensions);
    }

    public PDFCatalogThreads getThreads() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFCatalogThreads.getInstance(this.getDictionaryCosObjectValue(ASName.k_Threads));
    }

    public void setThreads(PDFCatalogThreads children) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (children == null) {
            this.removeValue(ASName.k_Threads);
        } else {
            this.setDictionaryArrayValue(ASName.k_Threads, children.getCosArray());
        }
    }

    public boolean hasThreads() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Threads);
    }

    public PDFCatalogURI getURI() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFCatalogURI.getInstance(this.getDictionaryCosObjectValue(ASName.k_URI));
    }

    public void setURI(PDFCatalogURI value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_URI, value);
    }

    public boolean hasURI() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_URI);
    }

    public PDFMarkInfo getMarkInfo() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFMarkInfo.getInstance(this.getDictionaryCosObjectValue(ASName.k_MarkInfo));
    }

    public void setMarkInfo(PDFMarkInfo value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_MarkInfo, value);
    }

    public boolean hasMarkInfo() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_MarkInfo);
    }

    public PDFOCProperties getOCProperties() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFOCProperties.getInstance(this.getDictionaryDictionaryValue(ASName.k_OCProperties));
    }

    public PDFDocumentSecurityStore getDSSDictionary() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFDocumentSecurityStore.getInstance(this.getDictionaryDictionaryValue(k_DSS));
    }

    public void setDSSDictionary(PDFDocumentSecurityStore dss) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(k_DSS, dss);
    }

    public PDFStructureRoot getStructureRoot() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFStructureRoot.getInstance(this.getDictionaryDictionaryValue(ASName.k_StructTreeRoot));
    }

    public void setStructureRoot(PDFStructureRoot structRoot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_StructTreeRoot, structRoot);
    }

    public boolean hasStructureRoot() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_StructTreeRoot);
    }

    public void setOCProperties(PDFOCProperties props) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_OCProperties, props);
    }

    public PDFRequirementsArray getRequirements() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFRequirementsArray.getInstance(this.getDictionaryArrayValue(ASName.k_Requirements));
    }

    public void setRequirements(PDFRequirementsArray requirements) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Requirements, requirements);
    }

    public PDFReaderRequirementsArray getReaderRequirements() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFReaderRequirementsArray.getInstance(this.getDictionaryArrayValue(ASName.k_ReaderRequirements));
    }

    public void setReaderRequirements(PDFReaderRequirementsArray readerRequirements) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_ReaderRequirements, readerRequirements);
    }

    public PDFDPartRoot getDPartRoot() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFDPartRoot.getInstance(this.getDictionaryCosObjectValue(ASName.k_DPartRoot));
    }

    public void setDPartRoot(PDFDPartRoot pdfdPartRoot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_DPartRoot, pdfdPartRoot);
    }

    public PDFFileSpecificationList getAssociatedFiles() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFFileSpecificationList.getInstance(this.getDictionaryCosObjectValue(ASName.k_AF));
    }

    public void setAssociatedFiles(PDFFileSpecificationList fileSpecificationList) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_AF, fileSpecificationList);
    }
}

