/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.digsig;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFDocMDPPermissions;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFFieldAction;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldNode;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldUtils;

public class PDFFieldLock
extends PDFCosDictionary {
    public static final ASName k_SigFieldLock = ASName.create("SigFieldLock");

    protected PDFFieldLock(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFFieldLock getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFFieldLock pdfObject = (PDFFieldLock)PDFCosObject.getCachedInstance(cosObject, PDFFieldLock.class);
        if (pdfObject == null) {
            pdfObject = new PDFFieldLock(cosObject);
        }
        return pdfObject;
    }

    public static PDFFieldLock newInstance(PDFDocument pdfDocument, PDFFieldAction action, PDFFieldNode[] fields) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        return PDFFieldLock.newInstance(pdfDocument, action, fields, null);
    }

    public static PDFFieldLock newInstance(PDFDocument pdfDocument, PDFFieldAction action, PDFFieldNode[] fields, PDFDocMDPPermissions perms) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFFieldLock pdfObject = new PDFFieldLock(cosObject);
        pdfObject.setDictionaryNameValue(ASName.k_Type, k_SigFieldLock);
        if (action == null) {
            throw new PDFInvalidParameterException("action is a required entry so can't be null");
        }
        pdfObject.setDictionaryNameValue(ASName.k_Action, action.getValue());
        if (action != PDFFieldAction.All) {
            pdfObject.setFields(fields);
        }
        pdfObject.setLockPermissions(perms);
        return pdfObject;
    }

    public PDFFieldAction getPDFFieldAction() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFFieldAction.getInstance(this.getDictionaryNameValue(ASName.k_Action));
    }

    public void setPDFFieldAction(PDFFieldAction action) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (action == null) {
            throw new PDFInvalidDocumentException("Invalid parameter:action can not be null.");
        }
        this.setDictionaryNameValue(ASName.k_Action, action.getValue());
        if (action == PDFFieldAction.All) {
            this.getCosDictionary().remove(ASName.k_Fields);
        }
    }

    public String[] getPDFFieldNames() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = this.getDictionaryArrayValue(ASName.k_Fields);
        if (cosArray == null) {
            return null;
        }
        String[] names = new String[cosArray.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = cosArray.getString(i).asString();
        }
        return names;
    }

    public void setPDFFieldNames(String[] fieldNames) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (this.getPDFFieldAction() != PDFFieldAction.All && (fieldNames == null || fieldNames.length == 0)) {
            throw new PDFInvalidParameterException("The Fields entry should not be empty when the the Field action is Include or Exclude.");
        }
        this.getCosDictionary().remove(ASName.k_Fields);
        if (fieldNames != null && fieldNames.length != 0) {
            CosArray cosArray = PDFCosObject.newCosArray(this.getPDFDocument());
            for (int i = 0; i < fieldNames.length; ++i) {
                if (fieldNames[i] == null) continue;
                cosArray.addText(fieldNames[i]);
            }
            if (cosArray.size() > 0) {
                this.setDictionaryArrayValue(ASName.k_Fields, cosArray);
            }
            if (cosArray.size() == 0) {
                throw new PDFInvalidParameterException("The Fields entry should not be empty when the the Field action is Include or Exclude.");
            }
        }
    }

    public PDFFieldNode[] getFields() throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        if (this.getPDFFieldAction() == PDFFieldAction.All || !this.getCosDictionary().containsKey(ASName.k_Fields)) {
            return null;
        }
        return PDFFieldUtils.searchFields(this.getPDFFieldNames(), this.getPDFDocument());
    }

    public void setFields(PDFFieldNode[] fieldNodes) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (this.getPDFFieldAction() == PDFFieldAction.All) {
            throw new PDFInvalidParameterException("The field lock action must be Include or Exclude prior to setting the fields to be included or excluded.");
        }
        if (fieldNodes == null || fieldNodes.length == 0) {
            throw new PDFInvalidParameterException("The fieldNodes parameter cannot be null or an empty array.");
        }
        boolean fieldNodesIsEmpty = true;
        for (int i = 0; i < fieldNodes.length && fieldNodesIsEmpty; ++i) {
            if (fieldNodes[i] == null) continue;
            fieldNodesIsEmpty = false;
        }
        if (fieldNodesIsEmpty) {
            throw new PDFInvalidParameterException("The fieldNodes array must contain at least one PDFFieldNode value.");
        }
        String[] fieldNames = new String[fieldNodes.length];
        for (int i = 0; i < fieldNodes.length; ++i) {
            fieldNames[i] = fieldNodes[i] != null ? fieldNodes[i].getQualifiedName() : null;
        }
        this.setPDFFieldNames(fieldNames);
    }

    public PDFDocMDPPermissions getLockPermissions() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosDictionary().containsKey(ASName.k_P)) {
            int cosPerm = this.getDictionaryIntValue(ASName.k_P);
            return PDFDocMDPPermissions.getInstance(cosPerm);
        }
        return null;
    }

    public void setLockPermissions(PDFDocMDPPermissions perms) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (perms == null) {
            this.removeValue(ASName.k_P);
        } else {
            this.setDictionaryIntValue(ASName.k_P, perms.getValue());
        }
    }
}

