/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.contentmodify;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosCloneMgr;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidContentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.types.ASDictionary;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASNumber;
import com.adobe.internal.pdftoolkit.core.types.ASObject;
import com.adobe.internal.pdftoolkit.pdf.content.ContentReader;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.pdf.content.InstructionFactory;
import com.adobe.internal.pdftoolkit.pdf.content.MarkedContentOperands;
import com.adobe.internal.pdftoolkit.pdf.content.OperandStack;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ContentWriter;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ModifiableContent;
import com.adobe.internal.pdftoolkit.pdf.document.PDFContents;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterFlate;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterList;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFExtGState;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.patterns.PDFPattern;
import com.adobe.internal.pdftoolkit.pdf.graphics.patterns.PDFPatternFactory;
import com.adobe.internal.pdftoolkit.pdf.graphics.patterns.PDFPatternMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFBorderStyle;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureArtifact;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ContentModifier {
    private ContentModifier() {
    }

    public static void modifyCurrentTransformationMatrix(ContentWriter contentWriter, PDFResources resources, ASMatrix matrix) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Instruction cm = InstructionFactory.newConcatMatrix(matrix.geta(), matrix.getb(), matrix.getc(), matrix.getd(), matrix.getx(), matrix.gety());
        contentWriter.prepend(cm);
        Instruction q = InstructionFactory.newGSave();
        contentWriter.prepend(q);
        Instruction Q = InstructionFactory.newGRestore();
        contentWriter.write(Q);
        if (resources != null) {
            ContentModifier.transformPatterns(resources, matrix);
        }
    }

    private static void transformPatterns(PDFResources resources, ASMatrix matrix) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Set<ASName> patterns;
        PDFPatternMap patternMap = resources.getPatternMap();
        if (patternMap != null && (patterns = patternMap.keySet()) != null) {
            Iterator<ASName> patternIterator = patterns.iterator();
            PDFDocument pdfDocument = resources.getPDFDocument();
            PDFPatternMap newPatternMap = PDFPatternMap.newInstance(pdfDocument);
            while (patternIterator.hasNext()) {
                ASName patternName = patternIterator.next();
                PDFPattern pdfPattern = patternMap.get(patternName);
                CosCloneMgr cosCloneMgr = new CosCloneMgr(pdfDocument.getCosDocument());
                PDFPattern clonePattern = PDFPatternFactory.getInstance(cosCloneMgr.clone(pdfPattern.getPDFCosObject().getCosObject()));
                CosObject cosPatternMatrix = clonePattern.getPDFCosObject().getDictionaryCosObjectValue(ASName.k_Matrix);
                ASMatrix asPatternMatrix = cosPatternMatrix instanceof CosArray ? new ASMatrix(((CosArray)cosPatternMatrix).getArrayDouble()) : ASMatrix.createIdentityMatrix();
                ASMatrix transformedMatrix = asPatternMatrix.concat(matrix);
                CosArray cosArray = clonePattern.getPDFCosObject().getPDFDocument().getCosDocument().createCosArray();
                for (int i = 0; i < 6; ++i) {
                    cosArray.addDouble(i, transformedMatrix.getValues()[i]);
                }
                clonePattern.getPDFCosObject().setDictionaryValue(ASName.k_Matrix, cosArray);
                newPatternMap.set(patternName, clonePattern);
            }
            resources.setPatternMap(newPatternMap);
        }
    }

    public static void addXObject(ContentWriter contentWriter, PDFExtGState pdfExtGState, ASMatrix transformMatrix, PDFXObject pdfXObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ContentModifier.addXObject(contentWriter, pdfExtGState, transformMatrix, pdfXObject, null);
    }

    public static void addXObject(ContentWriter contentWriter, PDFExtGState pdfExtGState, ASMatrix transformMatrix, PDFXObject pdfXObject, MarkedContentOperands markedOperands) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (markedOperands != null) {
            contentWriter.write(markedOperands.startMarkedContent());
        }
        contentWriter.write(InstructionFactory.newGSave());
        if (transformMatrix != null) {
            contentWriter.write(InstructionFactory.newConcatMatrix(transformMatrix.geta(), transformMatrix.getb(), transformMatrix.getc(), transformMatrix.getd(), transformMatrix.getx(), transformMatrix.gety()));
        }
        if (pdfExtGState != null) {
            contentWriter.write(pdfExtGState);
        }
        contentWriter.write(pdfXObject);
        contentWriter.write(InstructionFactory.newGRestore());
        if (markedOperands != null) {
            contentWriter.write(InstructionFactory.newEndMarkedContent());
        }
    }

    public static void prependXObject(ContentWriter contentWriter, PDFExtGState pdfExtGState, ASMatrix transformMatrix, PDFXObject pdfXObject, MarkedContentOperands markedOperands) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (markedOperands != null) {
            contentWriter.prepend(InstructionFactory.newEndMarkedContent());
        }
        contentWriter.prepend(InstructionFactory.newGRestore());
        contentWriter.prepend(pdfXObject);
        if (pdfExtGState != null) {
            contentWriter.prepend(pdfExtGState);
        }
        if (transformMatrix != null) {
            contentWriter.prepend(InstructionFactory.newConcatMatrix(transformMatrix.geta(), transformMatrix.getb(), transformMatrix.getc(), transformMatrix.getd(), transformMatrix.getx(), transformMatrix.gety()));
        }
        contentWriter.prepend(InstructionFactory.newGSave());
        if (markedOperands != null) {
            contentWriter.prepend(markedOperands.startMarkedContent());
        }
    }

    public static void appendContent(ContentWriter contentWriter, PDFContents content) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (content != null) {
            Instruction q = InstructionFactory.newGSave();
            contentWriter.write(q);
            contentWriter.write(content.getContents());
            Instruction Q = InstructionFactory.newGRestore();
            contentWriter.write(Q);
        }
    }

    public static void addFillRectangle(ContentWriter contentWriter, PDFRectangle rectangle, double[] color) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        switch (color.length) {
            case 1: {
                Instruction g = InstructionFactory.newDeviceGrayFill(color[0]);
                contentWriter.write(g);
                break;
            }
            case 3: {
                Instruction rg = InstructionFactory.newDeviceRGBFill(color[0], color[1], color[2]);
                contentWriter.write(rg);
                break;
            }
            case 4: {
                Instruction k = InstructionFactory.newDeviceCMYKFill(color[0], color[1], color[2], color[3]);
                contentWriter.write(k);
                break;
            }
            default: {
                throw new PDFInvalidDocumentException("Illegal fill color.");
            }
        }
        Instruction re = InstructionFactory.newRectangle(0.0, 0.0, rectangle.width(), rectangle.height());
        contentWriter.write(re);
        Instruction f = InstructionFactory.newFillPath();
        contentWriter.write(f);
    }

    public static void addStrokeRectangle(ContentWriter contentWriter, PDFRectangle rectangle, double lineWidth, double[] color, PDFBorderStyle.Style style, double[] dash, double width) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        switch (color.length) {
            case 1: {
                Instruction G = InstructionFactory.newDeviceGrayStroke(color[0]);
                contentWriter.write(G);
                break;
            }
            case 3: {
                Instruction RG = InstructionFactory.newDeviceRGBStroke(color[0], color[1], color[2]);
                contentWriter.write(RG);
                break;
            }
            case 4: {
                Instruction K = InstructionFactory.newDeviceCMYKStroke(color[0], color[1], color[2], color[3]);
                contentWriter.write(K);
                break;
            }
            default: {
                throw new PDFInvalidDocumentException("Illegal stroke color.");
            }
        }
        if (width > 1.0) {
            ContentModifier.addBorderStyleWidth(contentWriter, width);
        }
        if (style != null && style == PDFBorderStyle.Style.Dashed && dash.length > 0) {
            ContentModifier.addBorderStyleDash(contentWriter, dash);
        }
        if (width > -1.0) {
            lineWidth = width;
        }
        if (style != null && style == PDFBorderStyle.Style.Underline) {
            double left;
            double right = rectangle.right();
            double x = left = rectangle.left();
            double y = lineWidth / 2.0;
            Instruction m = InstructionFactory.newMoveTo(x, y);
            contentWriter.write(m);
            x = right;
            Instruction l = InstructionFactory.newLineTo(x, y);
            contentWriter.write(l);
        }
        if (style != PDFBorderStyle.Style.Underline) {
            Instruction re = InstructionFactory.newRectangle(lineWidth * 0.5, lineWidth * 0.5, rectangle.width() - lineWidth, rectangle.height() - lineWidth);
            contentWriter.write(re);
        }
        Instruction s = InstructionFactory.newCloseAndStrokePath();
        contentWriter.write(s);
    }

    public static void addStrokeRectangleNoColor(ContentWriter contentWriter, PDFRectangle rectangle, double lineWidth) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Instruction re = InstructionFactory.newRectangle(lineWidth, lineWidth, rectangle.width() - lineWidth * 2.0, rectangle.height() - lineWidth * 2.0);
        contentWriter.write(re);
    }

    public static void addBorderStyleDash(ContentWriter contentWriter, double[] dash) throws PDFIOException {
        Instruction d = InstructionFactory.newLineDashPattern(dash, 0);
        contentWriter.write(d);
    }

    public static void addBorderStyleWidth(ContentWriter contentWriter, double width) throws PDFIOException {
        Instruction w = InstructionFactory.newLineWidth(width);
        contentWriter.write(w);
    }

    public static boolean hasArtifactAsMarkedContent(PDFPage pdfPage, ASName type, ASName subtype) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (type == null) {
            throw new PDFInvalidParameterException("tag and type are required.");
        }
        if (type != PDFStructureArtifact.k_Background && type != PDFStructureArtifact.k_Pagination) {
            throw new PDFInvalidParameterException("type Background or Pagination is expected.");
        }
        if (type == PDFStructureArtifact.k_Pagination && (subtype == null || subtype != PDFStructureArtifact.k_Header && subtype != PDFStructureArtifact.k_Footer && subtype != PDFStructureArtifact.k_Watermark && subtype != PDFStructureArtifact.k_BatesN)) {
            throw new PDFInvalidParameterException("subtype is required for Pagination artifacts.");
        }
        ASName tag = PDFStructureArtifact.k_Artifact;
        return ContentModifier.hasMarkedContent(pdfPage, tag, type, subtype);
    }

    public static boolean hasMarkedContent(PDFPage pdfPage, ASName tag) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return ContentModifier.hasMarkedContent(pdfPage, tag, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasMarkedContent(PDFPage pdfPage, ASName tag, ASName type, ASName subtype) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        HashSet<ASName> markedContentInstructions = new HashSet<ASName>();
        markedContentInstructions.add(ASName.k_BDC);
        markedContentInstructions.add(ASName.k_BMC);
        ModifiableContent content = ModifiableContent.newInstance(pdfPage);
        ContentReader reader = null;
        Instruction instruction = null;
        try {
            reader = ContentReader.newInstance(content);
            while (reader.hasNext()) {
                ASName groupName;
                instruction = reader.next(markedContentInstructions);
                if (instruction == null) continue;
                ASName operator = instruction.getOperator();
                OperandStack operands = instruction.getOperands();
                if (operator == ASName.k_BDC) {
                    ASObject property;
                    if (operands.peekTypeIsName()) {
                        property = operands.popName();
                        groupName = operands.peekName();
                        operands.pushName((ASName)property);
                    } else {
                        property = operands.popDictionary();
                        groupName = operands.peekName();
                        operands.pushDictionary((ASDictionary)property);
                    }
                } else {
                    groupName = operands.peekName();
                }
                if (!groupName.equals(tag)) continue;
                if (tag == PDFStructureArtifact.k_Artifact && type != null) {
                    ASDictionary dict;
                    block40: {
                        if (!operands.peekTypeIsDictionary()) continue;
                        dict = operands.peekDictionary();
                        try {
                            if (!dict.containsKey(ASName.k_Type) || dict.getName(ASName.k_Type) != type) continue;
                            if (subtype != null) break block40;
                            boolean bl = true;
                            return bl;
                        }
                        catch (PDFUnableToCompleteOperationException e) {
                            throw new PDFInvalidContentException("Invalid MC dict", e);
                        }
                    }
                    if (!dict.containsKey(ASName.k_Subtype) || dict.getName(ASName.k_Subtype) != subtype) continue;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = true;
                return bl;
                finally {
                    try {
                        if (instruction == null) continue;
                        instruction.close();
                    }
                    catch (PDFIOException e) {}
                }
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                throw new PDFIOException(e);
            }
        }
        return false;
    }

    public static boolean removeArtifactAsMarkedContent(PDFPage pdfPage, ASName type, ASName subtype) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (type == null) {
            throw new PDFInvalidParameterException("type is required.");
        }
        if (type != PDFStructureArtifact.k_Background && type != PDFStructureArtifact.k_Pagination) {
            throw new PDFInvalidParameterException("type Background or Pagination is expected.");
        }
        if (type == PDFStructureArtifact.k_Pagination && (subtype == null || subtype != PDFStructureArtifact.k_Header && subtype != PDFStructureArtifact.k_Footer && subtype != PDFStructureArtifact.k_Watermark && subtype != PDFStructureArtifact.k_BatesN)) {
            throw new PDFInvalidParameterException("subtype is required for Pagination artifacts.");
        }
        ASName tag = PDFStructureArtifact.k_Artifact;
        return ContentModifier.removeMarkedContent(pdfPage, tag, type, subtype);
    }

    public static boolean removeMarkedContent(PDFPage pdfPage, ASName tag) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return ContentModifier.removeMarkedContent(pdfPage, tag, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static boolean removeMarkedContent(PDFPage pdfPage, ASName tag, ASName type, ASName subtype) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        watermarkFound = false;
        withinMC = false;
        mcNestingLevel = 0;
        resourcedInstructions = new HashMap<ASName, ASName>();
        resourcedInstructions.put(ASName.k_gs, ASName.k_ExtGState);
        resourcedInstructions.put(ASName.k_CS, ASName.k_ColorSpace);
        resourcedInstructions.put(ASName.k_cs, ASName.k_ColorSpace);
        resourcedInstructions.put(ASName.k_Tf, ASName.k_Font);
        resourcedInstructions.put(ASName.k_Do, ASName.k_XObject);
        resourcedInstructions.put(ASName.k_DP, ASName.k_Properties);
        resourcedInstructions.put(ASName.k_BDC, ASName.k_Properties);
        resourcedInstructions.put(ASName.k_SCN, ASName.k_Pattern);
        resourcedInstructions.put(ASName.k_scn, ASName.k_Pattern);
        resourcedInstructions.put(ASName.k_sh, ASName.k_Shading);
        deletedResourceNames = new HashMap<ASName, V>();
        usedResourceNames = new HashMap<ASName, V>();
        content = ModifiableContent.newInstance(pdfPage);
        pdfDocument = pdfPage.getPDFDocument();
        reader = null;
        writer = ContentWriter.newInstance(pdfDocument);
        instruction = null;
        try {
            reader = ContentReader.newInstance(content);
            while (reader.hasNext()) {
                try {
                    instruction = reader.next();
                    operator = instruction.getOperator();
                    if (operator == ASName.k_BMC || operator == ASName.k_BDC) {
                        if (withinMC) {
                            ++mcNestingLevel;
                        } else {
                            operands = instruction.getOperands();
                            if (operator == ASName.k_BDC) {
                                if (operands.peekTypeIsName()) {
                                    property /* !! */  = operands.popName();
                                    groupName = operands.peekName();
                                    operands.pushName(property /* !! */ );
                                } else {
                                    property /* !! */  = operands.popDictionary();
                                    groupName = operands.peekName();
                                    operands.pushDictionary((ASDictionary)property /* !! */ );
                                }
                            } else {
                                groupName = operands.peekName();
                            }
                            if (groupName.equals(tag)) {
                                if (type != null && tag == PDFStructureArtifact.k_Artifact) {
                                    if (operands.peekTypeIsDictionary()) {
                                        dict = operands.peekDictionary();
                                        try {
                                            if (!dict.containsKey(ASName.k_Type) || dict.getName(ASName.k_Type) != type || subtype != null && (!dict.containsKey(ASName.k_Subtype) || dict.getName(ASName.k_Subtype) != subtype)) ** GOTO lbl73
                                            watermarkFound = true;
                                            withinMC = true;
                                            ++mcNestingLevel;
                                        }
                                        catch (PDFUnableToCompleteOperationException e) {
                                            throw new PDFInvalidContentException("Invalid MC dict", e);
                                        }
                                    }
                                } else {
                                    watermarkFound = true;
                                    withinMC = true;
                                    ++mcNestingLevel;
                                }
                            }
                        }
                    } else if (operator == ASName.k_EMC && withinMC) {
                        --mcNestingLevel;
                    }
lbl73:
                    // 8 sources

                    resourceName = null;
                    if (resourcedInstructions.containsKey(operator)) {
                        operands = instruction.getOperands();
                        if (operator == ASName.k_Tf) {
                            fontSize = operands.popNumber();
                            resourceName = operands.peekName();
                            operands.pushASNumber(fontSize);
                        } else if (operands.peekTypeIsName()) {
                            resourceName = operands.peekName();
                        }
                    }
                    if (resourceName != null) {
                        if (withinMC) {
                            if (!usedResourceNames.containsKey(resourceName)) {
                                deletedResourceNames.put(resourceName, resourcedInstructions.get(operator));
                            }
                        } else {
                            usedResourceNames.put(resourceName, resourcedInstructions.get(operator));
                            deletedResourceNames.remove(resourceName);
                        }
                    }
                    if (!withinMC) {
                        writer.write(instruction);
                        continue;
                    }
                    if (mcNestingLevel != 0 || operator != ASName.k_EMC) continue;
                    withinMC = false;
                }
                finally {
                    try {
                        if (instruction == null) continue;
                        instruction.close();
                    }
                    catch (PDFIOException e) {}
                }
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                throw new PDFIOException(e);
            }
        }
        if (watermarkFound) {
            deletedNamesIterator = deletedResourceNames.entrySet().iterator();
            pageResources = pdfPage.getResources();
            while (deletedNamesIterator.hasNext()) {
                entry = deletedNamesIterator.next();
                pageResources.getDictionaryDictionaryValue((ASName)entry.getValue()).remove((ASName)entry.getKey());
            }
            modifiedResourceTypes = deletedResourceNames.values();
            for (ASName resourceType : modifiedResourceTypes) {
                if (pageResources.getDictionaryDictionaryValue(resourceType).size() != 0) continue;
                pageResources.removeValue(resourceType);
            }
            newContent = writer.close();
            filter = PDFFilterFlate.newInstance(pdfPage.getPDFDocument(), null);
            filterList = PDFFilterList.newInstance(pdfPage.getPDFDocument());
            filterList.add(filter);
            try {
                newContent.getContents().setOutputFiltersList(filterList.getCosArray());
            }
            catch (IOException e) {
                throw new PDFIOException(e);
            }
            pdfPage.setContents(newContent.getContents());
        }
        return watermarkFound;
    }

    public static void addCombDividers(ContentWriter contentWriter, PDFRectangle rectangle, int numOfDividers, double lineWidth) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (numOfDividers == 0 || lineWidth == 0.0) {
            return;
        }
        double recWidth = rectangle.width();
        double recHeight = rectangle.height();
        for (int idxDivider = 1; idxDivider < numOfDividers; ++idxDivider) {
            double x = rectangle.left() + recWidth * (double)idxDivider / (double)numOfDividers;
            double y = rectangle.bottom() + (recHeight - lineWidth);
            Instruction instrMove = InstructionFactory.newMoveTo(x, y);
            contentWriter.write(instrMove);
            y = rectangle.bottom() + lineWidth / 2.0;
            Instruction instrLineTo = InstructionFactory.newLineTo(x, y);
            contentWriter.write(instrLineTo);
        }
        Instruction s = InstructionFactory.newCloseAndStrokePath();
        contentWriter.write(s);
    }

    public static void addFillBeveledOrInset(ContentWriter contentWriter, PDFBorderStyle.Style style, double left, double bottom, double right, double top, double width, double[] bgColor) throws PDFIOException {
        Instruction f;
        Instruction l;
        Instruction m;
        double y;
        double x;
        Instruction g;
        double FILLCOLOR_BELEVED_HIGHLIGHT = 1.0;
        double FILLCOLOR_BELEVED_LOWLIGHT_OFFSET_RED = ContentModifier.fromHex("004040");
        double FILLCOLOR_BELEVED_LOWLIGHT_OFFSET_GREEN = ContentModifier.fromHex("004040");
        double FILLCOLOR_BELEVED_LOWLIGHT_OFFSET_BLUE = ContentModifier.fromHex("004040");
        double FILLCOLOR_BELEVED_LOWLIGHT_GREYSCALE = ContentModifier.fromHex("00C0C0");
        double FILLCOLOR_INSET_HIGHLIGHT = ContentModifier.fromHex("008080");
        double FILLCOLOR_INSET_LOWLIGHT = ContentModifier.fromHex("00C0C0");
        if (style == PDFBorderStyle.Style.Beveled) {
            g = InstructionFactory.newDeviceGrayFill(1.0);
            contentWriter.write(g);
            x = left + width;
            y = bottom + width;
            m = InstructionFactory.newMoveTo(x, y);
            contentWriter.write(m);
            y = top - width;
            l = InstructionFactory.newLineTo(x, y);
            contentWriter.write(l);
            x = right - width;
            l = InstructionFactory.newLineTo(x, y);
            contentWriter.write(l);
            l = InstructionFactory.newLineTo(x -= width, y -= width);
            contentWriter.write(l);
            x = left + 2.0 * width;
            l = InstructionFactory.newLineTo(x, y);
            contentWriter.write(l);
            y = bottom + 2.0 * width;
            l = InstructionFactory.newLineTo(x, y);
            contentWriter.write(l);
            f = InstructionFactory.newFillPath();
            contentWriter.write(f);
            double[] color_Lowlight = new double[]{1.0, 1.0, 1.0};
            if (bgColor != null && bgColor.length > 2) {
                if (color_Lowlight[0] > bgColor[0] - FILLCOLOR_BELEVED_LOWLIGHT_OFFSET_RED) {
                    color_Lowlight[0] = bgColor[0] - FILLCOLOR_BELEVED_LOWLIGHT_OFFSET_RED;
                }
                if (color_Lowlight[1] > bgColor[1] - FILLCOLOR_BELEVED_LOWLIGHT_OFFSET_GREEN) {
                    color_Lowlight[1] = bgColor[1] - FILLCOLOR_BELEVED_LOWLIGHT_OFFSET_GREEN;
                }
                if (color_Lowlight[2] > bgColor[2] - FILLCOLOR_BELEVED_LOWLIGHT_OFFSET_BLUE) {
                    color_Lowlight[2] = bgColor[2] - FILLCOLOR_BELEVED_LOWLIGHT_OFFSET_BLUE;
                }
                g = InstructionFactory.newDeviceRGBFill(color_Lowlight[0], color_Lowlight[1], color_Lowlight[2]);
            } else {
                g = InstructionFactory.newDeviceGrayFill(FILLCOLOR_BELEVED_LOWLIGHT_GREYSCALE);
            }
            contentWriter.write(g);
            x = right - width;
            y = top - width;
            m = InstructionFactory.newMoveTo(x, y);
            contentWriter.write(m);
            y = bottom + width;
            l = InstructionFactory.newLineTo(x, y);
            contentWriter.write(l);
            x = left + width;
            y = bottom + width;
            l = InstructionFactory.newLineTo(x, y);
            contentWriter.write(l);
            x = left + 2.0 * width;
            y = bottom + 2.0 * width;
            l = InstructionFactory.newLineTo(x, y);
            contentWriter.write(l);
            x = right - 2.0 * width;
            l = InstructionFactory.newLineTo(x, y);
            contentWriter.write(l);
            y = top - 2.0 * width;
            l = InstructionFactory.newLineTo(x, y);
            contentWriter.write(l);
            f = InstructionFactory.newFillPath();
            contentWriter.write(f);
        }
        if (style == PDFBorderStyle.Style.Inset) {
            g = InstructionFactory.newDeviceGrayFill(FILLCOLOR_INSET_HIGHLIGHT);
            contentWriter.write(g);
            x = left + width;
            y = bottom + width;
            m = InstructionFactory.newMoveTo(x, y);
            contentWriter.write(m);
            y = top - width;
            l = InstructionFactory.newLineTo(x, y);
            contentWriter.write(l);
            x = right - width;
            l = InstructionFactory.newLineTo(x, y);
            contentWriter.write(l);
            l = InstructionFactory.newLineTo(x -= width, y -= width);
            contentWriter.write(l);
            x = left + 2.0 * width;
            l = InstructionFactory.newLineTo(x, y);
            contentWriter.write(l);
            y = bottom + 2.0 * width;
            l = InstructionFactory.newLineTo(x, y);
            contentWriter.write(l);
            f = InstructionFactory.newFillPath();
            contentWriter.write(f);
            g = InstructionFactory.newDeviceGrayFill(FILLCOLOR_INSET_LOWLIGHT);
            contentWriter.write(g);
            x = right - width;
            y = top - width;
            m = InstructionFactory.newMoveTo(x, y);
            contentWriter.write(m);
            y = bottom + width;
            l = InstructionFactory.newLineTo(x, y);
            contentWriter.write(l);
            x = left + width;
            y = bottom + width;
            l = InstructionFactory.newLineTo(x, y);
            contentWriter.write(l);
            x = left + 2.0 * width;
            y = bottom + 2.0 * width;
            l = InstructionFactory.newLineTo(x, y);
            contentWriter.write(l);
            x = right - 2.0 * width;
            l = InstructionFactory.newLineTo(x, y);
            contentWriter.write(l);
            y = top - 2.0 * width;
            l = InstructionFactory.newLineTo(x, y);
            contentWriter.write(l);
            f = InstructionFactory.newFillPath();
            contentWriter.write(f);
        }
    }

    public static void addClippingPath(ContentWriter contentWriter, PDFRectangle bBoxRect, PDFBorderStyle bs) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        double lineWidth = 1.0;
        if (bs != null && bs.hasWidth()) {
            lineWidth = bs.getWidth();
        }
        double x = bBoxRect.left() + lineWidth;
        double y = bBoxRect.bottom() + lineWidth;
        double clipWidth = bBoxRect.width() - 2.0 * lineWidth;
        double clipHeight = bBoxRect.height() - 2.0 * lineWidth;
        ContentModifier.addClippingRectangle(contentWriter, x, y, clipWidth, clipHeight);
    }

    public static void addClippingPath(ContentWriter contentWriter, PDFRectangle bBoxRect, double paddingLeft, double paddingRight, double paddingTop, double paddingBottom) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        double x = bBoxRect.left() + paddingLeft;
        double y = bBoxRect.bottom() + paddingBottom;
        double clipWidth = bBoxRect.width() - (paddingLeft + paddingRight);
        double clipHeight = bBoxRect.height() - (paddingTop + paddingBottom);
        ContentModifier.addClippingRectangle(contentWriter, x, y, clipWidth, clipHeight);
    }

    private static void addClippingRectangle(ContentWriter contentWriter, double x, double y, double clipWidth, double clipHeight) throws PDFIOException {
        Instruction s = InstructionFactory.newRectangle(x, y, clipWidth, clipHeight);
        contentWriter.write(s);
        s = InstructionFactory.newClipPath();
        contentWriter.write(s);
        s = InstructionFactory.newEndPathNoOp();
        contentWriter.write(s);
    }

    public static void addBeginMarkedContent(ContentWriter contentWriter) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Instruction bmc = InstructionFactory.newBeginMarkedContent(ASName.k_Tx);
        contentWriter.write(bmc);
    }

    public static void addEndMarkedContent(ContentWriter contentWriter) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Instruction emc = InstructionFactory.newEndMarkedContent();
        contentWriter.write(emc);
    }

    private static double fromHex(String hexString) {
        return (double)Integer.parseInt(hexString, 16) / 65536.0;
    }

    public static ASMatrix getMatrixFromOperands(OperandStack operands) {
        ArrayList<ASNumber> cmParams = new ArrayList<ASNumber>();
        Iterator<Object> oprandIter = operands.iterator();
        while (oprandIter.hasNext()) {
            ASNumber matrixNum = (ASNumber)oprandIter.next();
            cmParams.add(matrixNum);
        }
        double[] cmArray = new double[6];
        for (int i = 0; i < 6; ++i) {
            cmArray[i] = ((ASNumber)cmParams.get(i)).doubleValue();
        }
        return new ASMatrix(cmArray);
    }

    public static ASName getObjectName(OperandStack operands) {
        Iterator<Object> oprandIter = operands.iterator();
        return (ASName)oprandIter.next();
    }
}

