/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.content;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.fontset.PDFFontSet;
import com.adobe.internal.pdftoolkit.core.types.ASArray;
import com.adobe.internal.pdftoolkit.core.types.ASCoordinate;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.content.Content;
import com.adobe.internal.pdftoolkit.pdf.content.ContentStack;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.pdf.content.NoopOperatorHandler;
import com.adobe.internal.pdftoolkit.pdf.content.XObjectProcessingFunction;
import com.adobe.internal.pdftoolkit.pdf.content.XObjectsCycleDetector;
import com.adobe.internal.pdftoolkit.pdf.content.processor.ActualText;
import com.adobe.internal.pdftoolkit.pdf.content.processor.ContentStreamProcessor;
import com.adobe.internal.pdftoolkit.pdf.content.processor.GState;
import com.adobe.internal.pdftoolkit.pdf.content.processor.GStateStack;
import com.adobe.internal.pdftoolkit.pdf.content.processor.Path;
import com.adobe.internal.pdftoolkit.pdf.content.processor.StatefulContentStreamProcessor;
import com.adobe.internal.pdftoolkit.pdf.content.processor.TextObject;
import com.adobe.internal.pdftoolkit.pdf.content.processor.TextState;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFDashPattern;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFExtGState;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFLineCap;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFLineJoin;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFRenderingIntent;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectMap;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import java.util.HashMap;
import java.util.Iterator;

public abstract class StatefulOperatorHandler
extends NoopOperatorHandler {
    protected ContentStack contentStack;
    protected GStateStack gStateStack = new GStateStack<GState>(new GState());
    protected Path currentPath;
    protected TextObject currentTextObj;
    protected PDFFontSet fontSet;
    protected boolean isTD = false;
    protected HashMap<PDFResources, HashMap<String, Integer>> fontCache;
    protected HashMap<Integer, PDFFont> cosToFontMap;
    protected PDFPage currentPage;
    private boolean ignoreErrors;
    protected XObjectsCycleDetector xobjectsCycleDetector;
    private ActualText actualText;

    public StatefulOperatorHandler() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.contentStack = new ContentStack();
        this.fontCache = new HashMap();
        this.cosToFontMap = new HashMap();
    }

    protected StatefulOperatorHandler(PDFPage page) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this();
        this.currentPage = page;
    }

    protected PDFResources getResources() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.contentStack.peek().getResources();
    }

    public ContentStack getContentStack() {
        return this.contentStack;
    }

    public GState getGState() {
        return this.gStateStack.peek();
    }

    public void pushGState() {
        GState gState = new GState((GState)this.gStateStack.peek());
        this.gStateStack.push(gState);
    }

    public GState popGState() {
        return this.gStateStack.pop();
    }

    @Override
    public void w(double lineWidth, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getGState().setLineWidth(lineWidth);
    }

    @Override
    public void J(PDFLineCap lineCap, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getGState().setLineCap(lineCap);
    }

    @Override
    public void j(PDFLineJoin lineJoin, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getGState().setLineJoin(lineJoin);
    }

    @Override
    public void M(double miterLimit, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getGState().setMiterLimit(miterLimit);
    }

    @Override
    public void d(PDFDashPattern dashPattern, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getGState().setDashPattern(dashPattern);
    }

    @Override
    public void ri(PDFRenderingIntent intent, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getGState().setRenderingIntent(intent);
    }

    @Override
    public void i(double flatness, Instruction instruction) throws PDFIOException {
        this.getGState().setFlatness(flatness);
    }

    @Override
    public void gs(ASName extGStateName, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFResources resources = this.getResources();
        PDFExtGState extGState = resources.getExtGState(extGStateName);
        this.getGState().loadExtGState(extGState);
    }

    @Override
    public void q(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.pushGState();
    }

    @Override
    public void Q(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.popGState();
    }

    @Override
    public void cm(double a, double b, double c, double d, double e, double f, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASMatrix ctm = new ASMatrix(a, b, c, d, e, f);
        GState gState = this.getGState();
        gState.setCTM(ctm.concat(gState.getCTM()));
    }

    @Override
    public void m(double x, double y, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentPath == null) {
            this.createNewPath();
        }
        this.currentPath.moveTo(new ASCoordinate(x, y));
    }

    @Override
    public void l(double x, double y, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentPath == null) {
            this.createNewPath();
        }
        this.currentPath.lineTo(new ASCoordinate(x, y));
    }

    @Override
    public void c(double x1, double y1, double x2, double y2, double x3, double y3, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentPath == null) {
            this.createNewPath();
        }
        this.currentPath.curveTo(new ASCoordinate(x1, y1), new ASCoordinate(x2, y2), new ASCoordinate(x3, y3));
    }

    @Override
    public void v(double x2, double y2, double x3, double y3, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentPath == null) {
            this.createNewPath();
        }
        this.currentPath.curveToV(new ASCoordinate(x2, y2), new ASCoordinate(x3, y3));
    }

    @Override
    public void y(double x1, double y1, double x3, double y3, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentPath == null) {
            this.createNewPath();
        }
        this.currentPath.curveToV(new ASCoordinate(x1, y1), new ASCoordinate(x3, y3));
    }

    @Override
    public void h(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentPath == null) {
            this.createNewPath();
        }
        this.currentPath.close();
    }

    @Override
    public void re(double x, double y, double width, double height, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentPath == null) {
            this.createNewPath();
        }
        this.currentPath.moveTo(new ASCoordinate(x, y));
        this.currentPath.lineTo(new ASCoordinate(x + width, y));
        this.currentPath.lineTo(new ASCoordinate(x + width, y + height));
        this.currentPath.lineTo(new ASCoordinate(x, y + height));
        this.currentPath.close();
    }

    protected void createNewPath() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.currentPath = new Path();
        this.currentPath.setWindingRule(0);
    }

    protected void endPath() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.currentPath = null;
    }

    @Override
    public void S(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentPath == null) {
            this.createNewPath();
        }
        this.endPath();
    }

    @Override
    public void s(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentPath == null) {
            this.createNewPath();
        }
        this.currentPath.close();
        this.endPath();
    }

    @Override
    public void f(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentPath != null) {
            this.currentPath.close();
            this.endPath();
        }
    }

    @Override
    public void fStar(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentPath == null) {
            this.createNewPath();
        }
        this.currentPath.close();
        this.endPath();
    }

    @Override
    public void B(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentPath == null) {
            this.createNewPath();
        }
        this.endPath();
    }

    @Override
    public void BStar(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentPath == null) {
            this.createNewPath();
        }
        this.endPath();
    }

    @Override
    public void b(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentPath == null) {
            this.createNewPath();
        }
        this.currentPath.close();
        this.endPath();
    }

    @Override
    public void bStar(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentPath == null) {
            this.createNewPath();
        }
        this.currentPath.close();
        this.endPath();
    }

    @Override
    public void n(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (this.currentPath == null) {
            this.createNewPath();
        }
        this.currentPath.setShow(false);
        this.endPath();
    }

    @Override
    public void W(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentPath == null) {
            this.createNewPath();
        }
        this.currentPath.close();
        this.currentPath.setWindingRule(1);
        this.getGState().addPathToClip(this.currentPath);
    }

    @Override
    public void WStar(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentPath == null) {
            this.createNewPath();
        }
        this.currentPath.close();
        this.currentPath.setWindingRule(0);
        this.getGState().addPathToClip(this.currentPath);
    }

    @Override
    public void Tc(double charSpacing, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentTextObj != null && this.currentTextObj.skipThisTextObject()) {
            return;
        }
        this.getTextState().setCharSpacing(charSpacing);
    }

    @Override
    public void Tw(double wordSpacing, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentTextObj != null && this.currentTextObj.skipThisTextObject()) {
            return;
        }
        this.getTextState().setWordSpacing(wordSpacing);
    }

    @Override
    public void Tz(double scaling, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentTextObj != null && this.currentTextObj.skipThisTextObject()) {
            return;
        }
        this.getTextState().setHorizScaling(scaling);
    }

    @Override
    public void TL(double leading, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentTextObj != null && this.currentTextObj.skipThisTextObject()) {
            return;
        }
        this.getTextState().setLeading(leading);
    }

    @Override
    public void Tf(ASName fontName, double fontSize, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentTextObj != null && this.currentTextObj.skipThisTextObject()) {
            return;
        }
        TextState textState = this.getTextState();
        textState.setFontName(fontName);
        textState.setFontSize(fontSize);
        PDFFont font = this.getFontFromCache(fontName);
        if (font != null) {
            textState.setFont(font);
        }
    }

    private PDFFont getFontFromCache(ASName fontName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String asFontName;
        PDFResources resources = this.getResources();
        HashMap<String, Integer> nameToObjectNumMap = this.fontCache.get(resources);
        if (nameToObjectNumMap == null) {
            nameToObjectNumMap = new HashMap();
            this.fontCache.put(resources, nameToObjectNumMap);
        }
        if (!nameToObjectNumMap.containsKey(asFontName = fontName.asString())) {
            PDFFontMap pageFontMap;
            PDFResources pageRes;
            PDFFont font;
            Iterator itr;
            CosDictionary obj = null;
            PDFFontMap pdfFontMap = null;
            if (resources != null) {
                pdfFontMap = PDFFontMap.getInstance(resources.getDictionaryCosObjectValue(ASName.k_Font));
            }
            if (pdfFontMap != null && (obj = pdfFontMap.getDictionaryDictionaryValue(fontName)) == null && (itr = pdfFontMap.values().iterator()).hasNext() && (font = (PDFFont)itr.next()).getBaseFont().equals(fontName)) {
                font.setFontSet(this.fontSet);
                return font;
            }
            if (obj == null && (pageRes = this.currentPage.getResources()) != null && (pageFontMap = PDFFontMap.getInstance(pageRes.getDictionaryCosObjectValue(ASName.k_Font))) != null) {
                pdfFontMap = pageFontMap;
                obj = pageFontMap.getDictionaryDictionaryValue(fontName);
            }
            if (obj == null) {
                if (this.currentTextObj != null) {
                    this.currentTextObj.setSkipThisTextObject(true);
                }
                return null;
            }
            Integer objNum = obj.getObjNum();
            font = this.cosToFontMap.get(objNum);
            if (font == null) {
                font = pdfFontMap.get(fontName);
                this.cosToFontMap.put(objNum, font);
            }
            font.setFontSet(this.fontSet);
            nameToObjectNumMap.put(asFontName, objNum);
            return font;
        }
        Integer objNum = nameToObjectNumMap.get(asFontName);
        return this.cosToFontMap.get(objNum);
    }

    @Override
    public void Tr(int renderMode, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentTextObj != null && this.currentTextObj.skipThisTextObject()) {
            return;
        }
        this.getTextState().setRenderingMode(renderMode);
    }

    @Override
    public void Ts(double textRise, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentTextObj != null && this.currentTextObj.skipThisTextObject()) {
            return;
        }
        this.getTextState().setRise(textRise);
    }

    @Override
    public void BT(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.currentTextObj = new TextObject(this.currentPage.getPDFDocument(), this.ignoreErrors);
    }

    @Override
    public void ET(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
    }

    @Override
    public void Td(double tx, double ty, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentTextObj != null && this.currentTextObj.skipThisTextObject()) {
            return;
        }
        TextObject textObj = this.getCurrentTextObject();
        ASMatrix tlm = textObj.getTextLineMatrix();
        tlm = tlm.preMultiply(tx, ty);
        textObj.setTextLineMatrix(tlm);
        textObj.setTextMatrix(tlm);
    }

    @Override
    public void TD(double tx, double ty, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentTextObj != null && this.currentTextObj.skipThisTextObject()) {
            return;
        }
        this.isTD = true;
        this.TL(-ty, null);
        this.Td(tx, ty, null);
    }

    @Override
    public void Tm(double a, double b, double c, double d, double e, double f, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentTextObj != null && !this.currentTextObj.skipThisTextObject()) {
            ASMatrix tm;
            ASMatrix tlm = tm = new ASMatrix(a, b, c, d, e, f);
            TextObject textObj = this.getCurrentTextObject();
            textObj.setTextMatrix(tm);
            textObj.setTextLineMatrix(tlm);
        }
    }

    @Override
    public void TStar(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentTextObj != null && this.currentTextObj.skipThisTextObject()) {
            return;
        }
        double leading = this.getTextState().getLeading();
        this.Td(0.0, -leading, null);
    }

    @Override
    public void Tj(ASString string, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.currentTextObj.addTextRun(string, this.getGState(), this.actualText);
    }

    @Override
    public void SingleQuote(ASString string, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentTextObj != null && this.currentTextObj.skipThisTextObject()) {
            return;
        }
        this.TStar(null);
        this.Tj(string, null);
    }

    @Override
    public void DoubleQuote(double wordSpacing, double charSpacing, ASString string, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentTextObj != null && this.currentTextObj.skipThisTextObject()) {
            return;
        }
        this.Tw(wordSpacing, null);
        this.Tc(charSpacing, null);
        this.currentTextObj.addTextRun(string, this.getGState(), this.actualText);
    }

    @Override
    public void TJ(ASArray tjArray, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentTextObj != null && this.currentTextObj.skipThisTextObject()) {
            return;
        }
        this.currentTextObj.addTextRun(tjArray, this.getGState(), this.actualText);
    }

    public TextState getTextState() {
        return this.getGState().getTextState();
    }

    public TextObject getCurrentTextObject() {
        return this.currentTextObj;
    }

    @Override
    public void BI(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
    }

    @Override
    public void EI(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processXObject(ASName name, Instruction instruction, XObjectProcessingFunction function) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFXObject xObject = null;
        PDFResources xobjectsResources = this.getResources();
        PDFResources pageResources = this.currentPage.getResources();
        if (xobjectsResources == null) {
            if (pageResources != null) {
                xObject = pageResources.getXObjectMap().get(name);
            }
        } else {
            PDFXObjectMap pdfxObjectMap;
            PDFXObjectMap xObjectMap = xobjectsResources.getXObjectMap();
            if ((xObjectMap == null || (xObject = xObjectMap.get(name)) == null) && pageResources != null && (pdfxObjectMap = pageResources.getXObjectMap()) != null) {
                xObject = pdfxObjectMap.get(name);
            }
        }
        if (xObject != null) {
            this.q(null);
            if (this.xobjectsCycleDetector != null) {
                if (this.xobjectsCycleDetector.cycleDetected(xObject)) {
                    throw new PDFInvalidDocumentException("Cyclic dependency found while processing xobjects.");
                }
                this.xobjectsCycleDetector.push(xObject);
            }
            try {
                if (function != null) {
                    function.process(xObject);
                } else if (xObject instanceof PDFXObjectForm) {
                    PDFXObjectForm xObjectForm = (PDFXObjectForm)xObject;
                    StatefulContentStreamProcessor streamProcessor = new StatefulContentStreamProcessor(this);
                    ((ContentStreamProcessor)streamProcessor).process(Content.newInstance(xObjectForm));
                }
            }
            finally {
                if (this.xobjectsCycleDetector != null) {
                    this.xobjectsCycleDetector.pop();
                }
            }
            this.Q(null);
        }
    }

    public void setIgnoreErrors(boolean ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
    }
}

