/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.traverser;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosContainer;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosList;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosObjectID;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.traverser.Dispatcher;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Traverser {
    private Dispatcher mDispatcher;

    public Traverser(Dispatcher dispatcher) {
        this.mDispatcher = dispatcher;
    }

    public boolean traverseCosGraph(CosContainer root) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException, PDFInvalidParameterException {
        if (this.mDispatcher == null) {
            return true;
        }
        CosList seenObjects = new CosList();
        ArrayList<TraverserStackItem> visitorStack = new ArrayList<TraverserStackItem>();
        CosContainer container = root;
        List<ASName> containerKeys = ((CosDictionary)container).getKeys();
        Iterator containerIter = containerKeys.iterator();
        ASName containerKey = null;
        CosObject containerItem = null;
        seenObjects.add(container.getObjNum(), new CosObjectID(container.getObjNum(), container.getObjGen()));
        boolean pushState = false;
        while (true) {
            if (containerIter.hasNext()) {
                if (container instanceof CosArray) {
                    containerItem = (CosObject)((Object)containerIter.next());
                } else {
                    containerKey = containerIter.next();
                    if (containerKey == ASName.k_Parent || containerKey == ASName.k_P) continue;
                    containerItem = ((CosDictionary)container).get(containerKey);
                }
                if (containerItem == null) continue;
                int objNum = containerItem.getObjNum();
                if (objNum != 0) {
                    if (seenObjects.containsIndex(objNum)) continue;
                    seenObjects.add(objNum, new CosObjectID(objNum, containerItem.getObjGen()));
                }
                if (this.mDispatcher.isCandidate(containerKey, containerItem)) {
                    visitorStack.add(new TraverserStackItem(container, containerIter, containerKey));
                    if (!this.mDispatcher.dispatchObject(containerItem, visitorStack)) {
                        return this.badReturn();
                    }
                    visitorStack.remove(visitorStack.size() - 1);
                }
                if (!(containerItem instanceof CosContainer)) continue;
                pushState = true;
            }
            if (pushState) {
                visitorStack.add(new TraverserStackItem(container, containerIter, containerKey));
                container = (CosContainer)containerItem;
                if (container instanceof CosArray) {
                    containerKey = null;
                    containerKeys = null;
                    containerIter = ((CosArray)container).iterator();
                } else {
                    containerKeys = ((CosDictionary)container).getKeys();
                    containerIter = containerKeys.iterator();
                }
                pushState = false;
                continue;
            }
            if (visitorStack.isEmpty()) {
                return true;
            }
            TraverserStackItem item = (TraverserStackItem)visitorStack.get(visitorStack.size() - 1);
            visitorStack.remove(visitorStack.size() - 1);
            containerKey = item.getContainerKey();
            container = item.getContainer();
            containerIter = item.getContainerIter();
        }
    }

    private boolean badReturn() {
        return false;
    }

    public static final class TraverserStackItem {
        private CosContainer mContainer = null;
        private Iterator mContainerIter = null;
        private ASName mContainerKey = null;

        private TraverserStackItem(CosContainer container, Iterator containerIter, ASName containerKey) {
            this.mContainer = container;
            this.mContainerIter = containerIter;
            this.mContainerKey = containerKey;
        }

        public CosContainer getContainer() {
            return this.mContainer;
        }

        private Iterator getContainerIter() {
            return this.mContainerIter;
        }

        public ASName getContainerKey() {
            return this.mContainerKey;
        }
    }
}

