/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.filter;

import com.adobe.internal.pdftoolkit.core.filter.FilterParams;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CCITTFaxOutputStream
extends FilterOutputStream {
    private int mCols = 1728;
    private int[] mRunsThisScan;
    private byte[] mbytesThisScan;
    private int mScanByteCounter;
    private int mLeftOverBits;
    private int mLeftOverCount;
    private static final int NTERMCODES = 64;
    private static final int NMAKEUPCODES = 40;
    private static final int PASSCODE = 4100;
    private static final int HORIZONTALCODE = 8195;
    private static final int EXTRALONGRUN = 508;
    private static final int[] vertCodes = new int[]{1031, 2054, 16387, 32769, 24579, 3078, 1543};
    private static final int[] termCodesWhite = new int[]{13576, 7174, 28676, 32772, 45060, 49156, 57348, 61444, 38917, 40965, 14341, 16389, 8198, 3078, 53254, 54278, 43014, 44038, 19975, 6151, 4103, 11783, 1543, 2055, 20487, 22023, 9735, 18439, 12295, 520, 776, 6664, 6920, 4616, 4872, 5128, 5384, 5640, 5896, 10248, 10504, 10760, 11016, 11272, 11528, 1032, 1288, 2568, 2824, 21000, 21256, 21512, 21768, 9224, 9480, 22536, 22792, 23048, 23304, 18952, 19208, 12808, 13064, 13320};
    private static final int[] makeupCodesWhite = new int[]{55301, 36869, 23558, 28167, 13832, 14088, 25608, 25864, 26632, 26376, 26121, 26249, 26889, 27017, 27145, 27273, 27401, 27529, 27657, 27785, 27913, 28041, 19465, 19593, 19721, 24582, 19849, 267, 395, 427, 300, 316, 332, 348, 364, 380, 460, 476, 492, 508};
    private static final int[] termCodesBlack = new int[]{3530, 16387, 49154, 32770, 24579, 12292, 8196, 6149, 5126, 4102, 2055, 2567, 3591, 1032, 1800, 3081, 1482, 1546, 522, 3307, 3339, 3467, 1771, 1291, 747, 779, 3244, 3260, 3276, 3292, 1676, 1692, 1708, 1724, 3372, 3388, 3404, 3420, 3436, 3452, 1740, 1756, 3500, 3516, 1356, 1372, 1388, 1404, 1612, 1628, 1324, 1340, 588, 892, 908, 636, 652, 1420, 1436, 700, 716, 1452, 1644, 1660};
    private static final int[] makeupCodesBlack = new int[]{970, 3212, 3228, 1468, 828, 844, 860, 1741, 1757, 1197, 1213, 1229, 1245, 1837, 1853, 1869, 1885, 1901, 1917, 1325, 1341, 1357, 1373, 1453, 1469, 1613, 1629, 267, 395, 427, 300, 316, 332, 348, 364, 380, 460, 476, 492, 508};

    public CCITTFaxOutputStream(OutputStream outStm, FilterParams params) {
        super(outStm);
        Integer cols;
        if (params != null && (cols = (Integer)params.get("Columns")) != null) {
            this.mCols = cols;
        }
        this.mRunsThisScan = new int[this.mCols + 4];
        this.mRunsThisScan[0] = 1;
        this.mRunsThisScan[1] = this.mCols;
        this.mbytesThisScan = new byte[(this.mCols + 7) / 8];
    }

    public CCITTFaxOutputStream(OutputStream outStm) {
        this(outStm, null);
    }

    @Override
    public void write(int b) throws IOException {
        this.mbytesThisScan[this.mScanByteCounter++] = (byte)b;
        if (this.mScanByteCounter == this.mbytesThisScan.length) {
            this.compressScan();
            this.mScanByteCounter = 0;
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int count = b.length - off;
        if (count > len) {
            count = len;
        }
        while (count > 0) {
            int curSpace = this.mbytesThisScan.length - this.mScanByteCounter;
            int curCount = count < curSpace ? count : curSpace;
            System.arraycopy(b, off, this.mbytesThisScan, this.mScanByteCounter, curCount);
            off += curCount;
            count -= curCount;
            if (curCount == curSpace) {
                this.compressScan();
                this.mScanByteCounter = 0;
                continue;
            }
            this.mScanByteCounter += curCount;
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void close() throws IOException {
        while (this.mLeftOverCount > 0) {
            this.out.write(this.mLeftOverBits >> 24 & 0xFF);
            this.mLeftOverBits <<= 8;
            this.mLeftOverCount -= 8;
        }
        super.close();
    }

    private void compressScan() throws IOException {
        int[] mRunsLastScan = this.mRunsThisScan;
        this.mRunsThisScan = new int[this.mCols + 4];
        CCITTFaxOutputStream.convertToRuns(this.mbytesThisScan, this.mRunsThisScan, this.mCols);
        this.code2DCompressed(this.mRunsThisScan, mRunsLastScan);
    }

    private static void convertToRuns(byte[] srcData, int[] dstRuns, int cols) {
        int runIdx = 1;
        int curLen = 0;
        boolean runIsWhite = true;
        for (int i = 0; i < srcData.length; ++i) {
            byte curByte = srcData[i];
            int bitCnt = i < srcData.length - 1 ? 8 : cols - 8 * (srcData.length - 1);
            if (curByte == (runIsWhite ? (byte)255 : 0)) {
                curLen += bitCnt;
                continue;
            }
            for (int j = 0; j < bitCnt; ++j) {
                boolean bitIsWhite = (curByte & 0x80) != 0;
                curByte = (byte)(curByte << 1);
                if (bitIsWhite == runIsWhite) {
                    ++curLen;
                    continue;
                }
                dstRuns[runIdx++] = curLen;
                curLen = 1;
                runIsWhite ^= true;
            }
        }
        dstRuns[runIdx++] = curLen;
        dstRuns[0] = runIdx - 1;
    }

    private void code2DCompressed(int[] scanRuns, int[] prevRuns) throws IOException {
        int a0 = 0;
        int b1 = prevRuns[1];
        int prevIdx = 2;
        int runIdx = 1;
        int runLim = scanRuns[0] + 1;
        boolean isBlack = false;
        while (runIdx < runLim) {
            int b2;
            int a1 = a0 + scanRuns[runIdx];
            int passes = 0;
            while (b1 <= a0 && (0 < a0 || isBlack)) {
                b1 += prevRuns[prevIdx] + prevRuns[prevIdx + 1];
                prevIdx += 2;
            }
            while ((b2 = b1 + prevRuns[prevIdx]) < a1) {
                ++passes;
                b1 = b2 + prevRuns[prevIdx + 1];
                prevIdx += 2;
            }
            if (a1 <= b1 + 3 && b1 <= a1 + 3 && passes < 6) {
                while (0 < passes--) {
                    this.nextCode(4100);
                }
                this.nextCode(vertCodes[3 + (a1 - b1)]);
                isBlack ^= true;
                b1 = b1 <= a1 ? (b1 += prevRuns[prevIdx++]) : (b1 -= prevRuns[--prevIdx]);
                ++runIdx;
            } else {
                a1 += scanRuns[runIdx + 1];
                this.nextCode(8195);
                this.code1DRun(scanRuns[runIdx], isBlack);
                this.code1DRun(scanRuns[runIdx + 1], !isBlack);
                runIdx += 2;
            }
            a0 = a1;
        }
    }

    private void nextCode(int code) throws IOException {
        int codeLen;
        code >>= (codeLen = code & 0xF) < 12 ? 16 - codeLen : 4;
        while (this.mLeftOverCount >= 8) {
            this.out.write(this.mLeftOverBits >> 24 & 0xFF);
            this.mLeftOverBits <<= 8;
            this.mLeftOverCount -= 8;
        }
        this.mLeftOverBits &= -1 << 32 - this.mLeftOverCount;
        this.mLeftOverBits |= code << 32 - this.mLeftOverCount - codeLen;
        this.mLeftOverCount += codeLen;
    }

    private void code1DRun(int runLen, boolean isBlack) throws IOException {
        int[] termCodesTable;
        int[] nArray = termCodesTable = isBlack ? termCodesBlack : termCodesWhite;
        if (runLen >= 64) {
            while (runLen > 2560) {
                this.nextCode(508);
                runLen -= 2560;
            }
            if (runLen >= 64) {
                int[] makeupCodesTable = isBlack ? makeupCodesBlack : makeupCodesWhite;
                this.nextCode(makeupCodesTable[runLen / 64 - 1]);
                runLen %= 64;
            }
        }
        this.nextCode(termCodesTable[runLen]);
    }
}

