/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.credentials.impl;

import com.adobe.internal.pdftoolkit.core.credentials.CredentialFactory;
import com.adobe.internal.pdftoolkit.core.credentials.Credentials;
import com.adobe.internal.pdftoolkit.core.credentials.PrivateKeyHolder;
import com.adobe.internal.pdftoolkit.core.credentials.impl.JCEKeyHolder;
import com.adobe.internal.pdftoolkit.core.credentials.impl.utils.CertUtils;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;

public class JCECredentials
implements Credentials {
    String providerName;
    boolean isHSM;
    private JCEKeyHolder privateKeyHolder;
    private X509Certificate cert;
    private Certificate[] certChain;

    public JCECredentials(PrivateKeyHolder keyHolder, byte[] derEncodedCert, byte[][] derEncodedCertChain) throws PDFInvalidParameterException {
        try {
            X509Certificate jceCert = (X509Certificate)CertUtils.importCertificate(derEncodedCert);
            Certificate[] jceCertChain = CertUtils.importCertificateChain(derEncodedCertChain);
            PrivateKeyHolder jcePrivateKeyHolder = CredentialFactory.computeJCEPrivateKey(keyHolder);
            this.populateJCEData(jcePrivateKeyHolder, jceCert, jceCertChain);
            this.providerName = keyHolder instanceof JCEKeyHolder ? ((JCEKeyHolder)keyHolder).getProviderName() : "RSA";
        }
        catch (CertificateException e) {
            throw new PDFInvalidParameterException("Could not load the certficate and certificate chain - ", e);
        }
        catch (IOException e) {
            throw new PDFInvalidParameterException("IO Exception when importing JCE keys and certs - ", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new PDFInvalidParameterException("Could not determine the Algorithm - ", e);
        }
        catch (InvalidKeySpecException e) {
            throw new PDFInvalidParameterException("Invalid Key ", e);
        }
    }

    public JCECredentials(PrivateKey privateKey, X509Certificate cert, Certificate[] certChain) {
        JCEKeyHolder keyHolder = new JCEKeyHolder(privateKey, "RSA");
        this.populateJCEData(keyHolder, cert, certChain);
    }

    public JCECredentials(PrivateKeyHolder keyHolder, X509Certificate cert, Certificate[] certChain) throws NoSuchAlgorithmException, InvalidKeySpecException, PDFInvalidParameterException {
        PrivateKeyHolder jcePrivateKeyHolder = CredentialFactory.computeJCEPrivateKey(keyHolder);
        this.populateJCEData(jcePrivateKeyHolder, cert, certChain);
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    @Override
    public boolean isHSM() {
        return this.isHSM;
    }

    public void setHSM(boolean isHSM) {
        this.isHSM = isHSM;
    }

    protected void populateJCEData(PrivateKeyHolder privateKeyHolder, X509Certificate cert, Certificate[] certChain) {
        this.privateKeyHolder = (JCEKeyHolder)privateKeyHolder;
        this.cert = cert;
        this.certChain = certChain;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKeyHolder != null ? this.privateKeyHolder.getJcePrivateKey() : null;
    }

    public String getProviderName() {
        return this.privateKeyHolder != null ? this.privateKeyHolder.getProviderName() : null;
    }

    public Provider getProvider() {
        return Security.getProvider(this.getProviderName());
    }

    public X509Certificate getCertificate() {
        return this.cert;
    }

    public Certificate[] getCertificateChain() {
        return this.certChain;
    }
}

