/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.cos;

import com.adobe.internal.pdftoolkit.core.cos.CosContainerValuesIterator;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosObjectRef;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import java.io.IOException;

public class CosArrayValuesIterator
extends CosContainerValuesIterator {
    private CosObject[] mValues;
    int mInd;

    public CosArrayValuesIterator(CosObject[] values) {
        this.mValues = values;
        this.mInd = 0;
    }

    @Override
    public boolean hasNext() {
        return this.mInd < this.mValues.length;
    }

    @Override
    public CosContainerValuesIterator.Entry next() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        try {
            CosObject curObj = this.mValues[this.mInd++];
            if (curObj instanceof CosObjectRef) {
                curObj = curObj.getDocument().resolveReference((CosObjectRef)curObj);
            }
            return this.createEntry(null, this.mInd, curObj);
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }
}

