/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.io.stream;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.InputByteStreamImpl;
import java.io.IOException;

public class PaddedInputByteStream
extends InputByteStreamImpl {
    private InputByteStream baseIBS;
    private int paddedChar = 32;
    private long padLength = 0L;
    private long padMark = 0L;

    public PaddedInputByteStream(InputByteStream ibs, int paddedChar, long padLength) {
        this.baseIBS = ibs;
        this.paddedChar = paddedChar;
        this.padLength = padLength;
    }

    public void close() throws IOException {
        this.baseIBS.close();
    }

    public long getPosition() throws IOException {
        if (this.baseIBS.eof()) {
            return this.baseIBS.length() + this.padMark;
        }
        return this.baseIBS.getPosition();
    }

    public long length() throws IOException {
        return this.baseIBS.length() + this.padLength;
    }

    public int read() throws IOException {
        if (this.eof()) {
            return -1;
        }
        if (this.baseIBS.eof()) {
            ++this.padMark;
            return this.paddedChar;
        }
        return this.baseIBS.read();
    }

    public int read(byte[] bytes, int position, int length) throws IOException {
        int bytesToBeCopied;
        if (this.eof()) {
            return -1;
        }
        if (this.getPosition() + (long)length <= this.baseIBS.length()) {
            return this.baseIBS.read(bytes, position, length);
        }
        if (this.getPosition() + (long)length > this.length()) {
            length = (int)(this.length() - this.getPosition());
        }
        bytesToBeCopied = (bytesToBeCopied = (int)(this.baseIBS.length() - this.getPosition())) > 0 ? bytesToBeCopied : 0;
        this.baseIBS.read(bytes, position, bytesToBeCopied);
        for (int i = position += bytesToBeCopied; i < position + length - bytesToBeCopied; ++i) {
            bytes[i] = (byte)this.paddedChar;
        }
        this.padMark += (long)(length - bytesToBeCopied);
        return length;
    }

    public InputByteStream seek(long position) throws IOException {
        if (position > this.length()) {
            this.padMark = this.padLength;
            this.baseIBS.seek(this.baseIBS.length());
        } else if (position < this.baseIBS.length()) {
            this.padMark = 0L;
            this.baseIBS.seek(position);
        } else {
            this.baseIBS.seek(this.baseIBS.length());
            this.padMark = position - this.baseIBS.length();
        }
        return this;
    }

    public InputByteStream slice(long begin, long length) throws IOException {
        long padding = 0L;
        if (begin < 0L || length < 0L || begin + length > this.length()) {
            throw new IOException("Invalid slice of PaddedBytestream");
        }
        if (begin + length > this.baseIBS.length()) {
            if (begin > this.baseIBS.length()) {
                padding = length;
                begin = 0L;
                length = 0L;
            } else {
                padding = (int)(begin + length - this.baseIBS.length());
                length -= padding;
            }
        }
        return new PaddedInputByteStream(this.baseIBS.slice(begin, length), this.paddedChar, padding);
    }
}

