/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.fontmanagement.platform;

import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.fontmanagement.FontResolutionPriority;
import com.adobe.fontengine.fontmanagement.IntelligentResolver;
import com.adobe.fontengine.fontmanagement.platform.PlatformFontDescription;
import com.adobe.fontengine.fontmanagement.platform.PlatformFontResolver;
import com.adobe.fontengine.fontmanagement.platform.PlatformFontSearchAttributes;
import com.adobe.fontengine.inlineformatting.css20.FamilyNameNormalizer;
import com.adobe.fontengine.inlineformatting.css20.PassThroughFamilyNameNormalizer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;

public class PlatformFontResolverImpl
implements PlatformFontResolver {
    static final long serialVersionUID = 2L;
    private HashMap platformFonts;
    private FontResolutionPriority resolutionPriority = FontResolutionPriority.FIRST;
    private FamilyNameNormalizer normalizer;

    public PlatformFontResolverImpl() {
        this(new PassThroughFamilyNameNormalizer());
    }

    public PlatformFontResolverImpl(FamilyNameNormalizer normalizer) {
        this.platformFonts = new HashMap();
        if (normalizer == null) {
            normalizer = new PassThroughFamilyNameNormalizer();
        }
        this.normalizer = normalizer;
    }

    public PlatformFontResolverImpl(PlatformFontResolverImpl original) {
        this.platformFonts = (HashMap)original.platformFonts.clone();
        this.resolutionPriority = original.resolutionPriority;
        this.normalizer = original.normalizer;
    }

    public void addFont(Font font) throws UnsupportedFontException, InvalidFontException, FontLoadingException {
        PlatformFontDescription[] fontDesc = font.getPlatformFontDescription();
        if (fontDesc == null) {
            throw new UnsupportedFontException("No Platform Descriptions avalable for font - " + font);
        }
        for (int i = 0; i < fontDesc.length; ++i) {
            this.addFont(fontDesc[i], font);
        }
    }

    public void addFont(PlatformFontDescription fontDesc, Font font) throws UnsupportedFontException, InvalidFontException, FontLoadingException {
        Font oldFont = (Font)this.platformFonts.get(fontDesc.getPlatformName());
        if (oldFont != null) {
            Font preferredFont;
            if (this.resolutionPriority == FontResolutionPriority.FIRST) {
                return;
            }
            if ((this.resolutionPriority == FontResolutionPriority.INTELLIGENT_LAST || this.resolutionPriority == FontResolutionPriority.INTELLIGENT_FIRST) && (preferredFont = IntelligentResolver.choosePreferredFont(oldFont, font, this.resolutionPriority == FontResolutionPriority.INTELLIGENT_FIRST)) == oldFont) {
                return;
            }
        }
        this.platformFonts.put(this.normalizer.normalize(fontDesc.getPlatformName()), font);
    }

    public boolean isEmpty() {
        return this.platformFonts.isEmpty();
    }

    public FontResolutionPriority setResolutionPriority(FontResolutionPriority priority) {
        FontResolutionPriority oldPriority = this.resolutionPriority;
        this.resolutionPriority = priority;
        return oldPriority;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.platformFonts.hashCode();
        result = 31 * result + this.resolutionPriority.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlatformFontResolverImpl)) {
            return false;
        }
        PlatformFontResolverImpl other = (PlatformFontResolverImpl)obj;
        if (!this.resolutionPriority.equals(other.resolutionPriority)) {
            return false;
        }
        return this.platformFonts.equals(other.platformFonts);
    }

    public String toString() {
        TreeSet tempSet = new TreeSet();
        Iterator it = this.platformFonts.keySet().iterator();
        while (it.hasNext()) {
            tempSet.add(it.next());
        }
        StringBuffer sb = new StringBuffer();
        sb.append("priority = ");
        sb.append(this.resolutionPriority.toString());
        sb.append("; platform font descriptions = ");
        String prefix = "";
        Iterator it2 = tempSet.iterator();
        while (it2.hasNext()) {
            sb.append(prefix);
            sb.append((String)it2.next());
            prefix = ", ";
        }
        return sb.toString();
    }

    public Font findFont(PlatformFontSearchAttributes searchAttributes) {
        Font font = (Font)this.platformFonts.get(this.normalizer.normalize(searchAttributes.getPlatformName()));
        return font;
    }
}

