/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.fontmanagement;

import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.FontImpl;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.fontmanagement.FontLoader;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.ref.SoftReference;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceFont
extends FontImpl {
    static final long serialVersionUID = 1L;
    protected final URL resourceURL;
    protected final int type;
    protected final int fontID;
    protected final int fondID;
    protected String canonicalPath;
    protected long length;
    protected long lastModified;
    protected ConcurrentHashMap descCache = new ConcurrentHashMap(16, 0.75f, 1);
    protected transient SoftReference fontRef;

    public ResourceFont(URL resource, int type, int fontID, int fondID) {
        this.resourceURL = resource;
        this.type = type;
        this.fontID = fontID;
        this.fondID = fondID;
        this.initCacheTags();
    }

    public ResourceFont(URL resource, int type, int fontID, int fondID, FontData fontData) {
        this(resource, type, fontID, fondID);
        this.fontRef = new SoftReference<FontData>(fontData);
    }

    @Override
    protected synchronized FontData retrieveFontData() throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        FontData font = null;
        font = (FontData)this.fontRef.get();
        if (font == null) {
            font = FontLoader.fromResourceURL(this.resourceURL, this.type, this.fontID, this.fondID);
            this.fontRef = new SoftReference<FontData>(font);
        }
        return font;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fontID;
        result = 31 * result + this.fondID;
        result = 31 * result + (this.resourceURL == null ? 0 : this.resourceURL.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ResourceFont)) {
            return false;
        }
        ResourceFont other = (ResourceFont)obj;
        if (this.fontID != other.fontID) {
            return false;
        }
        if (this.fondID != other.fondID) {
            return false;
        }
        return !(this.resourceURL == null ? other.resourceURL != null : !this.resourceURL.equals(other.resourceURL));
    }

    @Override
    public String toString() {
        return new String(this.resourceURL.toString() + " - resource id = " + this.fontID + ", fond id = " + this.fondID);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.fontRef = new SoftReference<Object>(null);
    }

    private void initCacheTags() {
        try {
            try {
                this.canonicalPath = this.resourceURL.toURI().getPath();
                if (this.canonicalPath == null) {
                    throw new IOException("Cannot resolve path to file");
                }
                this.canonicalPath = this.canonicalPath.replace("/..namedfork/rsrc", "");
            }
            catch (URISyntaxException e) {
                throw new IOException(e.toString());
            }
            File file = new File(this.canonicalPath);
            this.canonicalPath = file.getCanonicalPath();
            this.length = file.length();
            this.lastModified = file.lastModified();
        }
        catch (IOException e) {
            this.canonicalPath = null;
            this.length = 0L;
            this.lastModified = 0L;
        }
    }

    @Override
    public String getCanonicalPath() {
        return this.canonicalPath;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public Object getCachedFontDescription(String key) {
        return this.descCache.get(key);
    }

    @Override
    public Map<String, Object> getCachedFontDescriptionMap() {
        return this.descCache;
    }

    @Override
    public void setCachedFontDescription(String key, Object value) {
        this.descCache.put(key, value);
    }
}

