/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.fontmanagement;

import com.adobe.fontengine.FontEngineException;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontByteArray;
import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.FontException;
import com.adobe.fontengine.font.FontImpl;
import com.adobe.fontengine.font.FontInputStream;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.mac.FontFactory;
import com.adobe.fontengine.font.opentype.OpenTypeFont;
import com.adobe.fontengine.font.pdffont.PDFSimpleFont;
import com.adobe.fontengine.font.type1.MetricFile;
import com.adobe.fontengine.font.type1.Type1Font;
import com.adobe.fontengine.fontmanagement.DirectoryWalker;
import com.adobe.fontengine.fontmanagement.MemoryFont;
import com.adobe.fontengine.fontmanagement.PDFSimpleFontValuesAccessor;
import com.adobe.fontengine.fontmanagement.ResourceFont;
import com.adobe.fontengine.fontmanagement.StreamFont;
import com.adobe.fontengine.fontmanagement.URLFont;
import com.adobe.fontengine.fontmanagement.fxg.FXGFontResolver;
import com.adobe.fontengine.fontmanagement.fxg.FXGFontResolverImpl;
import com.adobe.fontengine.fontmanagement.platform.PlatformFontResolver;
import com.adobe.fontengine.fontmanagement.platform.PlatformFontResolverImpl;
import com.adobe.fontengine.fontmanagement.postscript.PSNameFontDatabase;
import com.adobe.fontengine.fontmanagement.postscript.PSNameResolver;
import com.adobe.fontengine.inlineformatting.css20.FamilyNameNormalizer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FontLoader {
    private static final int kType1Font = 1;
    private static final int kOpenTypeFont = 2;
    private static final int kCFFFont = 3;
    private static final int kPFM = 4;
    private static final int kAFM = 5;
    private static final int kMacDFont = 6;
    private static final int kMacRsrcFont = 7;
    private static final int maxBytesNeeded;
    private static final int t1BN;
    private static final int otBN;
    private static final int cffBN;
    private static final int afmBN;
    private static final int pfmBN;
    private static final int macBN;
    private HashMap<String, HashMap<String, FontImpl[]>> mGlobalCacheMap = new HashMap();
    private HashMap<String, FontImpl[]> mGlobalFontMap = new HashMap();

    public static PSNameResolver getPSNameResolverInstance() {
        return new PSNameFontDatabase();
    }

    public static PSNameResolver getPSNameResolverInstance(FamilyNameNormalizer normalizer) {
        return new PSNameFontDatabase(normalizer);
    }

    public static PSNameResolver getPSNameResolverInstance(PSNameResolver original) {
        if (original instanceof PSNameFontDatabase) {
            return new PSNameFontDatabase((PSNameFontDatabase)original);
        }
        return null;
    }

    public static PlatformFontResolver getPlatformFontResolverInstance() {
        return new PlatformFontResolverImpl();
    }

    public static PlatformFontResolver getPlatformFontResolverInstance(PlatformFontResolver original) {
        if (original instanceof PlatformFontResolverImpl) {
            return new PlatformFontResolverImpl((PlatformFontResolverImpl)original);
        }
        return null;
    }

    public static PlatformFontResolver getPlatformFontResolverInstance(FamilyNameNormalizer normalizer) {
        return new PlatformFontResolverImpl(normalizer);
    }

    public static FXGFontResolver getFXGFontResolverInstance() {
        return new FXGFontResolverImpl();
    }

    public static FXGFontResolver getFXGFontResolverInstance(FXGFontResolver original) {
        if (original instanceof FXGFontResolverImpl) {
            return new FXGFontResolverImpl((FXGFontResolverImpl)original);
        }
        return null;
    }

    private static int determineFileType(FontInputStream stream, URL url) throws IOException {
        int fonttype = -1;
        byte[] bytes = new byte[maxBytesNeeded];
        int numRead = stream.read(bytes);
        if (numRead >= otBN && com.adobe.fontengine.font.opentype.FontFactory.isOpenType(bytes)) {
            fonttype = 2;
        } else if (numRead >= t1BN && com.adobe.fontengine.font.type1.FontFactory.isType1(bytes)) {
            fonttype = 1;
        } else if (numRead >= pfmBN && com.adobe.fontengine.font.type1.FontFactory.isPFM(bytes)) {
            fonttype = 4;
        } else if (numRead >= afmBN && com.adobe.fontengine.font.type1.FontFactory.isAFM(bytes)) {
            fonttype = 5;
        } else if (numRead >= cffBN && com.adobe.fontengine.font.cff.FontFactory.isCFF(bytes)) {
            fonttype = 3;
        } else if (url != null) {
            switch (FontFactory.isResourceFont(bytes, url)) {
                case 2: {
                    fonttype = 6;
                    break;
                }
                case 1: {
                    fonttype = 7;
                }
            }
        }
        if (numRead > 0) {
            stream.unread(bytes, 0, numRead);
        }
        return fonttype;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void loadFont(URL url, List t1Fonts, List metricFiles, List fontOrFontData, boolean lastVectorContainsFontData) throws IOException, InvalidFontException, UnsupportedFontException, FontLoadingException {
        FontInputStream stream = null;
        try {
            stream = new FontInputStream(url);
            switch (FontLoader.determineFileType(stream, url)) {
                case 1: {
                    Type1Font[] fontarray = com.adobe.fontengine.font.type1.FontFactory.load(stream, url);
                    if (fontarray.length != 1) {
                        return;
                    }
                    URLFont urlFont = new URLFont(url, 0, fontarray[0]);
                    t1Fonts.add(new T1AlignmentHolder(urlFont, new FontNameAlignmentData(fontarray[0].getPostscriptName())));
                    if (lastVectorContainsFontData) {
                        fontOrFontData.add(fontarray[0]);
                        return;
                    }
                    fontOrFontData.add(urlFont);
                    return;
                }
                case 2: {
                    OpenTypeFont[] fontarray = com.adobe.fontengine.font.opentype.FontFactory.load(stream);
                    int i = 0;
                    while (i < fontarray.length) {
                        if (lastVectorContainsFontData) {
                            fontOrFontData.add(fontarray[i]);
                        } else {
                            fontOrFontData.add(new URLFont(url, i, fontarray[i]));
                        }
                        ++i;
                    }
                    return;
                }
                case 3: {
                    return;
                }
                case 4: {
                    MetricFile pfm = com.adobe.fontengine.font.type1.FontFactory.loadPFM(stream, url);
                    if (pfm == null) return;
                    metricFiles.add(new MetricFileAlignmentHolder(url, new FontNameAlignmentData(pfm.getFontName()), 4, pfm));
                    return;
                }
                case 5: {
                    MetricFile afm = com.adobe.fontengine.font.type1.FontFactory.loadAFM(stream, url);
                    if (afm == null) return;
                    metricFiles.add(new MetricFileAlignmentHolder(url, new FontNameAlignmentData(afm.getFontName()), 5, afm));
                    return;
                }
                case 6: {
                    ResourceFont[] fonts = FontFactory.load(url, 2);
                    int i = 0;
                    while (i < fonts.length) {
                        fontOrFontData.add(fonts[i]);
                        ++i;
                    }
                    return;
                }
                case 7: {
                    ResourceFont[] fonts = FontFactory.load(url, 1);
                    int i = 0;
                    while (i < fonts.length) {
                        fontOrFontData.add(fonts[i]);
                        ++i;
                    }
                    return;
                }
            }
            return;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    public Font[] load(URL url) throws FontLoadingException, InvalidFontException, UnsupportedFontException {
        try {
            FontInputStream stream = new FontInputStream(url);
            switch (FontLoader.determineFileType(stream, url)) {
                case 2: {
                    OpenTypeFont[] fonts = com.adobe.fontengine.font.opentype.FontFactory.load(stream);
                    Font[] ret = new Font[fonts.length];
                    for (int i = 0; i < fonts.length; ++i) {
                        ret[i] = new URLFont(url, i, fonts[i]);
                    }
                    return ret;
                }
                case 1: {
                    Font[] ret = new Font[]{new URLFont(url, 0)};
                    return ret;
                }
                case 6: {
                    Font[] fonts = FontFactory.load(url, 2);
                    return fonts;
                }
                case 7: {
                    Font[] fonts = FontFactory.load(url, 1);
                    return fonts;
                }
            }
            return new Font[0];
        }
        catch (IOException e) {
            throw new FontLoadingException(e);
        }
    }

    public Font[] load(URL[] url, List exceptions) {
        ArrayList fonts;
        block9: {
            fonts = new ArrayList();
            ArrayList t1Fonts = new ArrayList();
            ArrayList metricFiles = new ArrayList();
            for (int i = 0; i < url.length; ++i) {
                try {
                    FontLoader.loadFont(url[i], t1Fonts, metricFiles, fonts, false);
                    continue;
                }
                catch (InvalidFontException e) {
                    if (exceptions == null) continue;
                    exceptions.add(e);
                    continue;
                }
                catch (UnsupportedFontException e) {
                    if (exceptions == null) continue;
                    exceptions.add(e);
                    continue;
                }
                catch (IOException e) {
                    if (exceptions == null) continue;
                    exceptions.add(new FontLoadingException(e));
                    continue;
                }
                catch (FontLoadingException e) {
                    if (exceptions == null) continue;
                    exceptions.add(new FontLoadingException(e));
                }
            }
            try {
                FontLoader.alignMetricFilesWithOutlines(metricFiles, t1Fonts);
            }
            catch (FontEngineException e) {
                if (exceptions == null) break block9;
                exceptions.add(e);
            }
        }
        if (fonts.isEmpty()) {
            return new Font[0];
        }
        Font[] res = new Font[fonts.size()];
        fonts.toArray(res);
        return res;
    }

    public Font[] load(URL[] url, List exceptions, List badUrls) {
        ArrayList fonts = new ArrayList();
        ArrayList t1Fonts = new ArrayList();
        ArrayList metricFiles = new ArrayList();
        for (int i = 0; i < url.length; ++i) {
            try {
                FontLoader.loadFont(url[i], t1Fonts, metricFiles, fonts, false);
                continue;
            }
            catch (FontException e) {
                if (exceptions != null) {
                    exceptions.add(e);
                }
                if (badUrls == null) continue;
                badUrls.add(url[i]);
                continue;
            }
            catch (IOException e) {
                if (exceptions != null) {
                    exceptions.add(new FontLoadingException(e));
                }
                if (badUrls == null) continue;
                badUrls.add(url[i]);
            }
        }
        FontLoader.alignMetricFilesWithOutlines(metricFiles, t1Fonts, exceptions, badUrls);
        if (fonts.isEmpty()) {
            return new Font[0];
        }
        Font[] res = new Font[fonts.size()];
        fonts.toArray(res);
        return res;
    }

    public Font load(InputStream inputStream, int length, boolean wasEmbedded) throws FontLoadingException {
        try {
            FontInputStream stream = new FontInputStream(inputStream);
            switch (FontLoader.determineFileType(stream, null)) {
                case 1: 
                case 2: 
                case 3: {
                    return new StreamFont(stream, length, wasEmbedded);
                }
            }
            return null;
        }
        catch (IOException e) {
            throw new FontLoadingException(e);
        }
        catch (InvalidFontException e) {
            throw new FontLoadingException(e);
        }
        catch (UnsupportedFontException e) {
            throw new FontLoadingException(e);
        }
    }

    public Font[] load(File f, boolean recurseDirectories, List exceptions) {
        ArrayList fonts;
        block7: {
            File next;
            DirectoryWalker w = new DirectoryWalker(f, recurseDirectories);
            ArrayList t1Fonts = new ArrayList();
            ArrayList metricFiles = new ArrayList();
            fonts = new ArrayList();
            while ((next = w.getNextFile()) != null) {
                try {
                    URL url = next.toURI().toURL();
                    FontLoader.loadFont(url, t1Fonts, metricFiles, fonts, false);
                }
                catch (FontEngineException e) {
                    if (exceptions == null) continue;
                    exceptions.add(e);
                }
                catch (IOException e) {
                    if (exceptions == null) continue;
                    exceptions.add(new FontLoadingException(e));
                }
            }
            try {
                FontLoader.alignMetricFilesWithOutlines(metricFiles, t1Fonts);
            }
            catch (FontEngineException e) {
                if (exceptions == null) break block7;
                exceptions.add(e);
            }
        }
        if (fonts.size() == 0) {
            return new URLFont[0];
        }
        Font[] handles = new Font[fonts.size()];
        fonts.toArray(handles);
        return handles;
    }

    public Font[] load(File f, boolean recurseDirectories, List exceptions, List badUrls) {
        File next;
        DirectoryWalker w = new DirectoryWalker(f, recurseDirectories);
        ArrayList t1Fonts = new ArrayList();
        ArrayList metricFiles = new ArrayList();
        ArrayList fonts = new ArrayList();
        while ((next = w.getNextFile()) != null) {
            URL url = null;
            try {
                url = next.toURI().toURL();
                FontLoader.loadFont(url, t1Fonts, metricFiles, fonts, false);
            }
            catch (FontEngineException e) {
                if (exceptions != null) {
                    exceptions.add(e);
                }
                if (badUrls == null) continue;
                badUrls.add(url);
            }
            catch (IOException e) {
                if (exceptions != null) {
                    exceptions.add(new FontLoadingException(e));
                }
                if (badUrls == null) continue;
                badUrls.add(url);
            }
        }
        FontLoader.alignMetricFilesWithOutlines(metricFiles, t1Fonts, exceptions, badUrls);
        if (fonts.size() == 0) {
            return new URLFont[0];
        }
        Font[] handles = new URLFont[fonts.size()];
        fonts.toArray(handles);
        return handles;
    }

    static FontData[] fromStream(FontInputStream stream, int size) throws IOException, InvalidFontException, UnsupportedFontException {
        switch (FontLoader.determineFileType(stream, null)) {
            case 2: {
                return com.adobe.fontengine.font.opentype.FontFactory.load(stream);
            }
            case 3: {
                FontByteArray array = new FontByteArray(stream, size);
                return com.adobe.fontengine.font.cff.FontFactory.load(array);
            }
            case 1: {
                return com.adobe.fontengine.font.type1.FontFactory.load(stream, null);
            }
        }
        return new FontData[0];
    }

    private static void alignMetricFilesWithOutlines(List metricFiles, List fonts) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        for (int mfCount = 0; mfCount < metricFiles.size(); ++mfCount) {
            MetricFileAlignmentHolder mf = (MetricFileAlignmentHolder)metricFiles.get(mfCount);
            for (int fCount = 0; fCount < fonts.size(); ++fCount) {
                MetricFile metricFile;
                T1AlignmentHolder f;
                block8: {
                    f = (T1AlignmentHolder)fonts.get(fCount);
                    if (!mf.data.dataAligns(f.data)) continue;
                    try {
                        FontInputStream stream = new FontInputStream(mf.metricFileURL);
                        if (mf.metricFileType == 4) {
                            metricFile = (MetricFile)mf.metricFile.get();
                            if (metricFile == null) {
                                metricFile = com.adobe.fontengine.font.type1.FontFactory.loadPFM(stream, mf.metricFileURL);
                            }
                            break block8;
                        }
                        if (mf.metricFileType == 5) {
                            metricFile = (MetricFile)mf.metricFile.get();
                            if (metricFile == null) {
                                metricFile = com.adobe.fontengine.font.type1.FontFactory.loadAFM(stream, mf.metricFileURL);
                            }
                            break block8;
                        }
                        throw new FontLoadingException("unexpected metric file type");
                    }
                    catch (IOException e) {
                        throw new FontLoadingException(e);
                    }
                }
                f.font.setMetricURL(mf.metricFileURL, metricFile);
            }
        }
    }

    private static void alignMetricFilesWithOutlines(List metricFiles, List fonts, List exceptions, List badUrls) {
        for (int mfCount = 0; mfCount < metricFiles.size(); ++mfCount) {
            MetricFileAlignmentHolder mf = (MetricFileAlignmentHolder)metricFiles.get(mfCount);
            for (int fCount = 0; fCount < fonts.size(); ++fCount) {
                T1AlignmentHolder f = (T1AlignmentHolder)fonts.get(fCount);
                if (!mf.data.dataAligns(f.data)) continue;
                try {
                    MetricFile metricFile;
                    FontInputStream stream = new FontInputStream(mf.metricFileURL);
                    if (mf.metricFileType == 4) {
                        metricFile = (MetricFile)mf.metricFile.get();
                        if (metricFile == null) {
                            metricFile = com.adobe.fontengine.font.type1.FontFactory.loadPFM(stream, mf.metricFileURL);
                        }
                    } else if (mf.metricFileType == 5) {
                        metricFile = (MetricFile)mf.metricFile.get();
                        if (metricFile == null) {
                            metricFile = com.adobe.fontengine.font.type1.FontFactory.loadAFM(stream, mf.metricFileURL);
                        }
                    } else {
                        throw new FontLoadingException("unexpected metric file type");
                    }
                    f.font.setMetricURL(mf.metricFileURL, metricFile);
                    continue;
                }
                catch (IOException e) {
                    if (exceptions != null) {
                        exceptions.add(new FontLoadingException(e));
                    }
                    if (badUrls == null) continue;
                    badUrls.add(f.font.outlineFileURL);
                    continue;
                }
                catch (FontException e) {
                    if (exceptions != null) {
                        exceptions.add(e);
                    }
                    if (badUrls == null) continue;
                    badUrls.add(f.font.outlineFileURL);
                }
            }
        }
    }

    static FontData[] fromURL(URL outlineFileURL, URL metricFileURL) throws InvalidFontException, UnsupportedFontException, FontLoadingException, IOException {
        ArrayList fonts = new ArrayList();
        ArrayList t1Fonts = new ArrayList();
        ArrayList metricFiles = new ArrayList();
        FontLoader.loadFont(outlineFileURL, t1Fonts, metricFiles, fonts, true);
        if (metricFileURL != null) {
            FontLoader.loadFont(metricFileURL, t1Fonts, metricFiles, fonts, true);
        }
        FontLoader.alignMetricFilesWithOutlines(metricFiles, t1Fonts);
        if (fonts.isEmpty()) {
            return new FontData[0];
        }
        FontData[] res = new FontData[fonts.size()];
        fonts.toArray(res);
        return res;
    }

    public Font load(PDFSimpleFontValuesAccessor accessor) throws InvalidFontException, UnsupportedFontException {
        return new MemoryFont(new PDFSimpleFont(accessor));
    }

    static FontData fromResourceURL(URL resourceURL, int type, int fontID, int fondID) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        return FontFactory.load(resourceURL, type, fontID, fondID);
    }

    public synchronized Font[] load(File f, boolean recurseDirectories, List exceptions, List badUrls, File cacheFile) {
        File next;
        HashMap<String, FontImpl[]> ourCache;
        ArrayList<FontImpl> fonts;
        ArrayList metricFiles;
        ArrayList t1Fonts;
        DirectoryWalker w;
        block18: {
            w = new DirectoryWalker(f, recurseDirectories);
            t1Fonts = new ArrayList();
            metricFiles = new ArrayList();
            fonts = new ArrayList<FontImpl>();
            ourCache = null;
            try {
                ourCache = this.initializeCacheFile(cacheFile);
            }
            catch (IOException e) {
                if (exceptions == null) break block18;
                exceptions.add(e);
            }
        }
        while ((next = w.getNextFile()) != null) {
            URL url = null;
            try {
                if (ourCache != null) {
                    String canonicalPath = next.getCanonicalPath();
                    FontImpl[] localFileNode = ourCache.get(canonicalPath);
                    FontImpl[] globalFileNode = this.mGlobalFontMap.get(canonicalPath);
                    if ((globalFileNode = this.mergeFileNodes(next, localFileNode, globalFileNode)) == null) {
                        int oldSize;
                        block19: {
                            url = next.toURI().toURL();
                            oldSize = fonts.size();
                            try {
                                FontLoader.loadFont(url, t1Fonts, metricFiles, fonts, false);
                            }
                            catch (FontEngineException e) {
                                if (exceptions != null) {
                                    exceptions.add(e);
                                }
                                if (badUrls == null) break block19;
                                badUrls.add(url);
                            }
                        }
                        globalFileNode = new FontImpl[fonts.size() - oldSize];
                        for (int i = 0; i < fonts.size() - oldSize; ++i) {
                            FontImpl fontImpl;
                            globalFileNode[i] = fontImpl = (FontImpl)fonts.get(oldSize + i);
                        }
                    } else {
                        for (int i = 0; i < globalFileNode.length; ++i) {
                            FontImpl fontImpl = globalFileNode[i];
                            fonts.add(fontImpl);
                        }
                    }
                    ourCache.put(canonicalPath, globalFileNode);
                    this.mGlobalFontMap.put(canonicalPath, globalFileNode);
                    for (HashMap<String, FontImpl[]> oneCache : this.mGlobalCacheMap.values()) {
                        if (oneCache == ourCache || !oneCache.containsKey(canonicalPath)) continue;
                        oneCache.put(canonicalPath, globalFileNode);
                    }
                    continue;
                }
                url = next.toURI().toURL();
                FontLoader.loadFont(url, t1Fonts, metricFiles, fonts, false);
            }
            catch (FontEngineException e) {
                if (exceptions != null) {
                    exceptions.add(e);
                }
                if (badUrls == null) continue;
                badUrls.add(url);
            }
            catch (IOException e) {
                if (exceptions != null) {
                    exceptions.add(new FontLoadingException(e));
                }
                if (badUrls == null) continue;
                badUrls.add(url);
            }
        }
        FontLoader.alignMetricFilesWithOutlines(metricFiles, t1Fonts, exceptions, badUrls);
        if (fonts.size() == 0) {
            return new URLFont[0];
        }
        Font[] handles = new Font[fonts.size()];
        fonts.toArray(handles);
        return handles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<String, FontImpl[]> initializeCacheFile(File cacheFile) throws IOException {
        HashMap fontCache = null;
        if (cacheFile == null) {
            return fontCache;
        }
        if (!cacheFile.exists() && !cacheFile.createNewFile()) {
            throw new IOException("Cannot create font cache");
        }
        if (!cacheFile.canRead()) {
            throw new IOException("Cannot read font cache");
        }
        if (!cacheFile.canWrite()) {
            throw new IOException("Cannot write font cache");
        }
        String cachePath = cacheFile.getCanonicalPath();
        if (this.mGlobalCacheMap.containsKey(cachePath)) {
            fontCache = this.mGlobalCacheMap.get(cachePath);
        } else {
            if (cacheFile.length() != 0L) {
                FileInputStream fileInStm = null;
                ObjectInputStream objInStm = null;
                try {
                    fileInStm = new FileInputStream(cacheFile);
                    objInStm = new ObjectInputStream(fileInStm);
                    fontCache = (HashMap)objInStm.readObject();
                }
                catch (ClassNotFoundException e) {
                }
                catch (IOException e) {
                }
                finally {
                    if (objInStm != null) {
                        objInStm.close();
                    } else if (fileInStm != null) {
                        fileInStm.close();
                    }
                }
            }
            if (fontCache == null) {
                cacheFile.delete();
                cacheFile.createNewFile();
                fontCache = new HashMap();
            }
            this.mGlobalCacheMap.put(cachePath, fontCache);
        }
        return fontCache;
    }

    private FontImpl[] mergeFileNodes(File fontFile, FontImpl[] localFileNode, FontImpl[] globalFileNode) throws IOException {
        FontImpl implZero;
        if (localFileNode != null && localFileNode.length > 0 && ((implZero = localFileNode[0]).getLength() != fontFile.length() || implZero.getLastModified() != fontFile.lastModified())) {
            localFileNode = null;
        }
        if (globalFileNode == null) {
            return localFileNode;
        }
        if (localFileNode != null) {
            if (localFileNode.length != globalFileNode.length) {
                return null;
            }
            for (int i = 0; i < localFileNode.length; ++i) {
                FontImpl localImpl = localFileNode[i];
                FontImpl globalImpl = globalFileNode[i];
                for (String key : localImpl.getCachedFontDescriptionMap().keySet()) {
                    if (globalImpl.getCachedFontDescription(key) != null) continue;
                    globalImpl.setCachedFontDescription(key, localImpl.getCachedFontDescription(key));
                }
            }
        }
        return globalFileNode;
    }

    public synchronized void saveAllCaches(boolean clean) throws IOException {
        for (String cachePath : this.mGlobalCacheMap.keySet()) {
            File cacheFile = new File(cachePath);
            this.saveCache(cacheFile, clean);
        }
    }

    public synchronized boolean saveCache(File cacheFile, boolean clean) throws IOException {
        String cachePath = cacheFile.getCanonicalPath();
        HashMap<String, FontImpl[]> oneCache = this.mGlobalCacheMap.get(cachePath);
        if (oneCache != null) {
            if (clean) {
                Iterator<String> iter = oneCache.keySet().iterator();
                while (iter.hasNext()) {
                    String key = iter.next();
                    if (this.mGlobalFontMap.containsKey(key)) continue;
                    iter.remove();
                }
            }
            cacheFile.delete();
            cacheFile.createNewFile();
            FileOutputStream fileOutStm = new FileOutputStream(cacheFile);
            ObjectOutputStream objOutStm = new ObjectOutputStream(fileOutStm);
            objOutStm.writeObject(oneCache);
            objOutStm.close();
            return true;
        }
        return false;
    }

    public synchronized boolean decommissionCachedFont(File fontFile) throws IOException {
        boolean removed;
        String fontPath = fontFile.getCanonicalPath();
        boolean bl = removed = this.mGlobalFontMap.remove(fontPath) != null;
        if (removed) {
            for (HashMap<String, FontImpl[]> oneCache : this.mGlobalCacheMap.values()) {
                oneCache.remove(fontPath);
            }
        }
        return removed;
    }

    public synchronized void decommissionAllCaches() {
        this.mGlobalCacheMap.clear();
        this.mGlobalFontMap.clear();
    }

    public synchronized boolean decommissionCache(File cacheFile) {
        try {
            String cachePath = cacheFile.getCanonicalPath();
            HashMap<String, FontImpl[]> oneCache = this.mGlobalCacheMap.remove(cachePath);
            if (oneCache != null) {
                for (String fontPath : oneCache.keySet()) {
                    boolean foundOtherReference = false;
                    for (HashMap<String, FontImpl[]> otherCache : this.mGlobalCacheMap.values()) {
                        if (!otherCache.containsKey(fontPath)) continue;
                        foundOtherReference = true;
                        break;
                    }
                    if (foundOtherReference) continue;
                    this.mGlobalFontMap.remove(fontPath);
                }
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    static {
        t1BN = com.adobe.fontengine.font.type1.FontFactory.getNumBytesNeededToIdentify();
        otBN = com.adobe.fontengine.font.opentype.FontFactory.getNumBytesNeededToIdentify();
        cffBN = com.adobe.fontengine.font.cff.FontFactory.getNumBytesNeededToIdentify();
        afmBN = com.adobe.fontengine.font.type1.FontFactory.getNumBytesNeededToIdentifyAFM();
        pfmBN = com.adobe.fontengine.font.type1.FontFactory.getNumBytesNeededToIdentifyPFM();
        macBN = FontFactory.getNumBytesNeededToIdentify();
        int mbn = pfmBN;
        if (mbn < otBN) {
            mbn = otBN;
        }
        if (mbn < cffBN) {
            mbn = cffBN;
        }
        if (mbn < t1BN) {
            mbn = t1BN;
        }
        if (mbn < afmBN) {
            mbn = afmBN;
        }
        if (mbn < macBN) {
            mbn = macBN;
        }
        maxBytesNeeded = mbn;
    }

    private static class MetricFileAlignmentHolder {
        final URL metricFileURL;
        final MetricFileAlignmentData data;
        final int metricFileType;
        final SoftReference metricFile;

        MetricFileAlignmentHolder(URL metricFileURL, MetricFileAlignmentData data, int metricFileType, MetricFile metricFile) {
            this.metricFileURL = metricFileURL;
            this.data = data;
            this.metricFileType = metricFileType;
            this.metricFile = new SoftReference<MetricFile>(metricFile);
        }
    }

    private static class T1AlignmentHolder {
        final URLFont font;
        final MetricFileAlignmentData data;

        T1AlignmentHolder(URLFont font, MetricFileAlignmentData data) {
            this.font = font;
            this.data = data;
        }
    }

    private static class FontNameAlignmentData
    implements MetricFileAlignmentData {
        private final String fontName;

        FontNameAlignmentData(String fontName) {
            this.fontName = fontName;
        }

        public boolean dataAligns(MetricFileAlignmentData data) {
            return data instanceof FontNameAlignmentData && ((FontNameAlignmentData)data).fontName.equals(this.fontName);
        }
    }

    static interface MetricFileAlignmentData {
        public boolean dataAligns(MetricFileAlignmentData var1);
    }
}

