/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.postscript;

import com.adobe.fontengine.font.UnsupportedFontException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.MissingResourceException;

public final class CIDtoUnicode
implements Serializable {
    static final long serialVersionUID = 1L;
    String registry;
    String ordering;
    int[] map;

    public CIDtoUnicode(String registry, String ordering, int[] map) {
        this.registry = registry;
        this.ordering = ordering;
        this.map = new int[map.length];
        System.arraycopy(map, 0, this.map, 0, map.length);
    }

    public int cid2usv(int cid) {
        if (cid >= this.map.length) {
            return -1;
        }
        return this.map[cid];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CIDtoUnicode get(String registry, String ordering) throws MissingResourceException, UnsupportedFontException {
        CIDtoUnicode cIDtoUnicode;
        InputStream is = CIDtoUnicode.class.getResourceAsStream("cid2usv_" + registry + "_" + ordering);
        if (is == null) {
            throw new UnsupportedFontException("Cannot convert from " + registry + "-" + ordering + " to Unicode");
        }
        ObjectInputStream ois = new ObjectInputStream(is);
        try {
            cIDtoUnicode = (CIDtoUnicode)ois.readObject();
        }
        catch (Throwable throwable) {
            MissingResourceException ee;
            try {
                ois.close();
                throw throwable;
            }
            catch (IOException e) {
                ee = new MissingResourceException("", "", "");
                ee.initCause(e);
                throw ee;
            }
            catch (ClassNotFoundException e) {
                ee = new MissingResourceException("", "", "");
                ee.initCause(e);
                throw ee;
            }
        }
        ois.close();
        return cIDtoUnicode;
    }
}

